/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.internal.ComparisonStrategy;

class IterableDiff {
    private final ComparisonStrategy comparisonStrategy;
    List<Object> unexpected;
    List<Object> missing;

    static IterableDiff diff(Iterable<Object> actual, Iterable<Object> expected, ComparisonStrategy comparisonStrategy) {
        return new IterableDiff(actual, expected, comparisonStrategy);
    }

    IterableDiff(Iterable<Object> actual, Iterable<Object> expected, ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
        this.unexpected = Collections.unmodifiableList(this.unexpectedElements(actual, expected));
        this.missing = Collections.unmodifiableList(this.missingElements(actual, expected));
    }

    boolean differencesFound() {
        return !this.unexpected.isEmpty() || !this.missing.isEmpty();
    }

    private List<Object> missingElements(Iterable<Object> actual, Iterable<Object> expected) {
        ArrayList<Object> missing = new ArrayList<Object>();
        for (Object element : expected) {
            if (this.iterableContains(actual, element)) continue;
            missing.add(element);
        }
        return missing;
    }

    private List<Object> unexpectedElements(Iterable<Object> actual, Iterable<Object> expected) {
        ArrayList<Object> unexpected = new ArrayList<Object>();
        for (Object actualElement : actual) {
            if (this.iterableContains(expected, actualElement)) continue;
            unexpected.add(actualElement);
        }
        return unexpected;
    }

    private boolean iterableContains(Iterable<?> actual, Object value) {
        return this.comparisonStrategy.iterableContains(actual, value);
    }
}

