/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation.validatorcontext;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.validation.validatorcontext.Dummy;
import org.hibernate.beanvalidation.tck.tests.validation.validatorcontext.DummyBean;
import org.hibernate.beanvalidation.tck.tests.validation.validatorcontext.DummyValidator;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ConstraintValidatorContextTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ConstraintValidatorContextTest.webArchiveBuilder().withTestClassPackage(ConstraintValidatorContextTest.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="p")
    public void testDefaultError() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DummyValidator.disableDefaultError(false);
        DummyValidator.setCustomErrorMessages(null);
        DummyBean bean = new DummyBean("foobar");
        Set constraintViolations = validator.validate((Object)bean, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Dummy.class).withMessage("dummy message"));
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="u")
    public void testDisableDefaultErrorWithoutAddingCustomError() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DummyValidator.disableDefaultError(true);
        HashMap<String, String> errors = new HashMap<String, String>();
        DummyValidator.setCustomErrorMessages(errors);
        DummyBean bean = new DummyBean("foobar");
        validator.validate((Object)bean, new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="q")})
    public void testDisableDefaultErrorWithCustomErrorNoSubNode() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DummyValidator.disableDefaultError(true);
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.put(null, "message1");
        DummyValidator.setCustomErrorMessages(errors);
        DummyBean bean = new DummyBean("foobar");
        Set constraintViolations = validator.validate((Object)bean, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Dummy.class).withMessage("message1").withProperty("value"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="q"), @SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="t")})
    public void testDisableDefaultErrorWithCustomErrorWithSubNode() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DummyValidator.disableDefaultError(true);
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.put("subnode", "subnode message");
        DummyValidator.setCustomErrorMessages(errors);
        DummyBean bean = new DummyBean("foobar");
        Set constraintViolations = validator.validate((Object)bean, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Dummy.class).withMessage("subnode message").withPropertyPath(ConstraintViolationAssert.pathWith().property("value").property("subnode")));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="q"), @SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="t")})
    public void propertyPathInIterable() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Group group = new Group(Gender.MALE, new Person(Gender.FEMALE));
        Set constraintViolations = validator.validate((Object)group, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(CompatiblePersons.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("persons").property(null, true, null, 0)));
    }

    @CompatiblePersons
    private class Group {
        Gender gender;
        List<Person> persons = new ArrayList<Person>();

        public Group(Gender gender, Person ... persons) {
            this.gender = gender;
            this.persons.addAll(Arrays.asList(persons));
        }
    }

    private static enum Gender {
        MALE,
        FEMALE;

    }

    private class Person {
        Gender gender;

        public Person(Gender gender) {
            this.gender = gender;
        }
    }

    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={CompatiblePersonsValidator.class})
    @Documented
    public static @interface CompatiblePersons {
        public String message() default "";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    public static class CompatiblePersonsValidator
    implements ConstraintValidator<CompatiblePersons, Group> {
        public boolean isValid(Group group, ConstraintValidatorContext constraintValidatorContext) {
            if (group == null) {
                return true;
            }
            constraintValidatorContext.disableDefaultConstraintViolation();
            for (int index = 0; index < group.persons.size(); ++index) {
                Person person = group.persons.get(index);
                if (group.gender.equals((Object)person.gender)) continue;
                constraintValidatorContext.buildConstraintViolationWithTemplate("constraints.CompatiblePersons.gender.message").addNode("persons").addNode(null).inIterable().atIndex(Integer.valueOf(index)).addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

