/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider;

import jakarta.validation.ParameterNameProvider;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.executable.ExecutableValidator;
import java.lang.reflect.Method;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider.BrokenCustomParameterNameProvider;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider.CustomParameterNameProvider;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider.User;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ParameterNameProviderTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ParameterNameProviderTest.webArchiveBuilder().withTestClass(ParameterNameProviderTest.class)).withClass(CustomParameterNameProvider.class)).withClass(BrokenCustomParameterNameProvider.class)).withClass(User.class)).build();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class}, expectedExceptionsMessageRegExp="Exception in ParameterNameProvider")
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-parameterconstraints-namingparameters", id="b")
    public void testExceptionInParameterNameProviderIsWrappedIntoValidationException() throws Throwable {
        Validator validator = TestUtil.getConfigurationUnderTest().parameterNameProvider((ParameterNameProvider)new BrokenCustomParameterNameProvider()).buildValidatorFactory().getValidator();
        try {
            User object = new User();
            Method method = User.class.getMethod("setNames", String.class, String.class);
            Object[] parameters = new Object[]{null, null};
            validator.forExecutables().validateParameters((Object)object, method, parameters, new Class[0]);
            Assert.fail((String)"Expected exception wasn't thrown");
        }
        catch (ValidationException e) {
            throw e.getCause();
        }
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-validatorfactory", id="e")
    public void testGetParameterNameProviderFromValidatorFactory() {
        BrokenCustomParameterNameProvider parameterNameProvider = new BrokenCustomParameterNameProvider();
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().parameterNameProvider((ParameterNameProvider)parameterNameProvider).buildValidatorFactory();
        Assert.assertSame((Object)validatorFactory.getParameterNameProvider(), (Object)parameterNameProvider, (String)"getParameterNameProvider() should return the parameter name provider set via configuration");
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-validatorfactory", id="g")
    public void testParameterNameProviderSetUsingContext() throws Exception {
        User object = new User();
        Method method = User.class.getMethod("setNames", String.class, String.class);
        Object[] parameters = new Object[]{null, null};
        ExecutableValidator executableValidator = TestUtil.getValidatorFactoryUnderTest().usingContext().parameterNameProvider((ParameterNameProvider)new CustomParameterNameProvider()).getValidator().forExecutables();
        Set constraintViolations = executableValidator.validateParameters((Object)object, method, parameters, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setNames").parameter("param0", 0)), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setNames").parameter("param1", 1)));
    }
}

