/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation.graphnavigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.Address;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.OrderLine;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.User;

public class Order {
    @NotNull
    Integer orderId;
    @Valid
    private List<OrderLine> orderLines = new ArrayList<OrderLine>();
    @Valid
    private User customer;
    @Valid
    private Address shippingAddress;
    @Valid
    private Address billingAddress;

    public Order(Integer id) {
        this.orderId = id;
    }

    public void addOrderLine(OrderLine orderLine) {
        this.orderLines.add(orderLine);
    }

    public List<OrderLine> getOrderLines() {
        return Collections.unmodifiableList(this.orderLines);
    }

    public User getCustomer() {
        return this.customer;
    }

    public void setCustomer(User customer) {
        this.customer = customer;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public String toString() {
        return "Order{orderId=" + this.orderId + ", orderLines=" + this.orderLines + ", customer=" + this.customer + ", shippingAddress=" + this.shippingAddress + ", billingAddress=" + this.billingAddress + '}';
    }
}

