/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation.groupconversion;

import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.groups.ConvertGroup;
import javax.validation.groups.Default;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.Address;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.BasicPostal;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.Complex;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.ComplexPostal;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.PostalSequence;

public class User {
    @Valid
    @ConvertGroup(from=Default.class, to=BasicPostal.class)
    private Address mainAddress;
    private List<Address> shipmentAddresses;
    @Valid
    @ConvertGroup.List(value={@ConvertGroup(from=Default.class, to=BasicPostal.class), @ConvertGroup(from=Complex.class, to=ComplexPostal.class)})
    private @Valid @ConvertGroup.List(value={@ConvertGroup(from=Default.class, to=BasicPostal.class), @ConvertGroup(from=Complex.class, to=ComplexPostal.class)}) Address preferredShipmentAddress;
    @Valid
    @ConvertGroup.List(value={@ConvertGroup(from=Default.class, to=BasicPostal.class), @ConvertGroup(from=BasicPostal.class, to=ComplexPostal.class)})
    private @Valid @ConvertGroup.List(value={@ConvertGroup(from=Default.class, to=BasicPostal.class), @ConvertGroup(from=BasicPostal.class, to=ComplexPostal.class)}) Address officeAddress;
    @Valid
    @ConvertGroup(from=Default.class, to=PostalSequence.class)
    private Address weekendAddress;

    @Valid
    @ConvertGroup(from=Default.class, to=BasicPostal.class)
    public User(@Valid @ConvertGroup(from=Default.class, to=BasicPostal.class) Address mainAddress) {
        this.mainAddress = mainAddress;
        this.shipmentAddresses = Collections.emptyList();
    }

    public User(Address mainAddress, List<Address> shipmentAddresses, Address preferredShipmentAddress, Address officeAddress, Address weekendAddress) {
        this.mainAddress = mainAddress;
        this.shipmentAddresses = shipmentAddresses;
        this.preferredShipmentAddress = preferredShipmentAddress;
        this.officeAddress = officeAddress;
        this.weekendAddress = weekendAddress;
    }

    public void setMainAddress(@Valid @ConvertGroup(from=Default.class, to=BasicPostal.class) Address mainAddress) {
        this.mainAddress = mainAddress;
    }

    public void setShipmentAddresses(List<Address> shipmentAddresses) {
        this.shipmentAddresses = shipmentAddresses;
    }

    @Valid
    @ConvertGroup(from=Default.class, to=BasicPostal.class)
    public List<Address> getShipmentAddresses() {
        return this.shipmentAddresses;
    }

    public void setPreferredShipmentAddress(Address preferredShipmentAddress) {
        this.preferredShipmentAddress = preferredShipmentAddress;
    }

    public void setOfficeAddress(Address officeAddress) {
        this.officeAddress = officeAddress;
    }

    public void setWeekendAddress(Address weekendAddress) {
        this.weekendAddress = weekendAddress;
    }

    public Address getWeekendAddress() {
        return this.weekendAddress;
    }

    @Valid
    @ConvertGroup(from=Default.class, to=BasicPostal.class)
    public Address retrieveMainAddress() {
        return this.mainAddress;
    }

    public Address retrieveWeekendAddress() {
        return this.weekendAddress;
    }
}

