/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.decorators.definition.lifecycle;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import org.jboss.cdi.tck.tests.decorators.definition.lifecycle.BankAccount;
import org.jboss.cdi.tck.tests.decorators.definition.lifecycle.DurableAccount;
import org.jboss.cdi.tck.util.ActionSequence;

@Decorator
public abstract class ChargeDecorator
implements BankAccount,
Serializable {
    private static final int WITHDRAWAL_CHARGE = 5;
    public static int charged = 0;
    @Inject
    @Delegate
    private BankAccount account;

    @Override
    public void withdraw(int amount) {
        this.account.withdraw(amount + 5);
        charged += 5;
    }

    public static void reset() {
        charged = 0;
    }

    @PostConstruct
    public void postConstruct() {
        ActionSequence.addAction("postConstructCallers", DurableAccount.class.getName());
    }

    @PreDestroy
    public void preDestroy() {
        ActionSequence.addAction("preDestroyCallers", DurableAccount.class.getName());
    }
}

