/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.ContextService;

import ee.jakarta.tck.concurrent.api.ContextService.TestRunnableWork;
import ee.jakarta.tck.concurrent.api.ContextService.TestWorkInterface;
import ee.jakarta.tck.concurrent.framework.ArquillianTests;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class ContextServiceTests
extends ArquillianTests {
    private static final TestLogger log = TestLogger.get(ContextServiceTests.class);

    @Deployment(name="ContextServiceTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{ContextServiceTests.getFrameworkPackage(), ContextServiceTests.class.getPackage()});
    }

    @Test
    public void ContextServiceWithIntf() {
        boolean pass = false;
        try {
            Runnable proxy = (Runnable)TestUtil.getContextService().createContextualProxy((Object)new TestRunnableWork(), Runnable.class);
            pass = true;
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void ContextServiceWithIntfAndIntfNoImplemented() {
        boolean pass = false;
        try {
            Object object = TestUtil.getContextService().createContextualProxy(new Object(), new Class[]{Runnable.class});
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void ContextServiceWithIntfAndInstanceIsNull() {
        boolean pass = false;
        try {
            Object proxy = TestUtil.getContextService().createContextualProxy(null, Runnable.class);
            log.info(proxy.toString());
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void ContextServiceWithMultiIntfs() {
        boolean pass = false;
        try {
            Object proxy = TestUtil.getContextService().createContextualProxy((Object)new TestRunnableWork(), new Class[]{Runnable.class, TestWorkInterface.class});
            pass = proxy instanceof Runnable && proxy instanceof TestWorkInterface;
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void ContextServiceWithMultiIntfsAndIntfNoImplemented() {
        boolean pass = false;
        try {
            Object object = TestUtil.getContextService().createContextualProxy((Object)new TestRunnableWork(), new Class[]{Runnable.class, TestWorkInterface.class, ManagedTaskListener.class});
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void ContextServiceWithMultiIntfsAndInstanceIsNull() {
        boolean pass = false;
        try {
            Object proxy = TestUtil.getContextService().createContextualProxy(null, new Class[]{Runnable.class, TestWorkInterface.class});
            log.info(proxy.toString());
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void ContextServiceWithIntfAndProperties() {
        boolean pass = false;
        try {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Runnable proxy = (Runnable)TestUtil.getContextService().createContextualProxy((Object)new TestRunnableWork(), execProps, Runnable.class);
            pass = true;
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void ContextServiceWithMultiIntfsAndProperties() {
        boolean pass = false;
        try {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object proxy = TestUtil.getContextService().createContextualProxy((Object)new TestRunnableWork(), execProps, new Class[]{Runnable.class, TestWorkInterface.class});
            pass = proxy instanceof Runnable && proxy instanceof TestWorkInterface;
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void ContextServiceWithIntfAndPropertiesAndIntfNoImplemented() {
        boolean pass = false;
        try {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object object = TestUtil.getContextService().createContextualProxy((Object)new TestRunnableWork(), execProps, new Class[]{Runnable.class, ManagedTaskListener.class});
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void ContextServiceWithIntfsAndPropertiesAndInstanceIsNull() {
        boolean pass = false;
        try {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object proxy = TestUtil.getContextService().createContextualProxy(null, execProps, Runnable.class);
            log.info(proxy.toString());
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void ContextServiceWithMultiIntfsAndPropertiesAndIntfNoImplemented() {
        boolean pass = false;
        try {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object object = TestUtil.getContextService().createContextualProxy((Object)new TestRunnableWork(), execProps, new Class[]{Runnable.class, TestWorkInterface.class, ManagedTaskListener.class});
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void ContextServiceWithMultiIntfsAndPropertiesAndInstanceIsNull() {
        boolean pass = false;
        try {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object proxy = TestUtil.getContextService().createContextualProxy(null, execProps, new Class[]{Runnable.class, TestWorkInterface.class});
            log.info(proxy.toString());
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void GetExecutionProperties() {
        boolean pass = false;
        try {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object proxy = TestUtil.getContextService().createContextualProxy((Object)new TestRunnableWork(), execProps, new Class[]{Runnable.class, TestWorkInterface.class});
            Map returnedExecProps = TestUtil.getContextService().getExecutionProperties(proxy);
            if (!"true".equals(returnedExecProps.get("USE_PARENT_TRANSACTION"))) {
                log.severe("Expected:true, actual message=" + (String)returnedExecProps.get("USE_PARENT_TRANSACTION"));
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void GetExecutionPropertiesNoProxy() {
        boolean pass = false;
        try {
            Map returnedExecProps = TestUtil.getContextService().getExecutionProperties(new Object());
            pass = true;
        }
        catch (IllegalArgumentException ie) {
            pass = true;
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }
}

