/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedExecutorService.tx;

import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import ee.jakarta.tck.concurrent.spec.ManagedExecutorService.tx.CancelledTransactedTask;
import ee.jakarta.tck.concurrent.spec.ManagedExecutorService.tx.TransactedTask;
import ee.jakarta.tck.concurrent.spec.ManagedExecutorService.tx.Util;
import jakarta.annotation.Resource;
import jakarta.annotation.sql.DataSourceDefinition;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.testng.Assert;

@WebServlet(value={"/TransactionServlet"})
@DataSourceDefinition(name="java:comp/env/jdbc/ManagedExecutorServiceDB", className="org.apache.derby.jdbc.EmbeddedDataSource", databaseName="memory:ManagedExecutorServiceDB", properties={"createDatabase=create"})
public class TransactionServlet
extends TestServlet {
    private static final TestLogger log = TestLogger.get(TransactionServlet.class);
    @Resource(lookup="java:comp/env/jdbc/ManagedExecutorServiceDB")
    private DataSource ds;

    @Override
    protected void beforeClass() throws RemoteException {
        log.enter("beforeClass", new Object[0]);
        try (Connection conn = Util.getConnection(this.ds, "user1", "password1", true);
             Statement stmt = conn.createStatement();){
            try {
                stmt.executeUpdate("drop table concurrencetable");
            }
            catch (SQLException e) {
                log.finest("Could not drop table, assume table did not exist.");
            }
            stmt.executeUpdate("create table concurrencetable (TYPE_ID int NOT NULL, TYPE_DESC varchar(32), primary key(TYPE_ID))");
            log.exit("beforeClass", new Object[0]);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void transactionTest(HttpServletRequest req, HttpServletResponse res) throws Exception {
        boolean isCommit = Boolean.parseBoolean(req.getParameter("isCommit"));
        Future taskResult = TestUtil.getManagedExecutorService().submit((Runnable)new TransactedTask(isCommit, "user1", "password1", "insert into concurrencetable values(?, ?)"));
        TestUtil.waitForTaskComplete(taskResult);
    }

    public void cancelTest() {
        int originTableCount = Util.getCount("concurrencetable", "user1", "password1");
        CancelledTransactedTask cancelledTask = new CancelledTransactedTask("user1", "password1", "insert into concurrencetable values(?, ?)");
        Future future = TestUtil.getManagedExecutorService().submit((Runnable)cancelledTask);
        Util.waitForTransactionBegan(cancelledTask);
        cancelledTask.cancelTask();
        cancelledTask.resume();
        TestUtil.waitForTaskComplete(future);
        int afterTransacted = Util.getCount("concurrencetable", "user1", "password1");
        Assert.assertEquals((int)originTableCount, (int)afterTransacted, (String)"task was not properly cancelled");
    }
}

