/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.ManagedTaskListener;

import ee.jakarta.tck.concurrent.api.ManagedTaskListener.RunnableTaskWithException;
import ee.jakarta.tck.concurrent.common.managed.task.listener.ListenerEvent;
import ee.jakarta.tck.concurrent.common.managed.task.listener.ManagedTaskListenerImpl;
import ee.jakarta.tck.concurrent.common.managed.task.listener.RunnableTaskWithStatus;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedExecutors;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Future;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;

@Web
@Common(value={Common.PACKAGE.MANAGED_TASK_LISTENER, Common.PACKAGE.TASKS})
public class ManagedTaskListenerTests {
    private static final TestLogger log = TestLogger.get(ManagedTaskListenerTests.class);
    private ManagedTaskListenerImpl managedTaskListener = new ManagedTaskListenerImpl();
    @Resource(lookup="java:comp/DefaultManagedExecutorService")
    private ManagedExecutorService executor;

    @Deployment(name="ManagedTaskListenerTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{ManagedTaskListenerTests.class.getPackage()});
    }

    @AfterEach
    public void cleanup() {
        this.managedTaskListener.clearEvents();
    }

    @Assertion(id="JAVADOC:38 SPEC:7 SPEC:7.1 SPEC:45.3", strategy="taskAborted of ManagedTaskListener is Called when a task's Future has been cancelled anytime during the life of a task.")
    public void taskAborted() throws InterruptedException {
        Duration blockTime = Duration.ofMillis(3000L);
        RunnableTaskWithStatus runnableTask = new RunnableTaskWithStatus(this.managedTaskListener, blockTime);
        Runnable taskWithListener = ManagedExecutors.managedTask((Runnable)runnableTask, (ManagedTaskListener)this.managedTaskListener);
        Future futureResult = this.executor.submit(taskWithListener);
        Wait.sleep(Duration.ofMillis(1000L));
        futureResult.cancel(true);
        Wait.waitForListenerComplete(this.managedTaskListener, TestConstants.waitTimeout.plus(blockTime), TestConstants.pollInterval);
        List<ListenerEvent> events = this.managedTaskListener.events();
        Assertions.assertTrue((boolean)events.contains((Object)ListenerEvent.ABORTED), (String)"Listener taskAborted failed");
        Assertions.assertTrue((boolean)futureResult.isCancelled(), (String)"Listener taskAborted failed");
    }

    @Assertion(id="JAVADOC:39 SPEC:13.3 SPEC:45.3", strategy="TaskDone is called when a submitted task has completed running, either successfully or failed.")
    public void taskDone() throws InterruptedException {
        Duration blockTime = Duration.ofMillis(3000L);
        RunnableTaskWithStatus taskToCancelled = new RunnableTaskWithStatus(this.managedTaskListener, blockTime);
        Runnable taskToCancelledWithListener = ManagedExecutors.managedTask((Runnable)taskToCancelled, (ManagedTaskListener)this.managedTaskListener);
        Future futureResult = this.executor.submit(taskToCancelledWithListener);
        Wait.sleep(Duration.ofMillis(1000L));
        futureResult.cancel(true);
        Wait.waitForListenerComplete(this.managedTaskListener, TestConstants.waitTimeout.plus(blockTime), TestConstants.pollInterval);
        List<ListenerEvent> events = this.managedTaskListener.events();
        Assertions.assertTrue((boolean)events.contains((Object)ListenerEvent.DONE), (String)"Listener taskDone failed in cancel case");
        this.managedTaskListener.clearEvents();
        RunnableTaskWithStatus runTask = new RunnableTaskWithStatus(this.managedTaskListener);
        Runnable runtaskWithListener = ManagedExecutors.managedTask((Runnable)runTask, (ManagedTaskListener)this.managedTaskListener);
        this.executor.submit(runtaskWithListener);
        Wait.waitForListenerComplete(this.managedTaskListener);
        List<ListenerEvent> runevents = this.managedTaskListener.events();
        Assertions.assertTrue((boolean)runevents.contains((Object)ListenerEvent.DONE), (String)"Listener TaskDone failed");
        this.managedTaskListener.clearEvents();
        RunnableTaskWithException taskWithException = new RunnableTaskWithException(this.managedTaskListener);
        Runnable taskWithExceptionListener = ManagedExecutors.managedTask((Runnable)taskWithException, (ManagedTaskListener)this.managedTaskListener);
        this.executor.submit(taskWithExceptionListener);
        Wait.waitForListenerComplete(this.managedTaskListener);
        List<ListenerEvent> runeventsWithException = this.managedTaskListener.events();
        log.fine("++ runeventsWithException : " + runeventsWithException);
        Assertions.assertTrue((boolean)runeventsWithException.contains((Object)ListenerEvent.DONE), (String)"Listener TaskDone failed with exception task.");
    }

    @Assertion(id="JAVADOC:40 SPEC:7 SPEC:7.3 SPEC:45.3", strategy="TaskStarting is called before the task is about to start. The task will not enter the starting state until the taskSubmitted listener has completed.")
    public void taskStarting() {
        RunnableTaskWithStatus runnableTask = new RunnableTaskWithStatus(this.managedTaskListener);
        Runnable taskWithListener = ManagedExecutors.managedTask((Runnable)runnableTask, (ManagedTaskListener)this.managedTaskListener);
        this.executor.submit(taskWithListener);
        Wait.waitForListenerComplete(this.managedTaskListener);
        List<ListenerEvent> events = this.managedTaskListener.events();
        int submitAt = events.indexOf((Object)ListenerEvent.SUBMITTED);
        int startAt = events.indexOf((Object)ListenerEvent.STARTING);
        int runAt = events.indexOf((Object)ListenerEvent.TASK_RUN);
        if ((submitAt != 0 || startAt != 1) && runAt == 2) {
            Assertions.fail((String)"Listener TaskStarting failed to run in expected order");
        }
    }

    @Assertion(id="JAVADOC:41 SPEC:7 SPEC:7.2 SPEC:45.3", strategy="TaskSubmitted is called after the task has been submitted to the Executor. The task will not enter the starting state until the taskSubmitted listener has completed.")
    public void taskSubmitted() {
        RunnableTaskWithStatus runnableTask = new RunnableTaskWithStatus(this.managedTaskListener);
        Runnable taskWithListener = ManagedExecutors.managedTask((Runnable)runnableTask, (ManagedTaskListener)this.managedTaskListener);
        this.executor.submit(taskWithListener);
        Wait.waitForListenerComplete(this.managedTaskListener);
        List<ListenerEvent> events = this.managedTaskListener.events();
        int submitAt = events.indexOf((Object)ListenerEvent.SUBMITTED);
        Assertions.assertEquals((int)0, (int)submitAt, (String)"Listener TaskSubmitted failed to run in expected order");
    }
}

