/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedExecutorService.resourcedef;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import ee.jakarta.tck.concurrent.spec.ManagedExecutorService.resourcedef.AppBean;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManagedExecutorDefinition;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.transaction.UserTransaction;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.junit.jupiter.api.Assertions;

@ManagedExecutorDefinition.List(value={@ManagedExecutorDefinition(name="java:app/concurrent/ExecutorA", context="java:app/concurrent/ContextA", maxAsync=2, hungTaskThreshold=300000L), @ManagedExecutorDefinition(name="java:module/concurrent/ExecutorB", context="java:module/concurrent/ContextB", maxAsync=1), @ManagedExecutorDefinition(name="java:comp/concurrent/ExecutorC")})
@WebServlet(value={"/ManagedExecutorDefinitionServlet"})
public class ManagedExecutorDefinitionServlet
extends TestServlet {
    private static final long serialVersionUID = 1L;
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    @Inject
    private AppBean appBean;
    @Resource
    private UserTransaction tx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncCompletionStage() throws Throwable {
        ManagedExecutorService executor = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ExecutorA");
        try {
            IntContext.set(10);
            StringContext.set("testAsyncCompletionStage-1");
            CompletionStage future = ((CompletableFuture)executor.supplyAsync(() -> {
                try {
                    ManagedExecutorService mes = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ExecutorA");
                    return "Application context " + (mes == null ? "incorrect" : "propagated");
                }
                catch (NamingException x) {
                    throw new CompletionException(x);
                }
            }).thenApplyAsync(status -> {
                int i = IntContext.get();
                return status + ";IntContext " + (String)(i == 10 ? "propagated" : "incorrect:" + i);
            })).thenCombine(CompletableFuture.completedFuture(";"), (status, sep) -> {
                String s = StringContext.get();
                return status + sep + "StringContext " + (String)("".equals(s) ? "cleared" : "incorrect:" + s);
            });
            IntContext.set(25);
            String result = (String)((CompletableFuture)future).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)result, (Object)"Application context propagated;IntContext propagated;StringContext cleared", (String)"Application context and IntContext must be propagated and StringContext must be cleared per ManagedExecutorDefinition and ContextServiceDefinition config.");
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsynchronousMethodReturnsCompletableFuture() throws Exception {
        CompletableFuture<Integer> future4;
        CompletableFuture<Integer> future3;
        CompletableFuture<Integer> future2;
        CompletableFuture<Integer> future1;
        CountDownLatch blocker = new CountDownLatch(1);
        Semaphore invocationsStarted = new Semaphore(0);
        try {
            IntContext.set(1215);
            future1 = this.appBean.waitAndGetIntContext(invocationsStarted, blocker);
            future2 = this.appBean.waitAndGetIntContext(invocationsStarted, blocker);
            future3 = this.appBean.waitAndGetIntContext(invocationsStarted, blocker);
            future4 = this.appBean.waitAndGetIntContext(invocationsStarted, blocker);
            Assertions.assertEquals((Object)invocationsStarted.tryAcquire(2, MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)true, (String)"Must be able to run 2 asynchronous methods in parallel.");
            Assertions.assertEquals((Object)future1.complete(1000), (Object)true, (String)"Must be able to complete the CompletableFuture of an asynchronous method.");
            Assertions.assertEquals((Object)invocationsStarted.tryAcquire(1, MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)true, (String)"Must be able to run another asynchronous method in parallel after forcibly completing the first.");
            Assertions.assertEquals((Object)future2.completeExceptionally(new CloneNotSupportedException("Not a real error. This is only testing exceptional completion.")), (Object)true, (String)"Must be able to complete the CompletableFuture of an asynchronous method exceptionally.");
            Assertions.assertEquals((Object)invocationsStarted.tryAcquire(1, MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)true, (String)"Must be able to run another asynchronous method in parallel after forcibly completing the second exceptionally.");
            Assertions.assertEquals((Object)invocationsStarted.tryAcquire(1, 1L, TimeUnit.SECONDS), (Object)false, (String)"Must not be able to run another asynchronous method in parallel.");
        }
        finally {
            IntContext.set(0);
            blocker.countDown();
        }
        Assertions.assertEquals((Integer)future1.getNow(1234), (Integer)1000, (String)"Asynchronous method's CompletableFuture must report the value with which it was forcibly completed.");
        try {
            Integer result = future2.join();
            throw new AssertionError((Object)("Asynchronous method's CompletableFuture must not return result " + result + "after being forcibly completed with an exception."));
        }
        catch (CompletionException x) {
            if (!(x.getCause() instanceof CloneNotSupportedException)) {
                throw x;
            }
            Assertions.assertEquals((Integer)future3.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Integer)1215, (String)"Third-party context type IntContext must be propagated to asynchronous method per ManagedExecutorDefinition and ContextServiceDefinition.");
            Assertions.assertEquals((Integer)future4.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Integer)1215, (String)"Third-party context type IntContext must be propagated to asynchronous method per ManagedExecutorDefinition and ContextServiceDefinition.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsynchronousMethodReturnsCompletionStage() throws Exception {
        CountDownLatch blocker = new CountDownLatch(1);
        LinkedBlockingQueue<String> queue = new LinkedBlockingQueue<String>();
        try {
            StringContext.set("testAsynchronousMethodReturnsCompletionStage-1");
            CompletionStage<String> stage1 = this.appBean.addStringContextAndWait(queue, blocker);
            CompletionStage<String> stage2 = this.appBean.addStringContextAndWait(queue, blocker);
            StringContext.set("testAsynchronousMethodReturnsCompletionStage-2");
            Assertions.assertEquals(queue.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)"testAsynchronousMethodReturnsCompletionStage-1", (String)"One of the asynchronous method invocations should run per maxAsync=1.");
            Assertions.assertEquals(queue.poll(1L, TimeUnit.SECONDS), null, (String)"Two asynchronous method invocations should not run at same time per maxAsync=1.");
            stage1.thenAcceptBoth(stage2, (result1, result2) -> {
                if (result1.equals(result2)) {
                    queue.add(StringContext.get());
                } else {
                    queue.add("Both asynchronous method invocations must have same result. Instead: " + result1 + " and " + result2);
                }
            });
        }
        finally {
            StringContext.set(null);
            blocker.countDown();
        }
        Assertions.assertEquals(queue.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)"testAsynchronousMethodReturnsCompletionStage-1", (String)"The other asynchronous method invocation should run after the first is no longer running.");
        Assertions.assertEquals(queue.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)"testAsynchronousMethodReturnsCompletionStage-2", (String)"Completion stage that is created from an asynchronous method completion stage must run with the same executor and therefore propagate the same third-party context type StringContext.");
    }

    public void testAsynchronousMethodVoidReturnType() throws Exception {
        Exchanger<String> exchanger = new Exchanger<String>();
        this.appBean.exchange(exchanger, "RUNNING");
        String status = exchanger.exchange("WAITING", MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)status, (Object)"RUNNING", (String)("Asynchronous method with void return type must be able to run asynchronously. " + status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompletedFuture() throws Throwable {
        ManagedExecutorService executor = (ManagedExecutorService)InitialContext.doLookup("java:module/concurrent/ExecutorB");
        IntContext.set(81);
        StringContext.set("testCompletedFuture-1");
        try {
            CompletableFuture stage1 = executor.completedFuture((Object)"java:module/concurrent/ExecutorB");
            StringContext.set("testCompletedFuture-2");
            CompletionStage stage2 = stage1.thenAcceptAsync(jndiName -> {
                try {
                    InitialContext.doLookup(jndiName);
                    throw new AssertionError((Object)"Application context must be left unchanged per ManagedExecutorDefinition and ContextServiceDefinition config.");
                }
                catch (NamingException x) {
                    throw new CompletionException(x);
                }
            });
            StringContext.set("testCompletedFuture-3");
            CompletionStage stage3 = ((CompletableFuture)stage2).handleAsync((result, failure) -> {
                int i = IntContext.get();
                String s = StringContext.get();
                if (failure instanceof CompletionException && failure.getCause() instanceof NamingException) {
                    return "StringContext " + (String)("testCompletedFuture-3".equals(s) ? "propagated" : "incorrect:" + s) + ";IntContext " + (String)(i == 0 ? "unchanged" : "incorrect:" + i);
                }
                if (failure == null) {
                    throw new AssertionError((Object)"Missing Throwable argument to handleAsync");
                }
                throw new CompletionException((Throwable)failure);
            });
            StringContext.set("testCompletedFuture-4");
            String result2 = (String)((CompletableFuture)stage3).join();
            Assertions.assertEquals((Object)result2, (Object)"StringContext propagated;IntContext unchanged", (String)"StringContext must be propagated and Application context and IntContext must be left unchanged per ManagedExecutorDefinition and ContextServiceDefinition config.");
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyCompletableFuture() throws Throwable {
        ManagedExecutorService executor = (ManagedExecutorService)InitialContext.doLookup("java:module/concurrent/ExecutorB");
        IntContext.set(271);
        StringContext.set("testCopyCompletableFuture-1");
        try {
            CompletableFuture<Character> stage1unmanaged = new CompletableFuture<Character>();
            CompletableFuture stage1copy = executor.copy(stage1unmanaged);
            CompletableFuture permanentlyIncompleteStage = new CompletableFuture();
            StringContext.set("testCopyCompletableFuture-2");
            CompletionStage stage2 = stage1copy.applyToEitherAsync((CompletionStage)permanentlyIncompleteStage, sep -> {
                String s = StringContext.get();
                return "StringContext " + (String)("testCopyCompletableFuture-2".equals(s) ? "propagated" : "incorrect:" + s) + sep;
            });
            StringContext.set("testCopyCompletableFuture-3");
            CompletionStage stage3 = ((CompletableFuture)stage2).handleAsync((result, failure) -> {
                if (failure == null) {
                    int i = IntContext.get();
                    return result + "IntContext " + (String)(i == 0 ? "unchanged" : "incorrect:" + i);
                }
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError())).initCause((Throwable)failure));
            });
            Assertions.assertTrue((boolean)stage1unmanaged.complete(Character.valueOf(';')), (String)"Completation stage that is supplied to copy must not be modified by the ManagedExecutorService.");
            String result2 = (String)((CompletableFuture)stage3).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)result2, (Object)"StringContext propagated;IntContext unchanged", (String)"StringContext must be propagated and Application context and IntContext must be left unchanged per ManagedExecutorDefinition and ContextServiceDefinition config.");
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIncompleteFuture() throws Throwable {
        ManagedExecutorService executor = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ExecutorA");
        try {
            IntContext.set(181);
            StringContext.set("testIncompleteFuture-1");
            CompletableFuture stage1 = executor.newIncompleteFuture();
            IntContext.set(182);
            CompletionStage stage2a = stage1.thenApplyAsync(sep -> {
                int i = IntContext.get();
                return "IntContext " + (String)(i == 182 ? "propagated" : "incorrect:" + i) + sep;
            });
            CompletionStage stage2b = stage1.thenApply(sep -> {
                String s = StringContext.get();
                return "StringContext " + (String)("".equals(s) ? "cleared" : "incorrect:" + s) + sep;
            });
            IntContext.set(183);
            CompletionStage stage3 = ((CompletableFuture)stage2a).thenCombineAsync(stage2b, (status1, status2) -> {
                try {
                    ManagedExecutorService mes = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ExecutorA");
                    return status1 + status2 + "Application context " + (mes == null ? "incorrect" : "propagated");
                }
                catch (NamingException x) {
                    throw new CompletionException(x);
                }
            });
            stage1.complete(";");
            String result = (String)((CompletableFuture)stage3).join();
            Assertions.assertEquals((Object)result, (Object)"IntContext propagated;StringContext cleared;Application context propagated", (String)"Application context and IntContext must be propagated and StringContext must be cleared per ManagedExecutorDefinition and ContextServiceDefinition config.");
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManagedExecutorDefinitionAllAttributes() throws Throwable {
        ManagedExecutorService executor = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/ExecutorA");
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        CountDownLatch blocker = new CountDownLatch(1);
        Runnable task = () -> {
            results.add(IntContext.get());
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException x) {
                throw new CompletionException(x);
            }
        };
        try {
            IntContext.set(22);
            executor.runAsync(task);
            executor.submit(task);
            executor.execute(task);
            Assertions.assertEquals((Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (Integer)22, (String)"ManagedExecutorService with maxAsync=2 must be able to run an async task.");
            Assertions.assertEquals((Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (Integer)22, (String)"ManagedExecutorService with maxAsync=2 must be able to run 2 async tasks concurrently.");
            Assertions.assertEquals((Integer)((Integer)results.poll(1L, TimeUnit.SECONDS)), null, (String)"ManagedExecutorService with maxAsync=2 must not run 3 async tasks concurrently.");
        }
        finally {
            IntContext.set(0);
            blocker.countDown();
        }
        Assertions.assertEquals((Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (Integer)22, (String)"ManagedExecutorService with maxAsync=2 must be able to run 3rd task after 1st completes.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManagedExecutorDefinitionDefaults() throws Throwable {
        ManagedExecutorService executor = (ManagedExecutorService)InitialContext.doLookup("java:comp/concurrent/ExecutorC");
        CountDownLatch blocker = new CountDownLatch(1);
        CountDownLatch allTasksRunning = new CountDownLatch(3);
        Callable<Integer> txCallable = () -> {
            allTasksRunning.countDown();
            UserTransaction trans = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
            int initialStatus = trans.getStatus();
            trans.begin();
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
            }
            finally {
                trans.rollback();
            }
            return initialStatus;
        };
        Function<String, Object> lookupFunction = jndiName -> {
            allTasksRunning.countDown();
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
                return InitialContext.doLookup(jndiName);
            }
            catch (InterruptedException | NamingException x) {
                throw new CompletionException(x);
            }
        };
        try {
            Future txFuture = executor.submit(txCallable);
            CompletionStage lookupFuture1 = executor.completedFuture((Object)"java:comp/concurrent/ExecutorC").thenApplyAsync(lookupFunction);
            CompletionStage lookupFuture2 = executor.completedFuture((Object)"java:module/concurrent/ExecutorB").thenApplyAsync(lookupFunction);
            Assertions.assertTrue((boolean)allTasksRunning.await(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (String)"ManagedExecutorService without maxAsync must be able to run async tasks concurrently.");
            blocker.countDown();
            int status = (Integer)txFuture.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertEquals((int)status, (int)6, (String)"Transaction context must be cleared from async Callable task per java:comp/concurrent/ExecutorC configuration.");
            Assertions.assertTrue((boolean)(((CompletableFuture)lookupFuture1).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS) instanceof ManagedExecutorService), (String)"Application context must be propagated to first async Function per java:comp/concurrent/ExecutorC configuration.");
            Assertions.assertTrue((boolean)(((CompletableFuture)lookupFuture2).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS) instanceof ManagedExecutorService), (String)"Application context must be propagated to second async Function per java:comp/concurrent/ExecutorC configuration.");
        }
        finally {
            IntContext.set(0);
            blocker.countDown();
        }
        this.tx.begin();
        try {
            int status = (Integer)executor.getContextService().contextualCallable(txCallable).call();
            Assertions.assertEquals((int)status, (int)6, (String)"Transaction context must be cleared from inline contextual Callable per java:comp/concurrent/ExecutorC configuration.");
        }
        finally {
            this.tx.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchCompletedFuture() throws Throwable {
        CompletableFuture<Integer> future;
        AtomicInteger counter = new AtomicInteger();
        try {
            future = this.appBean.scheduledEvery5seconds(1, AppBean.RETURN.INCOMPLETE, counter);
            Assertions.assertThrows(TimeoutException.class, () -> future.get(10L, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)future.isCancelled());
            Assertions.assertFalse((boolean)future.isCompletedExceptionally());
            Assertions.assertFalse((boolean)future.isDone());
            Assertions.assertEquals((int)1, (int)counter.get(), (String)"Schedule should have executed exactly once.");
            future.cancel(false);
        }
        finally {
            counter.set(0);
        }
        try {
            future = this.appBean.scheduledEvery5seconds(1, AppBean.RETURN.NULL, counter);
            Assertions.assertFalse((boolean)future.isCancelled());
            Assertions.assertFalse((boolean)future.isCompletedExceptionally());
            Assertions.assertFalse((boolean)future.isDone());
            int countBeforeCancel = counter.get();
            future.cancel(false);
            Assertions.assertThrows(CancellationException.class, () -> future.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            int countAfterCancel = counter.get();
            Assertions.assertTrue((countAfterCancel - countBeforeCancel <= 1 ? 1 : 0) != 0, (String)"Schedule should not have executed more than once after cancel was called.");
        }
        finally {
            counter.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchCompletedResult() throws Throwable {
        AtomicInteger counter = new AtomicInteger();
        try {
            int expected = 3;
            CompletableFuture<Integer> future = this.appBean.scheduledEvery5seconds(expected, AppBean.RETURN.COMPLETE_RESULT, counter);
            int result = future.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertFalse((boolean)future.isCancelled());
            Assertions.assertFalse((boolean)future.isCompletedExceptionally());
            Assertions.assertTrue((boolean)future.isDone());
            Assertions.assertEquals((int)expected, (int)result);
        }
        finally {
            counter.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchCompletedExceptionally() {
        ExecutionException cause;
        CompletableFuture<Integer> future;
        String expected;
        AtomicInteger counter = new AtomicInteger();
        try {
            expected = "testScheduledAsynchCompletedExceptionally-1";
            future = this.appBean.scheduledEvery5seconds(1, AppBean.RETURN.COMPLETE_EXCEPTIONALLY.withMessage(expected), counter);
            cause = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)future.isCancelled());
            Assertions.assertTrue((boolean)future.isCompletedExceptionally());
            Assertions.assertTrue((boolean)future.isDone());
            Assertions.assertTrue((boolean)cause.getMessage().contains(expected));
            Assertions.assertEquals((int)1, (int)counter.get(), (String)"Schedule should have executed exactly once.");
        }
        finally {
            counter.set(0);
        }
        try {
            expected = "testScheduledAsynchCompletedExceptionally-2";
            future = this.appBean.scheduledEvery5seconds(1, AppBean.RETURN.THROW_EXCEPTION.withMessage(expected), counter);
            cause = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)future.isCancelled());
            Assertions.assertTrue((boolean)future.isCompletedExceptionally());
            Assertions.assertTrue((boolean)future.isDone());
            Assertions.assertTrue((boolean)cause.getMessage().contains(expected));
            Assertions.assertEquals((int)1, (int)counter.get());
        }
        finally {
            counter.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchOverlapSkipping() throws Throwable {
        AtomicInteger counter = new AtomicInteger();
        try {
            int expected = 3;
            CompletableFuture<Integer> future = this.appBean.scheduledEvery3SecondsTakes5Seconds(expected, counter);
            Assertions.assertThrows(TimeoutException.class, () -> future.get(expected * 3, TimeUnit.SECONDS));
            int result = future.get(expected * 5, TimeUnit.SECONDS);
            Assertions.assertEquals((int)expected, (int)result);
        }
        finally {
            counter.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchIgnoresMaxAsync() throws Throwable {
        ManagedExecutorService executor = (ManagedExecutorService)InitialContext.doLookup("java:module/concurrent/ExecutorB");
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        CountDownLatch blocker = new CountDownLatch(1);
        Runnable task = () -> {
            results.add(IntContext.get());
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException x) {
                throw new CompletionException(x);
            }
        };
        AtomicInteger counter = new AtomicInteger();
        try {
            IntContext.set(22);
            executor.runAsync(task);
            executor.runAsync(task);
            CompletableFuture<Integer> future = this.appBean.scheduledEvery3Seconds(1, counter);
            Assertions.assertEquals((Integer)0, (Integer)((Integer)results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)), (String)"ManagedExecutorService with maxAsync=1 must be able to run an async task.");
            Assertions.assertEquals(null, (Integer)((Integer)results.poll(1L, TimeUnit.SECONDS)), (String)"ManagedExecutorService with maxAsync=1 must not run 2 async tasks concurrently.");
            Assertions.assertEquals((Integer)0, (Integer)future.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (String)"ManagedExecutorService with maxAsync=1 must be able to run scheduled async methods concurrently.");
        }
        finally {
            IntContext.set(0);
            counter.set(0);
            blocker.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchWithMultipleSchedules() throws Throwable {
        AtomicInteger counter = new AtomicInteger();
        try {
            String expected = "testScheduledAsynchWithMultipleSchedules";
            StringContext.set(expected);
            CompletableFuture<String> future = this.appBean.scheduledEvery3SecondsAnd1Minute(5, counter);
            String result = future.get(1L, TimeUnit.MINUTES);
            Assertions.assertEquals((Object)expected, (Object)result);
        }
        finally {
            StringContext.set(null);
            counter.set(0);
        }
    }

    public void testScheduledAsynchWithInvalidJNDIName() {
        Assertions.assertThrows(RejectedExecutionException.class, () -> this.appBean.scheduledInvalidExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduledAsynchVoidReturn() {
        int expected;
        AtomicInteger counter = new AtomicInteger();
        try {
            expected = 3;
            this.appBean.scheduledEvery3SecondsVoidReturn(expected, AppBean.RETURN.COMPLETE_RESULT, counter);
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(MAX_WAIT_SECONDS), () -> {
                while (expected != counter.get()) {
                    Wait.sleep(Duration.ofSeconds(3L));
                }
            });
        }
        finally {
            counter.set(0);
        }
        try {
            expected = 3;
            this.appBean.scheduledEvery3SecondsVoidReturn(expected, AppBean.RETURN.COMPLETE_EXCEPTIONALLY, counter);
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(MAX_WAIT_SECONDS), () -> {
                while (expected != counter.get()) {
                    Wait.sleep(Duration.ofSeconds(3L));
                }
            });
        }
        finally {
            counter.set(0);
        }
        try {
            expected = 3;
            this.appBean.scheduledEvery3SecondsVoidReturn(expected, AppBean.RETURN.THROW_EXCEPTION, counter);
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(MAX_WAIT_SECONDS), () -> {
                while (expected != counter.get()) {
                    Wait.sleep(Duration.ofSeconds(3L));
                }
            });
        }
        finally {
            counter.set(0);
        }
    }
}

