/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.common.managed.task.listener;

import ee.jakarta.tck.concurrent.common.managed.task.listener.ListenerEvent;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;

public class ManagedTaskListenerImpl
implements ManagedTaskListener {
    private static final TestLogger log = TestLogger.get(ManagedTaskListenerImpl.class);
    private final List<ListenerEvent> events = Collections.synchronizedList(new ArrayList());

    public void taskAborted(Future<?> future, ManagedExecutorService mes, Object arg2, Throwable arg3) {
        this.events.add(ListenerEvent.ABORTED);
        log.info("task aborted");
    }

    public void taskDone(Future<?> future, ManagedExecutorService mes, Object arg2, Throwable arg3) {
        this.events.add(ListenerEvent.DONE);
        log.info("task done");
    }

    public void taskStarting(Future<?> future, ManagedExecutorService mes, Object arg2) {
        this.events.add(ListenerEvent.STARTING);
        log.info("task starting");
    }

    public void taskSubmitted(Future<?> future, ManagedExecutorService mes, Object arg2) {
        this.events.add(ListenerEvent.SUBMITTED);
        log.info("task submitted");
    }

    public boolean eventCalled(ListenerEvent event) {
        return this.events.contains((Object)event);
    }

    public void clearEvents() {
        this.events.clear();
    }

    public void update(ListenerEvent event) {
        this.events.add(event);
    }

    public List<ListenerEvent> events() {
        return this.events;
    }
}

