/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.utilities;

import ee.jakarta.tck.data.framework.utilities.TestProperty;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.ResourceContainer;

public class TestPropertyHandler {
    private static final Logger log = Logger.getLogger(TestPropertyHandler.class.getCanonicalName());
    private static final String PROP_FILE = "tck.properties";
    private static Properties foundProperties;

    private TestPropertyHandler() {
    }

    static Properties loadProperties() {
        if (foundProperties != null) {
            return foundProperties;
        }
        foundProperties = new Properties();
        InputStream propsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROP_FILE);
        if (propsStream != null) {
            try {
                foundProperties.load(propsStream);
            }
            catch (Exception e) {
                log.info("Attempted to load properties from resource tck.properties but failed. Because: " + e.getLocalizedMessage());
            }
        }
        return foundProperties;
    }

    public static Archive<?> storeProperties(Archive<?> archive) {
        if (!(archive instanceof ResourceContainer)) {
            throw new RuntimeException("Could not store properties to archive, because it was not a ResourceConatiner. Please raise an issue with the maintainers of the Jakarta Data TCK.");
        }
        Properties filteredProps = new Properties();
        for (TestProperty prop : TestProperty.values()) {
            if (prop.getKey().startsWith("java.")) continue;
            filteredProps.put(prop.getKey(), prop.getValue());
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            filteredProps.store(out, "System properties shared with Arquillian container");
            ((ResourceContainer)archive).addAsResource((Asset)new StringAsset(out.toString()), PROP_FILE);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not store properties file to archive", e);
        }
        return archive;
    }
}

