/*
 * Copyright (c) 2023 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */
package ee.jakarta.tck.data.web.validation;

import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;

@jakarta.nosql.Entity
@jakarta.persistence.Entity
public class Rectangle {
    @jakarta.nosql.Id
    @jakarta.persistence.Id
    @NotBlank
    private String id;
    
    @jakarta.nosql.Column
    @PositiveOrZero
    @Max(1800) 
    private long x;
    
    @jakarta.nosql.Column
    @NotNull
    @Min(0)
    @Max(1000)
    private Long y;
    
    @jakarta.nosql.Column
    @Positive
    @Max(120)
    private int width;
    
    @jakarta.nosql.Column
    @NotNull
    @Min(1)
    @Max(80)
    private Integer height;
    
    public Rectangle() {
      //do nothing
    }

    public Rectangle(String id, long x, Long y, int width, Integer height) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getX() {
        return x;
    }

    public void setX(long x) {
        this.x = x;
    }

    public Long getY() {
        return y;
    }

    public void setY(Long y) {
        this.y = y;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    @Override
    public String toString() {
        return "Rectangle [id=" + id + ", x=" + x + ", y=" + y + ", width=" + width + ", height=" + height + "]";
    }
    
}
