/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.collectionoperators;

import com.sun.ts.tests.el.common.util.DataBase;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import jakarta.el.ELProcessor;
import java.lang.reflect.Array;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private ELProcessor elp;
    private DataBase database;

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elCollectionMapFilterTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"[Toy Story, 10.0]", "[History of Golf, 11.0]"};
        String[] expr2 = new String[]{"20", "30", "40"};
        this.testIterable("map-filter-one", "products.stream().filter(p->p.unitPrice >= 10 && p.unitPrice < 12).sorted((p,q)->p.unitPrice-q.unitPrice).map(p->[p.name,p.unitPrice]).toList()", expr1);
        this.testIterable("map-filter-two", "[1,2,3,4].stream().filter(i->i > 1).map(i->i*10).toList()", expr2);
    }

    @Test
    public void elCollectionMinTest() throws Exception {
        this.buildELContext();
        this.testStream("min", "[2,3,1,5].stream().min().get()", 1L);
        this.elp.eval("comparing = map->(x,y)->map(x).compareTo(map(y))");
        this.testStream("min", "[3,2,1].stream().min((i,j)->i-j).get()", 1L);
        this.testStream("min", "customers.stream().min((x,y)->x.orders.size()-y.orders.size()).get().name", "Charlie Yeh");
        this.elp.eval("comparing = map->(x,y)->map(x).compareTo(map(y))");
        this.testStream("min", "customers.stream().min(comparing(c->c.orders.size())).get().name", "Charlie Yeh");
    }

    @Test
    public void elCollectionMaxTest() throws Exception {
        this.buildELContext();
        this.testStream("max", "[2,3,1,5].stream().max().get()", 5L);
        this.testStream("max", "['xy', 'xyz', 'abc'].stream().max().get()", "xyz");
        this.testStream("max", "[2].stream().max((i,j)->i-j).get()", 2L);
        this.elp.eval("comparing = map->(x,y)->map(x).compareTo(map(y))");
        this.testStream("max", "customers.stream().max((x,y)->x.orders.size()-y.orders.size()).get().name", "John Doe");
        this.testStream("max", "customers.stream().max(comparing(c->c.orders.size())).get().name", "John Doe");
    }

    @Test
    public void elCollectionDistinctTest() throws Exception {
        this.buildELContext();
        this.testIterable("distinct", " ['a', 'b', 'b', 'c'].stream().distinct().toList()", new String[]{"a", "b", "c"});
    }

    @Test
    public void elCollectionForEachTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"Eagle", "Coming Home", "Greatest Hits", "History of Golf", "Toy Story", "iSee"};
        this.testIterable("forEach", "lst = []; products.stream().forEach(p->lst.add(p.name)); lst", expr1);
    }

    @Test
    public void elCollectionFindFirstTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"Product: 200, Eagle, book, 12.5, 100"};
        this.testIterable("findFirst", "products.stream().sorted(p->p.unitPrice).findFirst().get()", expr1);
    }

    @Test
    public void elCollectionLimitTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"[Product: 202, Greatest Hits, cd, 6.5, 200]"};
        String[] expr2 = new String[]{"Product: 202, Greatest Hits, cd, 6.5, 200", "Product: 201, Coming Home, dvd, 8.0, 50"};
        this.testIterable("limit", "products.stream().sorted((p,q)->p.unitPrice-q.unitPrice).limit(1).toList()", expr1);
        this.testIterable("limit", "products.stream().sorted((p,q)->p.unitPrice-q.unitPrice).limit(2).toList()", expr2);
    }

    public void elCollectionAnyMatchTest() throws Exception {
        this.buildELContext();
        this.testIterable("anyMatch_True", "products.stream().anyMatch(p->p.unitPrice >= 10)", Boolean.TRUE);
        this.testIterable("anyMatch_False", "products.stream().anyMatch(p->p.unitPrice == 100)", Boolean.FALSE);
    }

    public void elCollectionNoneMatchTest() throws Exception {
        this.buildELContext();
        this.testIterable("noneMatch_False", "products.stream().noneMatch(p->p.unitPrice >= 10)", Boolean.FALSE);
        this.testIterable("noneMatch_True", "products.stream().noneMatch(p->p.unitPrice == 100)", Boolean.TRUE);
    }

    public void elCollectionAllMatchTest() throws Exception {
        this.buildELContext();
        this.testIterable("allMatch_true", "products.stream().allMatch(p->p.unitPrice >= 1)", Boolean.TRUE);
        this.testIterable("allMatch_false", "products.stream().allMatch(p->p.unitPrice == 100)", Boolean.FALSE);
    }

    @Test
    public void elCollectionSumTest() throws Exception {
        this.buildELContext();
        this.testIterable("sum", "['10', '12', '13'].stream().sum()", new String[]{"35"});
        this.testIterable("sum_Empty", "[].stream().sum()", new String[]{"0"});
    }

    @Test
    public void elCollectionCountTest() throws Exception {
        this.buildELContext();
        this.testIterable("count", "[1,2,3,4,5].stream().count()", new String[]{"5"});
    }

    @Test
    public void elCollectionAverageTest() throws Exception {
        this.buildELContext();
        this.testStream("average_ints", "ints.stream().average().get()", 4.5);
    }

    @Test
    public void elCollectionToArrayTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"Product: 200, Eagle, book, 12.5, 100", "Product: 205, iSee, book, 12.5, 150", "Product: 203, History of Golf, book, 11.0, 30", "Product: 202, Greatest Hits, cd, 6.5, 200", "Product: 204, Toy Story, dvd, 10.0, 1000", "Product: 201, Coming Home, dvd, 8.0, 50"};
        this.testArray("toArray", "products.stream().sorted(p->p.unitPrice).toArray()", expr1);
    }

    @Test
    public void elCollectionReduceTest() throws Exception {
        this.buildELContext();
        this.testStream("reduce-one", "[1,2,3,4,5].stream().reduce(0, (l,r)->l+r)", 15L);
        this.testStream("reduce-two", "[1,2,3,4,5].stream().reduce((l,r)->l+r).get()", 15L);
        this.testStream("reduce-three", "[].stream().reduce((l,r)->l+r).orElse(101)", 101L);
        this.testStream("reduce-four", "[].stream().reduce((l,r)->l+r).orElseGet(()->101)", 101L);
        this.testStream("reduce-five", "c = 0; [1,2,3,4,5,6].stream().reduce(0, (l,r)->(c = c+1; c % 2 == 0? l+r: l-r))", 3L);
    }

    @Test
    public void elCollectionSubStreamTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"2", "3", "4"};
        this.testIterable("substream-one", "[0,1,2,3,4].stream().substream(2).toList()", expr1);
        this.testIterable("substream-two", "[0,1,2,3,4,5,6].stream().substream(2,5).toList()", expr1);
    }

    @Test
    public void elCollectionPeekTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"1", "2", "3", "4"};
        this.testIterable("peek-one", "lst = []; [1,2,3,4].stream().peek(i->lst.add(i)).toList()", expr1);
        this.testIterable("peek-two", "lst.stream().toList()", expr1);
    }

    @Test
    public void elCollectionFlatMapTest() throws Exception {
        this.buildELContext();
        String[] expr1 = new String[]{"Order: 10, 100, 2/18/2010, 20.8", "Order: 11, 100, 5/3/2011, 34.5", "Order: 12, 100, 8/2/2011, 210.75", "Order: 13, 101, 1/15/2011, 50.23", "Order: 14, 101, 1/3/2012, 126.77"};
        this.testIterable("flatMap", "customers.stream().filter(c->c.country=='USA').flatMap(c->c.orders.stream()).toList()", expr1);
    }

    @Test
    public void elCollectionSetLiteralTest() throws Exception {
        boolean pass = false;
        try {
            ELProcessor elp = new ELProcessor();
            String valueA = "myValueA";
            String valueB = "myValueB";
            elp.setVariable("aaa", "'" + valueA + "'");
            elp.setVariable("bbb", "'" + valueB + "'");
            Boolean result = (Boolean)elp.eval("{aaa,bbb}.contains(aaa)");
            pass = result;
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Construction and use of a valid Set literal threw an Exception!" + ELTestUtil.NL + "Received: " + e.toString() + ELTestUtil.NL);
            e.printStackTrace();
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void elCollectionListLiteralTest() throws Exception {
        boolean pass = false;
        try {
            ELProcessor elp = new ELProcessor();
            String valueA = "myValueA";
            String valueB = "myValueB";
            elp.setVariable("aaa", "'" + valueA + "'");
            elp.setVariable("bbb", "'" + valueB + "'");
            Object result = elp.eval("[aaa,bbb].get(1)");
            pass = valueB.equals(result);
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Construction and use of a valid List literal threw an Exception!" + ELTestUtil.NL + "Received: " + e.toString() + ELTestUtil.NL);
            e.printStackTrace();
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    public void elCollectionMapLiteralTest() throws Exception {
        boolean pass = false;
        try {
            ELProcessor elp = new ELProcessor();
            String key = "myKey";
            String value = "myValue";
            elp.setVariable("aaa", "'" + key + "'");
            elp.setVariable("bbb", "'" + value + "'");
            Object result = elp.eval("{aaa:bbb}.get(aaa)");
            pass = value.equals(result);
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Construction and use of a valid Map literal threw an Exception!" + ELTestUtil.NL + "Received: " + e.toString() + ELTestUtil.NL);
            e.printStackTrace();
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    private void logLine(String s) {
        logger.log(System.Logger.Level.INFO, s);
    }

    private void buildELContext() {
        this.elp = new ELProcessor();
        this.database = new DataBase();
        this.database.init();
        this.elp.defineBean("customers", this.database.getCustomers());
        this.elp.defineBean("products", this.database.getProducts());
        this.elp.defineBean("orders", this.database.getOrders());
        this.elp.defineBean("ints", this.database.getInts());
    }

    private void testIterable(String name, String query, String[] expected) throws Exception {
        int explength = 0;
        if (expected != null) {
            explength = expected.length;
        }
        this.logLine("=== Testing " + name + " ===");
        this.logLine(query);
        Object ret = this.elp.eval(query);
        int indx = 0;
        this.logLine(" = returns =");
        if (expected == null) {
            if (ret != null) {
                throw new Exception("TEST FAILED, Unexpected Value!" + ELTestUtil.NL + "Expected: null");
            }
            this.logLine(" null ");
        } else if (expected.length == 1) {
            String golden = expected[0];
            String result = ret.toString();
            this.logLine(" " + result);
            if (!golden.equals(result)) {
                throw new Exception("TEST FAILED, Unexpected Value!" + ELTestUtil.NL + "Expected: " + golden + ELTestUtil.NL + "Received: " + result);
            }
        } else {
            for (Object item : (Iterable)ret) {
                String result = item.toString();
                String golden = expected[indx++];
                this.logLine(" " + result);
                if (golden.equals(result)) continue;
                throw new Exception("TEST FAILED, Unexpected Value!" + ELTestUtil.NL + "Expected: " + golden + ELTestUtil.NL + "Received: " + result);
            }
            if (indx != explength) {
                throw new Exception("Test FAILED lenght incorrect!" + ELTestUtil.NL + "Expected: " + explength + ELTestUtil.NL + "Found: " + indx);
            }
        }
    }

    private void testIterable(String name, String query, Boolean expected) throws Exception {
        this.testIterable(name, query, new String[]{expected.toString()});
    }

    private void testArray(String name, String query, String[] expected) throws Exception {
        this.logLine("=== Test " + name + "===");
        this.logLine(query);
        Object arry = this.elp.eval(query);
        int gldLength = Array.getLength(arry);
        this.logLine(" = returns =");
        if (gldLength != expected.length) {
            throw new Exception("Test FAILED lenght incorrect!" + ELTestUtil.NL + "Expected: " + expected.length + ELTestUtil.NL + "Found: " + gldLength);
        }
        for (int indx = 0; gldLength < indx; ++indx) {
            String golden;
            String item = (String)Array.get(arry, indx);
            if (!item.equals(golden = expected[indx])) {
                throw new Exception("Test FAILED" + ELTestUtil.NL + "Expected: " + item + ELTestUtil.NL + "Received: " + golden);
            }
            this.logLine(" " + item);
        }
    }

    private void testStream(String name, String query, Object exp_value) throws Exception {
        this.logLine("=== Testing " + name + " ===");
        Object result = this.elp.eval(query);
        this.logLine("EL Quuery String: '" + query + "' -returns: " + result + "(" + result.getClass() + ")");
        if (!exp_value.equals(result)) {
            throw new Exception("Test FAILED" + ELTestUtil.NL + "Expected: " + exp_value + ELTestUtil.NL + "Received: " + result);
        }
    }
}

