/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.expression;

import com.sun.ts.tests.el.common.api.expression.ExpressionTest;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ResolverType;
import jakarta.el.ELContext;
import jakarta.el.Expression;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void negativeEqualsTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = true;
        try {
            MethodExpression mexp2;
            ValueExpression vexp2;
            MethodExpression mexp1;
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new SimpleELContext().getELContext();
            ValueExpression vexp1 = expFactory.createValueExpression(context, "${null}", Object.class);
            if (ExpressionTest.equalsTest((Expression)vexp1, null, buf)) {
                pass = false;
                buf.append("ValueExpression tested equal to null" + ELTestUtil.NL);
            }
            if (ExpressionTest.equalsTest((Expression)(mexp1 = expFactory.createMethodExpression(context, "null", null, new Class[0])), null, buf)) {
                pass = false;
                buf.append("MethodExpression tested equal to null" + ELTestUtil.NL);
            }
            if (ExpressionTest.equalsTest((Expression)(vexp2 = expFactory.createValueExpression(context, "literal", Object.class)), (Expression)(mexp2 = expFactory.createMethodExpression(context, "literal", null, new Class[0])), buf)) {
                pass = false;
                buf.append("ValueExpression tested equal to MethodExpression" + ELTestUtil.NL);
            }
            if (ExpressionTest.equalsTest((Expression)mexp2, (Expression)vexp2, buf)) {
                pass = false;
                buf.append("MethodExpression tested equal to ValueExpression" + ELTestUtil.NL);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void expressionHashCodeTest() throws Exception {
        MethodExpression mexp2;
        SimpleELContext simpleContext = new SimpleELContext(ResolverType.VECT_ELRESOLVER);
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        ELContext context = simpleContext.getELContext();
        String exprStr1 = "#{vect.add}";
        Class[] paramTypes1 = new Class[]{Object.class};
        MethodExpression mexp1 = expFactory.createMethodExpression(context, exprStr1, Boolean.TYPE, paramTypes1);
        if (!mexp1.equals((Object)(mexp2 = expFactory.createMethodExpression(context, exprStr1, Boolean.TYPE, paramTypes1)))) {
            throw new Exception("Failed: equals check failed!");
        }
        if (mexp1.hashCode() != mexp2.hashCode()) {
            throw new Exception("Failed: hashCode check failed!");
        }
    }
}

