/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.connectors.config.GroupMap;
import org.glassfish.connectors.config.PrincipalMap;
import org.glassfish.connectors.config.WorkSecurityMap;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-connector-work-security-map")
@PerLookup
@I18n(value="create.connector.work.security.map")
public class CreateConnectorWorkSecurityMap
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateConnectorWorkSecurityMap.class);
    @Param(name="raname")
    private String raName;
    @Param(name="principalsmap", optional=true)
    private Properties principalsMap;
    @Param(name="groupsmap", optional=true)
    private Properties groupsMap;
    @Param(name="description", optional=true)
    private String description;
    @Param(name="mapname", primary=true)
    private String mapName;
    @Inject
    private Domain domain;
    @Inject
    private Applications applications;

    public void execute(AdminCommandContext context) {
        Resources appScopedResources;
        Resources msr;
        String resourceAdapterName;
        Module module;
        Application application;
        ActionReport report = context.getActionReport();
        if (this.mapName == null) {
            report.setMessage(localStrings.getLocalString("create.connector.work.security.map.noMapName", "No mapname defined for connector work security map."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.raName == null) {
            report.setMessage(localStrings.getLocalString("create.connector.work.security.map.noRaName", "No raname defined for connector work security map."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.principalsMap == null && this.groupsMap == null) {
            report.setMessage(localStrings.getLocalString("create.connector.work.security.map.noMap", "No principalsmap or groupsmap defined for connector work security map."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.principalsMap != null && this.groupsMap != null) {
            report.setMessage(localStrings.getLocalString("create.connector.work.security.map.specifyPrincipalsOrGroupsMap", "A work-security-map can have either (any number of) group mapping  or (any number of) principals mapping but not both. Specify--principalsmap or --groupsmap."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.hasDuplicate(this.domain.getResources(), report)) {
            return;
        }
        String appName = this.raName;
        if (!ConnectorsUtil.isStandAloneRA((String)this.raName) ? (application = this.applications.getApplication(appName = ConnectorsUtil.getApplicationNameOfEmbeddedRar((String)this.raName))) != null && (module = application.getModule(resourceAdapterName = ConnectorsUtil.getRarNameFromApplication((String)this.raName))) != null && (msr = module.getResources()) != null && this.hasDuplicate(msr, report) : (application = this.applications.getApplication(appName)) != null && (appScopedResources = application.getResources()) != null && this.hasDuplicate(appScopedResources, report)) {
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    WorkSecurityMap workSecurityMap = (WorkSecurityMap)param.createChild(WorkSecurityMap.class);
                    workSecurityMap.setName(CreateConnectorWorkSecurityMap.this.mapName);
                    workSecurityMap.setResourceAdapterName(CreateConnectorWorkSecurityMap.this.raName);
                    if (CreateConnectorWorkSecurityMap.this.principalsMap != null) {
                        for (Map.Entry<Object, Object> e : CreateConnectorWorkSecurityMap.this.principalsMap.entrySet()) {
                            PrincipalMap principalMap = (PrincipalMap)workSecurityMap.createChild(PrincipalMap.class);
                            principalMap.setEisPrincipal((String)e.getKey());
                            principalMap.setMappedPrincipal((String)e.getValue());
                            workSecurityMap.getPrincipalMap().add(principalMap);
                        }
                    } else if (CreateConnectorWorkSecurityMap.this.groupsMap != null) {
                        for (Map.Entry<Object, Object> e : CreateConnectorWorkSecurityMap.this.groupsMap.entrySet()) {
                            GroupMap groupMap = (GroupMap)workSecurityMap.createChild(GroupMap.class);
                            groupMap.setEisGroup((String)e.getKey());
                            groupMap.setMappedGroup((String)e.getValue());
                            workSecurityMap.getGroupMap().add(groupMap);
                        }
                    }
                    param.getResources().add(workSecurityMap);
                    return workSecurityMap;
                }
            }, (ConfigBeanProxy)this.domain.getResources());
        }
        catch (TransactionFailure tfe) {
            Logger.getLogger(CreateConnectorWorkSecurityMap.class.getName()).log(Level.SEVERE, "create-connector-work-security-map failed", tfe);
            report.setMessage(localStrings.getLocalString("create.connector.work.security.map.fail", "Unable to create connector work security map {0}.", new Object[]{this.mapName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean hasDuplicate(Resources resources, ActionReport report) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof WorkSecurityMap) || !((WorkSecurityMap)resource).getName().equals(this.mapName) || !((WorkSecurityMap)resource).getResourceAdapterName().equals(this.raName)) continue;
            report.setMessage(localStrings.getLocalString("create.connector.work.security.map.duplicate", "A connector work security map named {0} for resource adapter {1} already exists.", new Object[]{this.mapName, this.raName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return true;
        }
        return false;
    }
}

