/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class MQJMXConnectorInfo
implements AutoCloseable {
    private static final Logger _logger = Logger.getLogger("jakarta.enterprise.system.tools.admin");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MQJMXConnectorInfo.class);
    private final String jmxServiceURL;
    private final Map<String, ?> jmxConnectorEnv;
    private final String asInstanceName;
    private final String brokerInstanceName;
    private final String brokerType;
    private JMXConnector connector;

    public MQJMXConnectorInfo(String asInstanceName, String brokerInstanceName, String brokerType, String jmxServiceURL, Map<String, ?> jmxConnectorEnv) {
        this.brokerInstanceName = brokerInstanceName;
        this.asInstanceName = asInstanceName;
        this.jmxServiceURL = jmxServiceURL;
        this.brokerType = brokerType;
        this.jmxConnectorEnv = jmxConnectorEnv;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "MQJMXConnectorInfo : brokerInstanceName " + brokerInstanceName + " ASInstanceName " + asInstanceName + " jmxServiceURL " + jmxServiceURL + " BrokerType " + brokerType + " jmxConnectorEnv " + jmxConnectorEnv);
        }
    }

    public String getBrokerInstanceName() {
        return this.brokerInstanceName;
    }

    public String getBrokerType() {
        return this.brokerType;
    }

    public String getASInstanceName() {
        return this.asInstanceName;
    }

    public String getJMXServiceURL() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "MQJMXConnectorInfo :: JMXServiceURL is " + this.jmxServiceURL);
        }
        return this.jmxServiceURL;
    }

    public Map<String, ?> getJMXConnectorEnv() {
        return this.jmxConnectorEnv;
    }

    public MBeanServerConnection getMQMBeanServerConnection() throws ConnectorRuntimeException {
        try {
            if (this.connector == null) {
                if (this.getJMXServiceURL() == null || this.getJMXServiceURL().isEmpty()) {
                    String msg = localStrings.getLocalString("error.get.jmsserviceurl", "Failed to get MQ JMXServiceURL of {0}.", new Object[]{this.getASInstanceName()});
                    throw new ConnectorRuntimeException(msg);
                }
                _logger.log(Level.FINE, "creating MBeanServerConnection to MQ JMXServer with {0}", this.getJMXServiceURL());
                JMXServiceURL serviceURL = new JMXServiceURL(this.getJMXServiceURL());
                this.connector = JMXConnectorFactory.connect(serviceURL, this.jmxConnectorEnv);
            }
            MBeanServerConnection mbsc = this.connector.getMBeanServerConnection();
            return mbsc;
        }
        catch (Exception e) {
            throw new ConnectorRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() throws ConnectorRuntimeException {
        try {
            if (this.connector != null) {
                this.connector.close();
                this.connector = null;
            }
        }
        catch (IOException e) {
            throw new ConnectorRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

