/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.WebServiceHandlerChain;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.AdminAdapter;
import com.sun.enterprise.v3.admin.adapter.AdminConsoleAdapter;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.SDDocumentSource;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeader;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.HandlerResolver;
import jakarta.xml.ws.soap.SOAPBinding;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Adapter;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.web.deployment.util.VirtualServerInfo;
import org.glassfish.web.deployment.util.WebServerInfo;
import org.glassfish.web.util.HtmlEntityEncoder;
import org.glassfish.webservices.HandlerResolverImpl;
import org.glassfish.webservices.Import;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.PortInfoImpl;
import org.glassfish.webservices.WebServiceContractImpl;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class WsUtil {
    public static final String CLIENT_TRANSPORT_LOG_PROPERTY = "com.sun.enterprise.webservice.client.transport.log";
    public static final String ENDPOINT_ADDRESS_PARAM_NAME = "endpointAddressParam";
    public static final String WSDL_IMPORT_NAMESPACE_PARAM_NAME = "wsdlImportNamespaceParam";
    public static final String WSDL_IMPORT_LOCATION_PARAM_NAME = "wsdlImportLocationParam";
    public static final String WSDL_INCLUDE_LOCATION_PARAM_NAME = "wsdlIncludeLocationParam";
    public static final String SCHEMA_IMPORT_NAMESPACE_PARAM_NAME = "schemaImportNamespaceParam";
    public static final String SCHEMA_IMPORT_LOCATION_PARAM_NAME = "schemaImportLocationParam";
    public static final String SCHEMA_INCLUDE_LOCATION_PARAM_NAME = "schemaIncludeLocationParam";
    private static final String SOAP11_TOKEN = "##SOAP11_HTTP";
    private static final String SOAP12_TOKEN = "##SOAP12_HTTP";
    private static final String SOAP11_MTOM_TOKEN = "##SOAP11_HTTP_MTOM";
    private static final String SOAP12_MTOM_TOKEN = "##SOAP12_HTTP_MTOM";
    private static final String XML_TOKEN = "##XML_HTTP";
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(WsUtil.class);
    private static final Logger LOG = LogUtils.getLogger();
    private final Config config = WebServiceContractImpl.getInstance().getConfig();
    private List<NetworkListener> networkListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleGet(HttpServletRequest request, HttpServletResponse response, WebServiceEndpoint endpoint) throws IOException {
        MimeHeaders headers = this.getHeaders(request);
        if (this.hasSomeTextXmlContent(headers)) {
            String message = MessageFormat.format(LOG.getResourceBundle().getString("AS-WSJSR109IMPL-00094"), endpoint.getEndpointName(), endpoint.getEndpointAddressUri());
            this.writeInvalidMethodType(response, message);
            LOG.info(message);
            return false;
        }
        String requestUriRaw = request.getRequestURI();
        String requestUri = requestUriRaw.charAt(0) == '/' ? requestUriRaw.substring(1) : requestUriRaw;
        String queryString = request.getQueryString();
        WebService webService = endpoint.getWebService();
        URL wsdlUrl = null;
        if (queryString == null) {
            String wsdlPath = endpoint.getWsdlContentPath(requestUri);
            if (wsdlPath != null) {
                ModuleDescriptor module = webService.getBundleDescriptor().getModuleDescriptor();
                if (wsdlPath.equals(webService.getWsdlFileUri())) {
                    wsdlUrl = webService.getWsdlFileUrl();
                } else if (this.isWsdlContent(wsdlPath, webService.getBundleDescriptor())) {
                    URL finalWsdlUrl = webService.getWsdlFileUrl();
                    String finalWsdlPath = finalWsdlUrl.getPath();
                    String wsdlDirPath = finalWsdlPath.substring(0, finalWsdlPath.length() - webService.getWsdlFileUri().length());
                    File wsdlDir = new File(wsdlDirPath);
                    File wsdlFile = new File(wsdlDir, wsdlPath.replace('/', File.separatorChar));
                    try {
                        wsdlUrl = wsdlFile.toURI().toURL();
                    }
                    catch (MalformedURLException mue) {
                        String msg = MessageFormat.format(LOG.getResourceBundle().getString("AS-WSJSR109IMPL-00096"), webService.getName());
                        LOG.log(Level.INFO, msg, mue);
                    }
                }
            }
        } else if (queryString.equalsIgnoreCase("WSDL")) {
            wsdlUrl = webService.getWsdlFileUrl();
        }
        boolean success = false;
        if (wsdlUrl != null) {
            InputStream is = null;
            try {
                response.setContentType("text/xml");
                response.setStatus(200);
                if (wsdlUrl.toURI().equals(webService.getWsdlFileUrl().toURI())) {
                    try {
                        WebServerInfo wsi = this.getWebServerInfoForDAS();
                        URL url = webService.getWsdlFileUrl();
                        File originalWsdlFile = new File(url.getPath() + "__orig");
                        if (!originalWsdlFile.exists()) {
                            originalWsdlFile = new File(url.getPath());
                        }
                        this.generateFinalWsdl(originalWsdlFile.toURL(), webService, wsi, (OutputStream)response.getOutputStream());
                    }
                    catch (Exception e) {
                        URLConnection urlCon = wsdlUrl.openConnection();
                        urlCon.setUseCaches(false);
                        is = urlCon.getInputStream();
                        this.copyIsToOs(is, (OutputStream)response.getOutputStream());
                    }
                } else {
                    URLConnection urlCon = wsdlUrl.openConnection();
                    urlCon.setUseCaches(false);
                    is = urlCon.getInputStream();
                    this.copyIsToOs(is, (OutputStream)response.getOutputStream());
                }
                success = true;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "AS-WSJSR109IMPL-00095", new Object[]{wsdlUrl, request.getRequestURL() + (String)(queryString == null ? "" : "?" + queryString)});
                }
            }
            catch (Exception e) {
                String msg = MessageFormat.format(LOG.getResourceBundle().getString("AS-WSJSR109IMPL-00096"), webService.getName());
                LOG.log(Level.INFO, msg, e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!success) {
            String message = MessageFormat.format(LOG.getResourceBundle().getString("AS-WSJSR109IMPL-00097"), request.getRequestURL() + (String)(queryString != null ? "?" + queryString : ""), webService.getName());
            LOG.info(message);
            this.writeInvalidMethodType(response, message);
        }
        return success;
    }

    private void copyIsToOs(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[4096];
        int len = 0;
        while (len != -1) {
            try {
                len = is.read(buf, 0, buf.length);
            }
            catch (EOFException eof) {
                break;
            }
            if (len == -1) continue;
            os.write(buf, 0, len);
        }
        os.flush();
        is.close();
        os.close();
    }

    public boolean isWsdlContent(String uri, BundleDescriptor bundle) {
        String wsdlDir = this.getWsdlDir(bundle);
        return uri != null && uri.startsWith(wsdlDir);
    }

    public String getWsdlDir(BundleDescriptor bundle) {
        boolean isWar = bundle.getModuleType().equals((Object)DOLUtils.warType());
        return isWar ? "WEB-INF/wsdl" : "META-INF/wsdl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseRelativeImports(URL wsdlFileUrl, Collection<Import> wsdlRelativeImports, Collection<Import> wsdlIncludes, Collection<Import> schemaRelativeImports, Collection<Import> schemaIncludes) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException pce) {
            LOG.log(Level.FINE, "AS-WSJSR109IMPL-00122", new Object[]{factory.getClass().getName(), "http://apache.org/xml/features/disallow-doctype-decl"});
        }
        InputStream is = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            is = wsdlFileUrl.openStream();
            Document document = builder.parse(is);
            this.procesSchemaImports(document, schemaRelativeImports);
            this.procesWsdlImports(document, wsdlRelativeImports);
            this.procesSchemaIncludes(document, schemaIncludes);
            this.procesWsdlIncludes(document, wsdlIncludes);
        }
        catch (SAXParseException spe) {
            LOG.log(Level.SEVERE, "AS-WSJSR109IMPL-00013", new Object[]{spe.getLineNumber(), spe.getSystemId()});
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            LOG.log(Level.SEVERE, "AS-WSJSR109IMPL-00079", x);
        }
        catch (Exception sxe) {
            LOG.log(Level.SEVERE, "AS-WSJSR109IMPL-00014", sxe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException spe) {}
        }
    }

    private void addImportsAndIncludes(NodeList list, Collection<Import> result, String namespace, String location) {
        for (int i = 0; i < list.getLength(); ++i) {
            String givenLocation = null;
            Node element = list.item(i);
            NamedNodeMap attrs = element.getAttributes();
            Node n = attrs.getNamedItem(location);
            if (n != null) {
                givenLocation = n.getNodeValue();
            }
            if (givenLocation == null || givenLocation.startsWith("http")) continue;
            Import imp = new Import();
            imp.setLocation(givenLocation);
            if (namespace != null && (n = attrs.getNamedItem(namespace)) != null) {
                imp.setNamespace(n.getNodeValue());
            }
            result.add(imp);
        }
    }

    private void procesSchemaImports(Document document, Collection<Import> schemaImportCollection) {
        NodeList schemaImports = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        this.addImportsAndIncludes(schemaImports, schemaImportCollection, "namespace", "schemaLocation");
    }

    private void procesWsdlImports(Document document, Collection<Import> wsdlImportCollection) {
        NodeList wsdlImports = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        this.addImportsAndIncludes(wsdlImports, wsdlImportCollection, "namespace", "location");
    }

    private void procesSchemaIncludes(Document document, Collection<Import> schemaIncludeCollection) {
        NodeList schemaIncludes = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        this.addImportsAndIncludes(schemaIncludes, schemaIncludeCollection, null, "schemaLocation");
    }

    private void procesWsdlIncludes(Document document, Collection<Import> wsdlIncludesCollection) {
        NodeList wsdlIncludes = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "include");
        this.addImportsAndIncludes(wsdlIncludes, wsdlIncludesCollection, null, "location");
    }

    public void generateFinalWsdl(URL wsdlFileUrl, WebService webService, WebServerInfo wsi, File finalWsdlFile) throws Exception {
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(finalWsdlFile));
        this.generateFinalWsdl(wsdlFileUrl, webService, wsi, outputStream);
    }

    /*
     * WARNING - void declaration
     */
    public void generateFinalWsdl(URL wsdlFileUrl, WebService webService, WebServerInfo wsi, OutputStream outputStream) throws Exception {
        HashSet<Import> wsdlRelativeImports = new HashSet<Import>();
        HashSet<Import> wsdlIncludes = new HashSet<Import>();
        HashSet<Import> schemaRelativeImports = new HashSet<Import>();
        HashSet<Import> schemaIncludes = new HashSet<Import>();
        if (webService.hasUrlPublishing()) {
            this.parseRelativeImports(wsdlFileUrl, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        }
        Collection endpoints = webService.getEndpoints();
        ArrayList<WebServiceEndpoint> endpointsCopy = new ArrayList<WebServiceEndpoint>();
        endpointsCopy.addAll(endpoints);
        BundleDescriptor bundle = webService.getBundleDescriptor();
        WebServicesDescriptor wsd = bundle.getWebServices();
        Collection webServices = wsd.getWebServices();
        if (webServices.size() > 1) {
            for (WebService aWS : webServices) {
                if (webService.getName().equals(aWS.getName())) continue;
                if (webService.getWsdlFileUri() != null && aWS.getWsdlFileUri() != null && webService.getWsdlFileUri().equals(aWS.getWsdlFileUri())) {
                    endpointsCopy.addAll(aWS.getEndpoints());
                    continue;
                }
                if (webService.getWsdlFileUrl() == null || aWS.getWsdlFileUrl() == null || !webService.getWsdlFileUrl().toString().equals(aWS.getWsdlFileUrl().toString())) continue;
                endpointsCopy.addAll(aWS.getEndpoints());
            }
        }
        BufferedInputStream wsdlInputStream = new BufferedInputStream(wsdlFileUrl.openStream());
        StreamSource XsltWsdlDocument = new StreamSource(wsdlInputStream);
        Templates templates = this.createTemplatesFor(endpointsCopy, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        Transformer transformer = templates.newTransformer();
        WebServiceEndpoint endpointForImport = webService.pickEndpointForRelativeImports();
        URL root = wsi.getWebServerRootURL(endpointForImport.isSecure());
        URL finalWsdlUrl = endpointForImport.composeFinalWsdlUrl(root);
        int wsdlImportNum = 0;
        for (Import import_ : wsdlRelativeImports) {
            transformer.setParameter(WSDL_IMPORT_NAMESPACE_PARAM_NAME + wsdlImportNum, import_.getNamespace());
            URL uRL = new URL(finalWsdlUrl, import_.getLocation());
            transformer.setParameter(WSDL_IMPORT_LOCATION_PARAM_NAME + wsdlImportNum, uRL);
            ++wsdlImportNum;
        }
        int schemaImportNum = 0;
        for (Import import_ : schemaRelativeImports) {
            transformer.setParameter(SCHEMA_IMPORT_NAMESPACE_PARAM_NAME + schemaImportNum, import_.getNamespace());
            URL uRL = new URL(finalWsdlUrl, import_.getLocation());
            transformer.setParameter(SCHEMA_IMPORT_LOCATION_PARAM_NAME + schemaImportNum, uRL);
            ++schemaImportNum;
        }
        boolean bl = false;
        for (Import import_ : wsdlIncludes) {
            void var23_27;
            URL relativeUrl = new URL(finalWsdlUrl, import_.getLocation());
            transformer.setParameter(WSDL_INCLUDE_LOCATION_PARAM_NAME + (int)var23_27, relativeUrl);
            ++var23_27;
        }
        boolean bl2 = false;
        for (Import next : schemaIncludes) {
            void var24_33;
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(SCHEMA_INCLUDE_LOCATION_PARAM_NAME + (int)var24_33, relativeUrl);
            ++var24_33;
        }
        boolean bl3 = false;
        for (WebServiceEndpoint next : endpointsCopy) {
            void var25_39;
            URL rootURL = wsi.getWebServerRootURL(next.isSecure());
            URL actualAddress = next.composeEndpointAddress(rootURL);
            transformer.setParameter(ENDPOINT_ADDRESS_PARAM_NAME + (int)var25_39, actualAddress.toExternalForm());
            String endpointType = next.implementedByEjbComponent() ? "EJB" : "Servlet";
            LOG.log(Level.INFO, "AS-WSJSR109IMPL-00018", new Object[]{"[" + endpointType + "] " + next.getEndpointName(), actualAddress});
            ++var25_39;
        }
        transformer.transform(XsltWsdlDocument, new StreamResult(outputStream));
        ((InputStream)wsdlInputStream).close();
        outputStream.close();
    }

    public URL privilegedGetServiceRefWsdl(ServiceReferenceDescriptor serviceRef) throws Exception {
        try {
            PrivilegedExceptionAction<URL> action = () -> {
                if (serviceRef.hasWsdlOverride()) {
                    return serviceRef.getWsdlOverride();
                }
                if (serviceRef.getWsdlFileUrl() != null) {
                    return serviceRef.getWsdlFileUrl();
                }
                String wsdlFileUri = serviceRef.getWsdlFileUri();
                if (wsdlFileUri.startsWith("http")) {
                    return new URL(wsdlFileUri);
                }
                if (wsdlFileUri.startsWith("WEB-INF") || wsdlFileUri.startsWith("META-INF")) {
                    ServerEnvironment se = WebServiceContractImpl.getInstance().getServerEnvironment();
                    String appName = serviceRef.getBundleDescriptor().getApplication().getAppName();
                    File appFile = new File(se.getApplicationRepositoryPath(), appName);
                    if (appFile.exists()) {
                        File wsdlFile = new File(appFile, wsdlFileUri);
                        if (wsdlFile.exists()) {
                            return wsdlFile.toURI().toURL();
                        }
                        wsdlFile = new File(serviceRef.getBundleDescriptor().getRawModuleID(), wsdlFileUri);
                        if (wsdlFile.exists()) {
                            return wsdlFile.toURI().toURL();
                        }
                    }
                    return Thread.currentThread().getContextClassLoader().getResource(wsdlFileUri);
                }
                return new File(wsdlFileUri).toURI().toURL();
            };
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            LOG.log(Level.WARNING, "AS-WSJSR109IMPL-00050", pae);
            Exception e = new Exception();
            e.initCause(pae.getCause());
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Templates createTemplatesFor(Collection<WebServiceEndpoint> endpoints, Collection<Import> wsdlRelativeImports, Collection<Import> wsdlIncludes, Collection<Import> schemaRelativeImports, Collection<Import> schemaIncludes) throws Exception {
        String importLocationParam;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, "UTF-8");
        writer.write("<xsl:transform version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" xmlns:soap12=\"http://schemas.xmlsoap.org/wsdl/soap12/\">\n");
        int wsdlImportNum = 0;
        for (Import import_ : wsdlRelativeImports) {
            String string = WSDL_IMPORT_NAMESPACE_PARAM_NAME + wsdlImportNum;
            String string2 = WSDL_IMPORT_LOCATION_PARAM_NAME + wsdlImportNum;
            writer.write("<xsl:param name=\"" + string + "\"/>\n");
            writer.write("<xsl:param name=\"" + string2 + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:import[@location='");
            writer.write(import_.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<wsdl:import>");
            writer.write("<xsl:attribute name=\"namespace\"><xsl:value-of select=\"$" + string + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("<xsl:attribute name=\"location\"><xsl:value-of select=\"$" + string2 + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</wsdl:import></xsl:template>");
            ++wsdlImportNum;
        }
        int wsdlIncludeNum = 0;
        for (Import import_ : wsdlIncludes) {
            String string = WSDL_INCLUDE_LOCATION_PARAM_NAME + wsdlIncludeNum;
            writer.write("<xsl:param name=\"" + string + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:include[@location='");
            writer.write(import_.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<wsdl:include>");
            writer.write("<xsl:attribute name=\"location\"><xsl:value-of select=\"$" + string + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</wsdl:include></xsl:template>");
            ++wsdlIncludeNum;
        }
        boolean bl = false;
        for (Import import_ : schemaRelativeImports) {
            void var10_14;
            String string = SCHEMA_IMPORT_NAMESPACE_PARAM_NAME + (int)var10_14;
            importLocationParam = SCHEMA_IMPORT_LOCATION_PARAM_NAME + (int)var10_14;
            writer.write("<xsl:param name=\"" + string + "\"/>\n");
            writer.write("<xsl:param name=\"" + importLocationParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:types/xsd:schema/xsd:import[@schemaLocation='");
            writer.write(import_.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<xsd:import>");
            writer.write("<xsl:attribute name=\"namespace\"><xsl:value-of select=\"$" + string + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("<xsl:attribute name=\"schemaLocation\"><xsl:value-of select=\"$" + importLocationParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</xsd:import></xsl:template>");
            ++var10_14;
        }
        boolean bl2 = false;
        for (Import import_ : schemaIncludes) {
            void var11_20;
            importLocationParam = SCHEMA_INCLUDE_LOCATION_PARAM_NAME + (int)var11_20;
            writer.write("<xsl:param name=\"" + importLocationParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:types/xsd:schema/xsd:include[@schemaLocation='");
            writer.write(import_.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<xsd:include>");
            writer.write("<xsl:attribute name=\"schemaLocation\"><xsl:value-of select=\"$" + importLocationParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</xsd:include></xsl:template>");
            ++var11_20;
        }
        boolean bl3 = false;
        for (WebServiceEndpoint endpoint : endpoints) {
            void var12_28;
            if (!endpoint.hasWsdlPort()) {
                throw new Exception("No WSDL port specified for endpoint " + endpoint.getEndpointName());
            }
            if (!endpoint.hasServiceName()) {
                throw new Exception("Runtime settings error.  Cannot find service name for endpoint " + endpoint.getEndpointName());
            }
            String actualAddressParam = ENDPOINT_ADDRESS_PARAM_NAME + (int)var12_28;
            writer.write("<xsl:param name=\"" + actualAddressParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions[@targetNamespace='");
            writer.write(endpoint.getServiceName().getNamespaceURI());
            writer.write("']/wsdl:service[@name='");
            writer.write(endpoint.getServiceName().getLocalPart());
            writer.write("']/wsdl:port[@name='");
            writer.write(endpoint.getWsdlPort().getLocalPart());
            writer.write("']/" + endpoint.getSoapAddressPrefix() + ":address\" mode=\"copy\">");
            writer.write("<" + endpoint.getSoapAddressPrefix() + ":address><xsl:attribute name=\"location\"><xsl:value-of select=\"$" + actualAddressParam + "\"/>");
            writer.write("</xsl:attribute></" + endpoint.getSoapAddressPrefix() + ":address></xsl:template>");
            ++var12_28;
        }
        writer.write("<xsl:template match=\"@*|node()\" mode=\"copy\"><xsl:copy><xsl:apply-templates select=\"@*\" mode=\"copy\"/><xsl:apply-templates mode=\"copy\"/></xsl:copy></xsl:template>\n");
        writer.write("</xsl:transform>\n");
        writer.close();
        byte[] byArray = bos.toByteArray();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(new String(byArray));
        }
        StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(byArray));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Templates templates = transformerFactory.newTemplates(stylesheetSource);
        return templates;
    }

    private static void putHeaders(MimeHeaders headers, HttpServletResponse response) {
        headers.removeHeader("Content-Type");
        headers.removeHeader("Content-Length");
        Iterator it = headers.getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            response.setHeader(header.getName(), header.getValue());
        }
    }

    public static void raiseException(HttpServletResponse resp, String binding, String faultString) {
        resp.setStatus(500);
        if ("http://www.w3.org/2004/08/wsdl/http".equals(binding)) {
            resp.setContentType("text/xml");
            try {
                PrintWriter writer = new PrintWriter((OutputStream)resp.getOutputStream());
                writer.println("<error>" + faultString + "</error>");
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, "AS-WSJSR109IMPL-00099", ioe.getMessage());
            }
        } else {
            String protocol = "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(binding) ? "SOAP 1.2 Protocol" : "SOAP 1.1 Protocol";
            SOAPMessage fault = WsUtil.getSOAPFault(protocol, faultString);
            if (fault != null) {
                resp.setContentType("text/xml");
                try {
                    fault.writeTo((OutputStream)resp.getOutputStream());
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "AS-WSJSR109IMPL-00100", ex);
                }
            }
        }
    }

    public static SOAPMessage getSOAPFault(String protocol, String faultString) {
        if (protocol == null) {
            protocol = "SOAP 1.1 Protocol";
        }
        try {
            MessageFactory factory = MessageFactory.newInstance((String)protocol);
            if (factory == null) {
                factory = MessageFactory.newInstance();
            }
            SOAPMessage message = factory.createMessage();
            SOAPBody body = message.getSOAPBody();
            SOAPFault fault = body.addFault();
            fault.setFaultString(faultString);
            SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
            String envelopeNamespace = envelope.getNamespaceURI();
            QName faultCode = new QName(envelopeNamespace, "Server", "env");
            fault.setFaultCode(faultCode);
            return message;
        }
        catch (SOAPException e) {
            LOG.log(Level.WARNING, "AS-WSJSR109IMPL-00101", faultString);
            return null;
        }
    }

    void writeInvalidContentType(HttpServletResponse response) throws SOAPException, IOException {
        response.setStatus(415);
        this.setContentTypeAndFlush(response);
    }

    void writeInvalidMethodType(HttpServletResponse response, String message) throws IOException {
        response.setStatus(405);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println("Invalid Method Type");
        out.println("</title></head>");
        out.println("<body>");
        out.println(HtmlEntityEncoder.encodeXSS((String)message));
        out.println("</body>");
        out.println("</html>");
    }

    private void setContentTypeAndFlush(HttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        response.flushBuffer();
        response.getWriter().close();
    }

    boolean hasSomeTextXmlContent(MimeHeaders headers) {
        return this.hasTextXmlContentType(headers) && this.getContentLength(headers) > 0;
    }

    private int getContentLength(MimeHeaders headers) {
        String[] contentLength = headers.getHeader("Content-Length");
        int length = 0;
        if (contentLength != null && contentLength.length > 0) {
            length = Integer.parseInt(contentLength[0]);
        }
        return length;
    }

    boolean hasTextXmlContentType(MimeHeaders headers) {
        String[] contentTypes = headers.getHeader("Content-Type");
        return contentTypes != null && contentTypes.length >= 1 && contentTypes[0].indexOf("text/xml") != -1;
    }

    MimeHeaders getHeaders(HttpServletRequest request) {
        Enumeration e = request.getHeaderNames();
        MimeHeaders headers = new MimeHeaders();
        while (e.hasMoreElements()) {
            String headerName = (String)e.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.addHeader(headerName, headerValue);
        }
        return headers;
    }

    public WebServerInfo getWebServerInfoForDAS() {
        WebServerInfo wsi = new WebServerInfo();
        if (this.networkListeners == null) {
            ArrayList<Integer> adminPorts = new ArrayList<Integer>();
            for (Adapter subAdapter : WebServiceContractImpl.getInstance().getAdapters()) {
                if (subAdapter instanceof AdminAdapter) {
                    AdminAdapter aa = (AdminAdapter)subAdapter;
                    adminPorts.add(aa.getListenPort());
                    continue;
                }
                if (!(subAdapter instanceof AdminConsoleAdapter)) continue;
                AdminConsoleAdapter aca = (AdminConsoleAdapter)subAdapter;
                adminPorts.add(aca.getListenPort());
            }
            for (NetworkListener nl : this.config.getNetworkConfig().getNetworkListeners().getNetworkListener()) {
                if (adminPorts.contains(Integer.valueOf(nl.getPort()))) continue;
                if (this.networkListeners == null) {
                    this.networkListeners = new ArrayList<NetworkListener>();
                }
                this.networkListeners.add(nl);
            }
        }
        if (this.networkListeners != null && !this.networkListeners.isEmpty()) {
            for (NetworkListener listener : this.networkListeners) {
                String host = listener.getAddress();
                if (listener.getAddress().equals("0.0.0.0")) {
                    try {
                        host = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        host = "localhost";
                    }
                }
                if (listener.findHttpProtocol().getSecurityEnabled().equals("false")) {
                    wsi.setHttpVS(new VirtualServerInfo("http", host, Integer.parseInt(listener.getPort())));
                    continue;
                }
                if (!listener.findHttpProtocol().getSecurityEnabled().equals("true")) continue;
                wsi.setHttpsVS(new VirtualServerInfo("https", host, Integer.parseInt(listener.getPort())));
            }
        } else {
            wsi.setHttpVS(new VirtualServerInfo("http", "localhost", 0));
            wsi.setHttpsVS(new VirtualServerInfo("https", "localhost", 0));
        }
        return wsi;
    }

    public static Logger getDefaultLogger() {
        return LOG;
    }

    public static LocalStringManagerImpl getDefaultStringManager() {
        return I18N;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateEjbEndpoint(WebServiceEndpoint ejbEndpoint) {
        EjbDescriptor ejbDescriptor = ejbEndpoint.getEjbComponentImpl();
        EjbBundleDescriptor bundle = ejbDescriptor.getEjbBundleDescriptor();
        WebServicesDescriptor webServices = bundle.getWebServices();
        Collection endpoints = webServices.getEndpointsImplementedBy(ejbDescriptor);
        if (endpoints.size() == 1) {
            if (ejbDescriptor.hasWebServiceEndpointInterface()) {
                if (ejbEndpoint.getServiceEndpointInterface().equals(ejbDescriptor.getWebServiceEndpointInterfaceName())) return;
                String msg = "Ejb " + ejbDescriptor.getName() + " service endpoint interface does not match  port component " + ejbEndpoint.getEndpointName();
                throw new IllegalStateException(msg);
            }
            String msg = "Ejb " + ejbDescriptor.getName() + " must declare <service-endpoint> interface";
            throw new IllegalStateException(msg);
        }
        if (endpoints.size() <= 1) return;
        String msg = "Ejb " + ejbDescriptor.getName() + " implements " + endpoints.size() + " web service endpoints  but must only implement 1";
        throw new IllegalStateException(msg);
    }

    public void updateServletEndpointRuntime(WebServiceEndpoint endpoint) {
        endpoint.saveServletImplClass();
        WebComponentDescriptor webComp = endpoint.getWebComponentImpl();
        WebBundleDescriptor bundle = webComp.getWebBundleDescriptor();
        WebServicesDescriptor webServices = bundle.getWebServices();
        Collection endpoints = webServices.getEndpointsImplementedBy(webComp);
        if (endpoints.size() > 1) {
            String msg = "Servlet " + endpoint.getWebComponentLink() + " implements " + endpoints.size() + " web service endpoints  but must only implement 1";
            throw new IllegalStateException(msg);
        }
        if (endpoint.getEndpointAddressUri() == null) {
            Set urlPatterns = webComp.getUrlPatternsSet();
            if (urlPatterns.size() != 1) {
                String msg = "Endpoint " + endpoint.getEndpointName() + " has not been assigned an endpoint address  and is associated with servlet " + webComp.getCanonicalName() + " , which has " + urlPatterns.size() + " url patterns";
                throw new IllegalStateException(msg);
            }
            String uri = (String)urlPatterns.iterator().next();
            endpoint.setEndpointAddressUri(uri);
            Collection constraints = bundle.getSecurityConstraintsForUrlPattern(uri);
            for (SecurityConstraint next : constraints) {
                String guarantee;
                UserDataConstraint dataConstraint = next.getUserDataConstraint();
                String string = guarantee = dataConstraint != null ? dataConstraint.getTransportGuarantee() : null;
                if (!"INTEGRAL".equals(guarantee) && !"CONFIDENTIAL".equals(guarantee)) continue;
                endpoint.setTransportGuarantee(guarantee);
                break;
            }
        }
    }

    public Collection getWsdlsAndSchemas(File pkgedWsdl) throws Exception {
        ArrayList<SDDocumentSource> cumulative = new ArrayList<SDDocumentSource>();
        this.getWsdlsAndSchemas(pkgedWsdl, cumulative);
        URL id = pkgedWsdl.toURI().toURL();
        SDDocumentSource toRemove = null;
        for (SDDocumentSource source : cumulative) {
            if (!id.toString().equals(source.getSystemId().toString())) continue;
            toRemove = source;
        }
        if (toRemove != null) {
            cumulative.remove(toRemove);
        }
        return cumulative;
    }

    public Collection<SDDocumentSource> getWsdlsAndSchemas(URL pkgedWsdl) throws Exception {
        ArrayList<SDDocumentSource> cumulative = new ArrayList<SDDocumentSource>();
        this.getWsdlsAndSchemas(pkgedWsdl, cumulative);
        SDDocumentSource toRemove = null;
        for (SDDocumentSource source : cumulative) {
            if (!pkgedWsdl.toString().equals(source.getSystemId().toString())) continue;
            toRemove = source;
        }
        if (toRemove != null) {
            cumulative.remove(toRemove);
        }
        return cumulative;
    }

    private void getWsdlsAndSchemas(URL wsdlRoot, ArrayList<SDDocumentSource> cumulative) throws Exception {
        HashSet<Import> wsdlRelativeImports = new HashSet<Import>();
        HashSet<Import> schemaRelativeImports = new HashSet<Import>();
        HashSet<Import> wsdlIncludes = new HashSet<Import>();
        HashSet<Import> schemaIncludes = new HashSet<Import>();
        this.parseRelativeImports(wsdlRoot, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        wsdlRelativeImports.addAll(wsdlIncludes);
        schemaRelativeImports.addAll(schemaIncludes);
        for (Import next : schemaRelativeImports) {
            this.addFileAndDecendents(wsdlRoot.toURI().resolve(new URI(null, next.getLocation(), null).toASCIIString()).toURL(), cumulative);
        }
        for (Import next : wsdlRelativeImports) {
            this.addFileAndDecendents(wsdlRoot.toURI().resolve(new URI(null, next.getLocation(), null).toASCIIString()).toURL(), cumulative);
        }
    }

    private void addFileAndDecendents(URL fileUrl, ArrayList<SDDocumentSource> cumulative) throws Exception {
        boolean alreadyProcessed = false;
        for (SDDocumentSource source : cumulative) {
            if (!fileUrl.toString().equals(source.getSystemId().toString())) continue;
            alreadyProcessed = true;
            break;
        }
        if (!alreadyProcessed) {
            cumulative.add(0, SDDocumentSource.create((URL)fileUrl));
            this.getWsdlsAndSchemas(fileUrl, cumulative);
        }
    }

    public void getWsdlsAndSchemas(File wsdl, ArrayList<SDDocumentSource> cumulative) throws Exception {
        String location;
        HashSet<Import> wsdlRelativeImports = new HashSet<Import>();
        HashSet<Import> schemaRelativeImports = new HashSet<Import>();
        HashSet<Import> wsdlIncludes = new HashSet<Import>();
        HashSet<Import> schemaIncludes = new HashSet<Import>();
        String wsdlRoot = wsdl.getParent();
        this.parseRelativeImports(wsdl.toURI().toURL(), wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        wsdlRelativeImports.addAll(wsdlIncludes);
        schemaRelativeImports.addAll(schemaIncludes);
        for (Import next : schemaRelativeImports) {
            location = next.getLocation();
            location = location.replaceAll("/", "\\" + File.separator);
            File file = new File(wsdlRoot + File.separator + location).getCanonicalFile();
            this.addFileAndDecendents(file, cumulative);
        }
        for (Import next : wsdlRelativeImports) {
            location = next.getLocation();
            location = location.replaceAll("/", "\\" + File.separator);
            File currentWsdlFile = new File(wsdlRoot + File.separator + location).getCanonicalFile();
            this.addFileAndDecendents(currentWsdlFile, cumulative);
        }
    }

    private void addFileAndDecendents(File file, ArrayList<SDDocumentSource> cumulative) throws Exception {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        URL id = file.toURI().toURL();
        boolean alreadyProcessed = false;
        for (SDDocumentSource source : cumulative) {
            if (!id.toString().equals(source.getSystemId().toString())) continue;
            alreadyProcessed = true;
            break;
        }
        if (!alreadyProcessed) {
            cumulative.add(0, SDDocumentSource.create((URL)id));
            this.getWsdlsAndSchemas(file, cumulative);
        }
    }

    public void doPostConstruct(Class impl, Object implObj) {
        this.invokeServiceMethod(PostConstruct.class, impl, implObj);
    }

    public void doPreDestroy(WebServiceEndpoint ep, ClassLoader loader) {
        try {
            Class<?> impl = Class.forName(ep.getServletImplClass(), true, loader);
            this.invokeServiceMethod(PreDestroy.class, impl, impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable ex) {
            String msg = MessageFormat.format(LOG.getResourceBundle().getString("AS-WSJSR109IMPL-00102"), ep.getServletImplClass());
            LOG.log(Level.SEVERE, msg, ex);
        }
        if (!ep.hasHandlerChain()) {
            return;
        }
        for (WebServiceHandlerChain thisHc : ep.getHandlerChain()) {
            for (WebServiceHandler thisHandler : thisHc.getHandlers()) {
                try {
                    Class<?> handlerClass = Class.forName(thisHandler.getHandlerClass(), true, loader);
                    this.invokeServiceMethod(PreDestroy.class, handlerClass, handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable ex) {
                    String msg = MessageFormat.format(LOG.getResourceBundle().getString("AS-WSJSR109IMPL-00103"), thisHandler.getHandlerClass());
                    LOG.log(Level.SEVERE, msg, ex);
                }
            }
        }
    }

    private void invokeServiceMethod(Class annType, Class impl, final Object implObj) {
        Method[] methods;
        for (final Method method : methods = impl.getDeclaredMethods()) {
            if (method.getAnnotation(annType) == null) continue;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, InvocationTargetException {
                        if (!method.trySetAccessible()) {
                            throw new InaccessibleObjectException("Unable to make accessible: " + method);
                        }
                        method.invoke(implObj, new Object[0]);
                        return null;
                    }
                });
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "AS-WSJSR109IMPL-00104", e);
            }
            break;
        }
    }

    private boolean matchQNamePatterns(QName cfgQName, QName givenPattern) {
        if (givenPattern.getNamespaceURI().equals(cfgQName.getNamespaceURI())) {
            String expr = givenPattern.getLocalPart().replaceAll("\\*", ".*");
            return Pattern.matches(expr, cfgQName.getLocalPart());
        }
        return false;
    }

    private boolean patternsMatch(WebServiceHandlerChain hc, QName svcName, QName portName, String bindingId) {
        QName portPattern;
        QName svcPattern;
        if (hc.getServiceNamePattern() != null && svcName != null && !this.matchQNamePatterns(svcName, svcPattern = QName.valueOf(hc.getServiceNamePattern()))) {
            return false;
        }
        if (hc.getPortNamePattern() != null && portName != null && !this.matchQNamePatterns(portName, portPattern = QName.valueOf(hc.getPortNamePattern()))) {
            return false;
        }
        if (hc.getProtocolBindings() != null && bindingId != null) {
            String givenBindings = hc.getProtocolBindings();
            if (bindingId.equals("http://www.w3.org/2004/08/wsdl/http") && (givenBindings.indexOf("http://www.w3.org/2004/08/wsdl/http") != -1 || givenBindings.indexOf(XML_TOKEN) != -1)) {
                return true;
            }
            if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http") && (givenBindings.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http") != -1 || givenBindings.indexOf(SOAP11_TOKEN) != -1)) {
                return true;
            }
            if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") && (givenBindings.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/") != -1 || givenBindings.indexOf(SOAP12_TOKEN) != -1)) {
                return true;
            }
            if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") && (givenBindings.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") != -1 || givenBindings.indexOf(SOAP11_MTOM_TOKEN) != -1)) {
                return true;
            }
            if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") && (givenBindings.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") != -1 || givenBindings.indexOf(SOAP12_MTOM_TOKEN) != -1)) {
                return true;
            }
        }
        return true;
    }

    private List<Handler<?>> processConfiguredHandlers(List<WebServiceHandler> handlersList, Set<String> roles) {
        ArrayList handlerChain = new ArrayList();
        for (WebServiceHandler h : handlersList) {
            Class<?> handlerClass;
            Handler handler = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                handlerClass = Class.forName(h.getHandlerClass(), true, loader);
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(LOG.getResourceBundle().getString("AS-WSJSR109IMPL-00105"), h.getHandlerClass());
                LOG.log(Level.SEVERE, msg, t);
                continue;
            }
            try {
                WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
                InjectionManager injManager = wscImpl.getInjectionManager();
                handler = (Handler)injManager.createManagedObject(handlerClass);
            }
            catch (InjectionException e) {
                LOG.log(Level.SEVERE, "AS-WSJSR109IMPL-00106", new Object[]{h.getHandlerClass(), e.getMessage()});
                continue;
            }
            Collection rolesColl = h.getSoapRoles();
            roles.addAll(rolesColl);
            handlerChain.add(handler);
        }
        return handlerChain;
    }

    public void configureJAXWSServiceHandlers(WebServiceEndpoint ep, String bindingId, WSBinding bindingObj) {
        if (!ep.hasHandlerChain()) {
            return;
        }
        LinkedList handlerChainList = ep.getHandlerChain();
        ArrayList finalHandlerList = new ArrayList();
        HashSet<String> roles = new HashSet<String>();
        for (WebServiceHandlerChain hc : handlerChainList) {
            if (!this.patternsMatch(hc, ep.getServiceName(), ep.getWsdlPort(), bindingId)) continue;
            List<Handler<?>> handlerInfo = this.processConfiguredHandlers(hc.getHandlers(), roles);
            finalHandlerList.addAll(handlerInfo);
        }
        bindingObj.setHandlerChain(finalHandlerList);
        if (bindingObj instanceof SOAPBinding) {
            ((SOAPBinding)bindingObj).setRoles(roles);
        }
    }

    public void configureJAXWSClientHandlers(Service svcClass, ServiceReferenceDescriptor desc) {
        HandlerResolverImpl resolver = new HandlerResolverImpl();
        HashSet<String> roles = new HashSet<String>();
        Iterator ports = svcClass.getPorts();
        while (ports.hasNext()) {
            QName nextPort = (QName)ports.next();
            LinkedList handlerChainList = desc.getHandlerChain();
            for (WebServiceHandlerChain hc : handlerChainList) {
                if (!this.patternsMatch(hc, desc.getServiceName(), nextPort, null)) continue;
                ArrayList<String> protocols = new ArrayList<String>();
                if (hc.getProtocolBindings() == null) {
                    protocols.add("http://www.w3.org/2004/08/wsdl/http");
                    protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http");
                    protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
                    protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
                    protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
                } else {
                    String specifiedProtocols = hc.getProtocolBindings();
                    if (specifiedProtocols.indexOf("http://www.w3.org/2004/08/wsdl/http") != -1 || specifiedProtocols.indexOf(XML_TOKEN) != -1) {
                        protocols.add("http://www.w3.org/2004/08/wsdl/http");
                    }
                    if (specifiedProtocols.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http") != -1 || specifiedProtocols.indexOf(SOAP11_TOKEN) != -1) {
                        protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http");
                    }
                    if (specifiedProtocols.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/") != -1 || specifiedProtocols.indexOf(SOAP12_TOKEN) != -1) {
                        protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
                    }
                    if (specifiedProtocols.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") != -1 || specifiedProtocols.indexOf(SOAP11_MTOM_TOKEN) != -1) {
                        protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
                    }
                    if (specifiedProtocols.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") != -1 || specifiedProtocols.indexOf(SOAP12_MTOM_TOKEN) != -1) {
                        protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
                    }
                }
                List handlersList = hc.getHandlers();
                for (WebServiceHandler thisOne : handlersList) {
                    Collection portNames = thisOne.getPortNames();
                    if (portNames.isEmpty() || portNames.contains(nextPort.getLocalPart())) continue;
                    handlersList.remove(thisOne);
                }
                List<Handler> handlerInfo = this.processConfiguredHandlers(handlersList, roles);
                for (String protocol : protocols) {
                    PortInfoImpl portInfo = new PortInfoImpl(BindingID.parse((String)protocol), nextPort, desc.getServiceName());
                    resolver.setHandlerChain(portInfo, handlerInfo);
                }
            }
        }
        svcClass.setHandlerResolver((HandlerResolver)resolver);
    }

    public boolean getMtom(WebServiceEndpoint ep) {
        String currentBinding = ep.getProtocolBinding();
        if (ep.getMtomEnabled() == null && ("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(currentBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(currentBinding))) {
            return true;
        }
        return Boolean.parseBoolean(ep.getMtomEnabled()) && ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(currentBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(currentBinding) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(currentBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(currentBinding));
    }
}

