/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractConfigImpl;
import io.helidon.config.Config;
import io.helidon.config.ConfigDiff;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigFactory;
import io.helidon.config.ConfigHelper;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigSourcesRuntime;
import io.helidon.config.ObjectNodeBuilderImpl;
import io.helidon.config.OverrideSourceRuntime;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigNode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ProviderImpl
implements Config.Context {
    private static final Logger LOGGER = Logger.getLogger(ConfigFactory.class.getName());
    private final List<Consumer<ConfigDiff>> listeners = new LinkedList<Consumer<ConfigDiff>>();
    private final ConfigMapperManager configMapperManager;
    private final ConfigSourcesRuntime configSource;
    private final OverrideSourceRuntime overrideSource;
    private final List<Function<Config, ConfigFilter>> filterProviders;
    private final boolean cachingEnabled;
    private final Executor changesExecutor;
    private final boolean keyResolving;
    private final boolean keyResolvingFailOnMissing;
    private final Function<String, List<String>> aliasGenerator;
    private ConfigDiff lastConfigsDiff;
    private AbstractConfigImpl lastConfig;
    private boolean listening;

    ProviderImpl(ConfigMapperManager configMapperManager, ConfigSourcesRuntime configSource, OverrideSourceRuntime overrideSource, List<Function<Config, ConfigFilter>> filterProviders, boolean cachingEnabled, Executor changesExecutor, boolean keyResolving, boolean keyResolvingFailOnMissing, Function<String, List<String>> aliasGenerator) {
        this.configMapperManager = configMapperManager;
        this.configSource = configSource;
        this.overrideSource = overrideSource;
        this.filterProviders = Collections.unmodifiableList(filterProviders);
        this.cachingEnabled = cachingEnabled;
        this.changesExecutor = changesExecutor;
        this.lastConfigsDiff = null;
        this.lastConfig = (AbstractConfigImpl)Config.empty();
        this.keyResolving = keyResolving;
        this.keyResolvingFailOnMissing = keyResolvingFailOnMissing;
        this.aliasGenerator = aliasGenerator;
    }

    public synchronized AbstractConfigImpl newConfig() {
        this.lastConfig = this.build(this.configSource.load());
        if (!this.listening) {
            this.configSource.changeListener(objectNode -> this.rebuild((Optional<ConfigNode.ObjectNode>)objectNode, false));
            this.configSource.startChanges();
            this.overrideSource.changeListener(() -> this.rebuild(this.configSource.latest(), false));
            this.overrideSource.startChanges();
            this.listening = true;
        }
        return this.lastConfig;
    }

    @Override
    public synchronized Config reload() {
        this.rebuild(this.configSource.latest(), true);
        return this.lastConfig;
    }

    @Override
    public synchronized Instant timestamp() {
        return this.lastConfig.timestamp();
    }

    @Override
    public synchronized Config last() {
        return this.lastConfig;
    }

    void onChange(Consumer<ConfigDiff> listener) {
        this.listeners.add(listener);
    }

    private synchronized AbstractConfigImpl build(Optional<ConfigNode.ObjectNode> rootNode) {
        rootNode = rootNode.map(this::resolveKeys);
        ChainConfigFilter targetFilter = new ChainConfigFilter();
        this.overrideSource.addFilter(targetFilter);
        ConfigFactory factory = new ConfigFactory(this.configMapperManager, rootNode.orElseGet(ConfigNode.ObjectNode::empty), targetFilter, this, this.aliasGenerator);
        AbstractConfigImpl config = factory.config();
        this.initializeFilters(config, targetFilter);
        if (this.cachingEnabled) {
            targetFilter.enableCaching();
        }
        return config;
    }

    private ConfigNode.ObjectNode resolveKeys(ConfigNode.ObjectNode rootNode) {
        Function<String, String> resolveTokenFunction = Function.identity();
        if (this.keyResolving) {
            Map<String, String> flattenValueNodes = ConfigHelper.flattenNodes(rootNode);
            if (flattenValueNodes.isEmpty()) {
                return rootNode;
            }
            Map<String, String> tokenValueMap = this.tokenToValueMap(flattenValueNodes);
            boolean failOnMissingKeyReference = this.getBoolean(flattenValueNodes, "config.key-resolving.fail-on-missing-reference", this.keyResolvingFailOnMissing);
            resolveTokenFunction = token -> {
                if (token.startsWith("$")) {
                    String tokenRef = ProviderImpl.parseTokenReference(token);
                    String resolvedValue = (String)tokenValueMap.get(tokenRef);
                    if (resolvedValue.isEmpty()) {
                        if (failOnMissingKeyReference) {
                            throw new ConfigException(String.format("Missing token '%s' to resolve a key reference.", tokenRef));
                        }
                        return token;
                    }
                    return resolvedValue;
                }
                return token;
            };
        }
        return ObjectNodeBuilderImpl.create((Map<String, ConfigNode>)rootNode, resolveTokenFunction).build();
    }

    private Map<String, String> tokenToValueMap(Map<String, String> flattenValueNodes) {
        return flattenValueNodes.keySet().stream().flatMap(this::tokensFromKey).distinct().collect(Collectors.toMap(Function.identity(), t -> {
            String value = (String)flattenValueNodes.get(Config.Key.unescapeName(t));
            if (value == null) {
                value = "";
            } else {
                if (value.startsWith("$")) {
                    throw new ConfigException(String.format("Key token '%s' references to a reference in value. A recursive references is not allowed.", t));
                }
                value = Config.Key.escapeName(value);
            }
            return value;
        }));
    }

    private Stream<String> tokensFromKey(String s) {
        String[] tokens = s.split("\\.+(?![^(${)]*})");
        return Arrays.stream(tokens).filter(t -> t.startsWith("$")).map(ProviderImpl::parseTokenReference);
    }

    private static String parseTokenReference(String token) {
        if (token.startsWith("${") && token.endsWith("}")) {
            return token.substring(2, token.length() - 1);
        }
        if (token.startsWith("$")) {
            return token.substring(1);
        }
        return token;
    }

    private synchronized void rebuild(Optional<ConfigNode.ObjectNode> objectNode, boolean force) {
        AbstractConfigImpl newConfig = this.build(objectNode);
        ConfigDiff configsDiff = ConfigDiff.from(this.lastConfig, newConfig);
        if (!configsDiff.isEmpty()) {
            this.lastConfig = newConfig;
            this.lastConfigsDiff = configsDiff;
            this.fireLastChangeEvent();
        } else {
            if (force) {
                this.lastConfig = newConfig;
            }
            LOGGER.log(Level.FINER, "Change event is not fired, there is no change from the last load.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLastChangeEvent() {
        ConfigDiff configDiffs;
        ProviderImpl providerImpl = this;
        synchronized (providerImpl) {
            configDiffs = this.lastConfigsDiff;
        }
        if (configDiffs != null) {
            LOGGER.log(Level.FINER, String.format("Firing last event %s (again)", configDiffs));
            this.changesExecutor.execute(() -> {
                for (Consumer<ConfigDiff> listener : this.listeners) {
                    listener.accept(configDiffs);
                }
            });
        }
    }

    private void initializeFilters(Config config, ChainConfigFilter chain) {
        chain.init(config);
        this.filterProviders.stream().map(providerFunction -> (ConfigFilter)providerFunction.apply(config)).forEachOrdered(chain::addFilter);
        chain.filterProviders.stream().map(providerFunction -> (ConfigFilter)providerFunction.apply(config)).forEachOrdered(filter -> filter.init(config));
    }

    private boolean getBoolean(Map<String, String> valueNodes, String key, boolean defaultValue) {
        String value = valueNodes.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    static class ChainConfigFilter
    implements ConfigFilter {
        private final List<Function<Config, ConfigFilter>> filterProviders = new ArrayList<Function<Config, ConfigFilter>>();
        private boolean cachingEnabled = false;
        private ConcurrentMap<Config.Key, String> valueCache;
        private Config config;

        ChainConfigFilter() {
        }

        public void init(Config config) {
            this.config = config;
        }

        void addFilter(ConfigFilter filter) {
            if (this.cachingEnabled) {
                throw new IllegalStateException("Cannot add new filter to the chain when cache is already enabled.");
            }
            this.filterProviders.add(config -> filter);
        }

        public String apply(Config.Key key, String stringValue) {
            if (this.cachingEnabled) {
                if (!this.valueCache.containsKey(key)) {
                    String value = this.proceedFilters(key, stringValue);
                    this.valueCache.put(key, value);
                    return value;
                }
                return (String)this.valueCache.get(key);
            }
            return this.proceedFilters(key, stringValue);
        }

        private String proceedFilters(Config.Key key, String stringValue) {
            for (Function<Config, ConfigFilter> configFilterProvider : this.filterProviders) {
                stringValue = configFilterProvider.apply(this.config).apply(key, stringValue);
            }
            return stringValue;
        }

        void enableCaching() {
            this.cachingEnabled = true;
            this.valueCache = new ConcurrentHashMap<Config.Key, String>();
        }
    }
}

