/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.logging.Level;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="rar")
@PerLookup
public class RarScanner
extends ModuleScanner<ConnectorDescriptor> {
    public void process(File archiveFile, ConnectorDescriptor desc, ClassLoader classLoader) throws IOException {
        if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
            AnnotationUtils.getLogger().fine("archiveFile is " + archiveFile);
            AnnotationUtils.getLogger().fine("classLoader is " + classLoader);
        }
        this.archiveFile = archiveFile;
        this.classLoader = classLoader;
        if (archiveFile.isDirectory()) {
            this.addScanDirectory(archiveFile);
            FileFilter filter = pathname -> pathname.isFile() && pathname.getAbsolutePath().endsWith(".jar");
            File[] jarFiles = archiveFile.listFiles(filter);
            if (jarFiles != null && jarFiles.length > 0) {
                for (File jarFile : jarFiles) {
                    this.addScanJar(jarFile);
                }
            }
        } else {
            AnnotationUtils.getLogger().fine("RARScanner : not a directory : " + archiveFile.getName());
        }
    }
}

