/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.datastructure;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.enterprise.resource.pool.datastructure.ListDataStructure;
import com.sun.enterprise.resource.pool.datastructure.RWLockDataStructure;
import com.sun.logging.LogDomains;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataStructureFactory {
    protected static final Logger _logger = LogDomains.getLogger(DataStructureFactory.class, (String)"jakarta.enterprise.resource.resourceadapter");

    public static DataStructure getDataStructure(String className, String parameters, int maxPoolSize, ResourceHandler handler) throws PoolingException {
        DataStructure dataStructure;
        if (className != null) {
            dataStructure = className.equals(ListDataStructure.class.getName()) ? new ListDataStructure(parameters, maxPoolSize, handler) : (className.equals(RWLockDataStructure.class.getName()) ? new RWLockDataStructure(parameters, maxPoolSize, handler) : DataStructureFactory.initializeCustomDataStructureInPrivilegedMode(className, parameters, maxPoolSize, handler));
        } else {
            DataStructureFactory.debug("Initializing RWLock DataStructure");
            dataStructure = new RWLockDataStructure(parameters, maxPoolSize, handler);
        }
        return dataStructure;
    }

    private static DataStructure initializeCustomDataStructureInPrivilegedMode(final String className, final String parameters, final int maxPoolSize, final ResourceHandler handler) throws PoolingException {
        Object result = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                DataStructure result = null;
                try {
                    result = DataStructureFactory.initializeDataStructure(className, parameters, maxPoolSize, handler);
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "pool.datastructure.init.failure", className);
                    _logger.log(Level.WARNING, "pool.datastructure.init.failure.exception", e);
                }
                return result;
            }
        });
        if (result != null) {
            return (DataStructure)result;
        }
        throw new PoolingException("Unable to initalize custom DataStructure : " + className);
    }

    private static DataStructure initializeDataStructure(String className, String parameters, int maxPoolSize, ResourceHandler handler) throws Exception {
        Object[] constructorParameters = new Object[]{parameters, maxPoolSize, handler};
        Class<?> class1 = Thread.currentThread().getContextClassLoader().loadClass(className);
        Constructor<?> constructor = class1.getConstructor(String.class, Integer.TYPE, ResourceHandler.class);
        DataStructure ds = (DataStructure)constructor.newInstance(constructorParameters);
        _logger.log(Level.FINEST, "Using Pool Data Structure : ", className);
        return ds;
    }

    private static void debug(String debugStatement) {
        _logger.log(Level.FINE, debugStatement);
    }
}

