/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.modules.locked;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Set;
import java.util.stream.Collectors;

public class Role {
    private static final System.Logger LOG = System.getLogger(Role.class.getName());
    private final String roleName;
    private Permissions permissions;
    private Set<Principal> principals;
    private boolean isAnyAuthenticatedUserRole;

    public Role(String name) {
        this.roleName = name;
    }

    public String getName() {
        return this.roleName;
    }

    void addPermission(Permission permission) {
        if (this.permissions == null) {
            this.permissions = new Permissions();
        }
        this.permissions.add(permission);
    }

    void addPermissions(PermissionCollection permissionCollection) {
        if (this.permissions == null) {
            this.permissions = new Permissions();
        }
        Enumeration<Permission> e = permissionCollection.elements();
        while (e.hasMoreElements()) {
            this.permissions.add(e.nextElement());
        }
    }

    Permissions getPermissions() {
        return this.permissions;
    }

    void setPrincipals(Set<Principal> principals) {
        if (principals != null) {
            this.principals = principals;
        }
    }

    boolean implies(Permission permission) {
        if (this.permissions == null) {
            return false;
        }
        return this.permissions.implies(permission);
    }

    void determineAnyAuthenticatedUserRole() {
        this.isAnyAuthenticatedUserRole = false;
        if (this.principals == null || this.principals.isEmpty()) {
            this.isAnyAuthenticatedUserRole = true;
        }
    }

    boolean isAnyAuthenticatedUserRole() {
        return this.isAnyAuthenticatedUserRole;
    }

    boolean isPrincipalInRole(Principal principal) {
        if (this.isAnyAuthenticatedUserRole && principal != null) {
            return true;
        }
        if (this.principals == null) {
            return false;
        }
        return this.principals.contains(principal);
    }

    boolean arePrincipalsInRole(Principal[] subject) {
        if (subject == null || subject.length == 0) {
            return false;
        }
        if (this.isAnyAuthenticatedUserRole) {
            return true;
        }
        if (this.principals == null || this.principals.isEmpty()) {
            return false;
        }
        LOG.log(System.Logger.Level.DEBUG, () -> "Known principals: " + this.principals.stream().map(Principal::toString).collect(Collectors.joining(", ")));
        for (Principal principal : subject) {
            LOG.log(System.Logger.Level.DEBUG, "Checking principal: {0}", principal);
            if (!this.principals.contains(principal)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        Role other = o == null || !(o instanceof Role) ? null : (Role)o;
        return other == null ? false : this.getName().equals(other.getName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.roleName != null ? this.roleName.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.roleName + "]";
    }
}

