/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client;

import com.sun.enterprise.deployment.node.SaxParserHandlerBundled;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.util.ValidationEventCollector;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.instrument.Instrumentation;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.glassfish.appclient.client.acc.ACCLogger;
import org.glassfish.appclient.client.acc.AgentArguments;
import org.glassfish.appclient.client.acc.AppClientContainer;
import org.glassfish.appclient.client.acc.AppclientCommandArguments;
import org.glassfish.appclient.client.acc.CommandLaunchInfo;
import org.glassfish.appclient.client.acc.TargetServerHelper;
import org.glassfish.appclient.client.acc.TransformingClassLoader;
import org.glassfish.appclient.client.acc.Util;
import org.glassfish.appclient.client.acc.config.AuthRealm;
import org.glassfish.appclient.client.acc.config.ClientContainer;
import org.glassfish.appclient.client.acc.config.ClientCredential;
import org.glassfish.appclient.client.acc.config.TargetServer;
import org.glassfish.embeddable.client.ApplicationClientClassLoader;
import org.glassfish.embeddable.client.ApplicationClientContainer;
import org.glassfish.embeddable.client.UserError;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class AppClientContainerHolder
implements ApplicationClientContainer {
    private static final String ACC_CONFIG_CONTENT_PROPERTY_NAME = "glassfish-acc.xml.content";
    private static final String MAN_PAGE_PATH = "/org/glassfish/appclient/client/acc/appclient.1m";
    private static volatile AppClientContainerHolder instance;
    private CommandLaunchInfo launchInfo;
    private AppclientCommandArguments appClientCommandArgs;
    private ApplicationClientContainer appClientContainer;

    public void launch(String[] args) throws UserError {
        this.appClientContainer.launch(args);
    }

    public ApplicationClientContainer getAppClientContainer() {
        return this.appClientContainer;
    }

    public static synchronized AppClientContainerHolder getInstance() {
        if (instance == null) {
            try {
                AppClientContainerHolder.init(null, null);
            }
            catch (UserError ue) {
                ue.displayAndExit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init(String agentArgsText, Instrumentation inst) throws UserError, Exception {
        int version = Runtime.version().feature();
        if (version < 17) {
            throw new UserError(MessageFormat.format("Current Java version {0} is too low; {1} or later required", version, "17"));
        }
        AgentArguments agentArgs = AgentArguments.newInstance(agentArgsText);
        AppClientContainerHolder holder = new AppClientContainerHolder();
        holder.appClientCommandArgs = AppclientCommandArguments.newInstance(agentArgs.namedValues("arg"));
        if (holder.appClientCommandArgs.isUsage()) {
            AppClientContainerHolder.usage(0);
        } else if (holder.appClientCommandArgs.isHelp()) {
            AppClientContainerHolder.help();
        }
        holder.launchInfo = CommandLaunchInfo.newInstance(agentArgs);
        if (holder.launchInfo.getClientLaunchType() == CommandLaunchInfo.ClientLaunchType.UNKNOWN) {
            AppClientContainerHolder.usage(1);
        }
        ClientContainer clientContainer = AppClientContainerHolder.readConfig(holder.appClientCommandArgs);
        TargetServer[] targetServers = TargetServerHelper.targetServers(clientContainer, holder.appClientCommandArgs.getTargetServer());
        ClassLoader dependenciesCL = Thread.currentThread().getContextClassLoader();
        try {
            TransformingClassLoader loader = AppClientContainerHolder.initClassLoader(dependenciesCL, inst == null);
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)loader));
            AppClientContainer.Builder builder = AppClientContainerHolder.createBuilder(targetServers, clientContainer, holder.appClientCommandArgs);
            AppClientContainer newACC = AppClientContainerHolder.createContainer(builder, holder.launchInfo, holder.appClientCommandArgs);
            newACC.prepare(inst);
            holder.appClientContainer = newACC;
            ((ApplicationClientClassLoader)dependenciesCL).setApplicationClientContainer(holder.appClientContainer);
            instance = holder;
        }
        finally {
            Thread.currentThread().setContextClassLoader(dependenciesCL);
        }
    }

    private static void usage(int exitStatus) {
        System.out.println(AppClientContainerHolder.getUsage());
        System.exit(exitStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void help() throws IOException {
        InputStream is = AppClientContainerHolder.class.getResourceAsStream(MAN_PAGE_PATH);
        if (is == null) {
            AppClientContainerHolder.usage(0);
        }
        try (BufferedReader helpReader = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = helpReader.readLine()) != null) {
                System.out.println(line);
            }
        }
        finally {
            System.exit(0);
        }
    }

    private static String getUsage() {
        return "appclient [ <classfile> | -client <appjar> ] [-mainclass <appClass-name>|-name <display-name>] [-xml <xml>] [-textauth] [-user <username>] [-password <password>|-passwordfile <password-file>] [-targetserver host[:port][,host[:port]...] [app-args]" + System.lineSeparator() + "  or  :\n\tappclient [ <valid JVM options and valid ACC options> ] [ <appClass-name> | -jar <appjar> ] [app args]";
    }

    private static TransformingClassLoader initClassLoader(ClassLoader parent, boolean loaderShouldTransform) {
        TransformingClassLoader loader = TransformingClassLoader.instance();
        if (loader == null) {
            return TransformingClassLoader.newInstance(parent, loaderShouldTransform);
        }
        return loader;
    }

    private static AppClientContainer.Builder createBuilder(TargetServer[] targetServers, ClientContainer clientContainer, AppclientCommandArguments appClientCommandArgs) throws IOException {
        List property;
        AppClientContainer.Builder builder = AppClientContainer.newBuilder(targetServers);
        AppClientContainerHolder.updateClientCredentials(builder, appClientCommandArgs);
        List msc = clientContainer.getMessageSecurityConfig();
        if (msc != null) {
            builder.getMessageSecurityConfig().addAll(clientContainer.getMessageSecurityConfig());
        }
        builder.logger((Logger)((Object)new ACCLogger(clientContainer.getLogService())));
        AuthRealm authRealm = clientContainer.getAuthRealm();
        if (authRealm != null) {
            builder.authRealm(authRealm.getClassname());
        }
        if ((property = clientContainer.getProperty()) != null) {
            builder.containerProperties(property);
        }
        return builder;
    }

    private static void updateClientCredentials(AppClientContainer.Builder builder, AppclientCommandArguments appClientCommandArgs) {
        char[] commandLinePW;
        ClientCredential clientCredential = builder.getClientCredential();
        String user = clientCredential == null ? null : clientCredential.getUserName();
        char[] pw = clientCredential != null && clientCredential.getPassword() != null ? clientCredential.getPassword().get() : null;
        String commandLineUser = appClientCommandArgs.getUser();
        if (commandLineUser != null) {
            user = commandLineUser;
        }
        if ((commandLinePW = appClientCommandArgs.getPassword()) != null) {
            pw = commandLinePW;
        }
        builder.clientCredentials(user, pw);
    }

    private static AppClientContainer createContainer(AppClientContainer.Builder builder, CommandLaunchInfo launchInfo, AppclientCommandArguments appClientArgs) throws Exception, UserError {
        CommandLaunchInfo.ClientLaunchType launchType = launchInfo.getClientLaunchType();
        AppClientContainer container = switch (launchType) {
            case CommandLaunchInfo.ClientLaunchType.JAR, CommandLaunchInfo.ClientLaunchType.DIR -> AppClientContainerHolder.createContainerForAppClientArchiveOrDir(builder, launchInfo.getClientName(), appClientArgs);
            case CommandLaunchInfo.ClientLaunchType.URL -> AppClientContainerHolder.createContainerForJWSLaunch(builder, launchInfo.getClientName(), appClientArgs);
            case CommandLaunchInfo.ClientLaunchType.CLASS -> AppClientContainerHolder.createContainerForClassName(builder, launchInfo.getClientName());
            case CommandLaunchInfo.ClientLaunchType.CLASSFILE -> AppClientContainerHolder.createContainerForClassFile(builder, launchInfo.getClientName());
            default -> null;
        };
        if (container == null) {
            throw new IllegalArgumentException("cannot choose app client launch type");
        }
        return container;
    }

    private static AppClientContainer createContainerForAppClientArchiveOrDir(AppClientContainer.Builder builder, String appClientPath, AppclientCommandArguments appClientArgs) throws Exception, UserError {
        return builder.newContainer(Util.getURI(new File(appClientPath)), null, appClientArgs.getMainclass(), appClientArgs.getName(), appClientArgs.isTextauth());
    }

    private static AppClientContainer createContainerForJWSLaunch(AppClientContainer.Builder builder, String appClientPath, AppclientCommandArguments appClientArgs) throws Exception, UserError {
        return builder.newContainer(URI.create(appClientPath), null, appClientArgs.getMainclass(), appClientArgs.getName());
    }

    private static AppClientContainer createContainerForClassName(AppClientContainer.Builder builder, String className) throws Exception, UserError {
        return builder.newContainer(Class.forName(className, true, Thread.currentThread().getContextClassLoader()));
    }

    private static AppClientContainer createContainerForClassFile(AppClientContainer.Builder builder, String classFilePath) throws MalformedURLException, ClassNotFoundException, FileNotFoundException, IOException, Exception, UserError {
        Util.verifyFilePath(classFilePath);
        String className = classFilePath.substring(0, classFilePath.lastIndexOf(".class")).replace(File.separatorChar, '.');
        return AppClientContainerHolder.createContainerForClassName(builder, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClientContainer readConfig(AppclientCommandArguments appClientCommandArgs) throws UserError, Exception {
        String configPath = appClientCommandArgs.getConfigFilePath();
        ClientContainer result = null;
        try (Reader configReader = null;){
            String configFileLocationForErrorMessage;
            String configInProperty = System.getProperty(ACC_CONFIG_CONTENT_PROPERTY_NAME);
            if (configInProperty == null) {
                File configFile = AppClientContainerHolder.checkXMLFile(configPath);
                AppClientContainerHolder.checkXMLFile(appClientCommandArgs.getConfigFilePath());
                configReader = new FileReader(configFile);
                configFileLocationForErrorMessage = configFile.getAbsolutePath();
            } else {
                File securityConfigTempFile = Util.writeTextToTempFile(configInProperty, "wss-client-config", ".xml", false);
                Properties p = new Properties();
                p.setProperty("security.config.path", securityConfigTempFile.getAbsolutePath());
                configReader = new StringReader(Util.replaceTokens(configInProperty, p));
                configFileLocationForErrorMessage = null;
            }
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(true);
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setEntityResolver((EntityResolver)new SaxParserHandlerBundled());
            InputSource inputSource = AppClientContainerHolder.replaceTokensForParsing(configReader);
            SAXSource saxSource = new SAXSource(reader, inputSource);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ClientContainer.class});
            Unmarshaller u = jc.createUnmarshaller();
            ValidationEventCollector vec = new ValidationEventCollector();
            u.setEventHandler((ValidationEventHandler)vec);
            result = (ClientContainer)u.unmarshal((Source)saxSource);
            if (vec.hasEvents()) {
                AppClientContainerHolder.printValidationEvents(configFileLocationForErrorMessage, vec.getEvents());
            }
            ClientContainer clientContainer = result;
            return clientContainer;
        }
    }

    private static void printValidationEvents(String file, ValidationEvent[] events) {
        boolean isError = false;
        StringBuilder sb = new StringBuilder();
        for (ValidationEvent ve : events) {
            sb.append(ve.getMessage()).append(System.lineSeparator());
            isError |= ve.getSeverity() != 0;
        }
        String messageIntroduction = MessageFormat.format(isError ? "Error parsing app client container configuration{0}. Attempting to continue. In future releases such parsing errors might become fatal. Please correct your configuration file." : "Warning(s) parsing app client container configuration{0}. Continuing.", file == null ? "" : " file " + file);
        System.err.println(messageIntroduction + System.lineSeparator() + String.valueOf(sb));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputSource replaceTokensForParsing(Reader reader) throws FileNotFoundException, IOException {
        try (CharArrayWriter writer = new CharArrayWriter();){
            int charsRead;
            char[] buffer = new char[4096];
            while ((charsRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, charsRead);
            }
        }
        reader.close();
        HashMap<String, String> mapping = new HashMap<String, String>();
        Properties props = System.getProperties();
        for (String propName : props.stringPropertyNames()) {
            mapping.put(propName, props.getProperty(propName));
        }
        TokenResolver resolver = new TokenResolver(mapping);
        String configWithTokensReplaced = resolver.resolve(writer.toString());
        return new InputSource(new StringReader(configWithTokensReplaced));
    }

    private static File checkXMLFile(String xmlFullName) throws UserError {
        try {
            File f = new File(xmlFullName);
            if (f.exists() && f.isFile() && f.canRead()) {
                return f;
            }
            AppClientContainerHolder.xmlMessage(xmlFullName);
            return null;
        }
        catch (Exception ex) {
            AppClientContainerHolder.xmlMessage(xmlFullName);
            return null;
        }
    }

    private static void xmlMessage(String xmlFullName) throws UserError {
        UserError ue = new UserError(MessageFormat.format("Client Container xml: {0} not found or unable to read.\nYou may want to use the -xml option to locate your configuration xml.", xmlFullName));
        ue.setUsage(AppClientContainerHolder.getUsage());
        throw ue;
    }
}

