/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import java.util.Vector;
import org.glassfish.rmic.iiop.BatchEnvironment;
import org.glassfish.rmic.iiop.CompoundType;
import org.glassfish.rmic.iiop.ContextStack;
import org.glassfish.rmic.iiop.RemoteType;
import org.glassfish.rmic.iiop.Type;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.CompilerError;

public class AbstractType
extends RemoteType {
    public static AbstractType forAbstract(ClassDefinition classDef, ContextStack stack, boolean quiet) {
        AbstractType result;
        block7: {
            boolean doPop = false;
            result = null;
            try {
                org.glassfish.rmic.tools.java.Type theType = classDef.getType();
                Type existing = AbstractType.getType(theType, stack);
                if (existing != null) {
                    if (!(existing instanceof AbstractType)) {
                        return null;
                    }
                    return (AbstractType)existing;
                }
                if (AbstractType.couldBeAbstract(stack, classDef, quiet)) {
                    AbstractType it = new AbstractType(stack, classDef);
                    AbstractType.putType(theType, (Type)it, stack);
                    stack.push(it);
                    doPop = true;
                    if (it.initialize(quiet, stack)) {
                        stack.pop(true);
                        result = it;
                    } else {
                        AbstractType.removeType(theType, stack);
                        stack.pop(false);
                    }
                }
            }
            catch (CompilerError e) {
                if (!doPop) break block7;
                stack.pop(false);
            }
        }
        return result;
    }

    @Override
    public String getTypeDescription() {
        return "Abstract interface";
    }

    private AbstractType(ContextStack stack, ClassDefinition classDef) {
        super(stack, classDef, 0xA002000);
    }

    private static boolean couldBeAbstract(ContextStack stack, ClassDefinition classDef, boolean quiet) {
        boolean result = false;
        if (classDef.isInterface()) {
            BatchEnvironment env = stack.getEnv();
            try {
                boolean bl = result = !env.defRemote.implementedBy(env, classDef.getClassDeclaration());
                if (!result) {
                    AbstractType.failedConstraint(15, quiet, stack, classDef.getName());
                }
            }
            catch (ClassNotFound e) {
                AbstractType.classNotFound(stack, e);
            }
        } else {
            AbstractType.failedConstraint(14, quiet, stack, classDef.getName());
        }
        return result;
    }

    private boolean initialize(boolean quiet, ContextStack stack) {
        boolean result = false;
        ClassDefinition self = this.getClassDefinition();
        try {
            Vector<CompoundType.Method> directMethods = new Vector<CompoundType.Method>();
            if (this.addAllMethods(self, directMethods, true, quiet, stack) != null) {
                boolean validMethods = true;
                if (directMethods.size() > 0) {
                    for (int i = 0; i < directMethods.size(); ++i) {
                        if (this.isConformingRemoteMethod(directMethods.elementAt(i), true)) continue;
                        validMethods = false;
                    }
                }
                if (validMethods) {
                    result = this.initialize(null, directMethods, null, stack, quiet);
                }
            }
        }
        catch (ClassNotFound e) {
            AbstractType.classNotFound(stack, e);
        }
        return result;
    }
}

