/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Base64;
import org.glassfish.security.common.UserNameAndPassword;

public final class HttpParser {
    private static final System.Logger LOG = System.getLogger(HttpParser.class.getName());

    private HttpParser() {
    }

    public static String readResponseErrorStream(HttpURLConnection connection) throws IOException {
        Charset charset = HttpParser.getCharsetFromHeader(connection.getContentType());
        try (InputStream in = connection.getErrorStream();){
            String string = new String(in.readAllBytes(), charset);
            return string;
        }
    }

    public static String readResponseInputStream(URLConnection connection) throws IOException {
        Charset charset = HttpParser.getCharsetFromHeader(connection.getContentType());
        try (InputStream in = connection.getInputStream();){
            String string = new String(in.readAllBytes(), charset);
            return string;
        }
    }

    public static UserNameAndPassword parseBasicAuthorizationHeader(String authorization) throws CharacterCodingException {
        LOG.log(System.Logger.Level.DEBUG, "Parsing expected Basic authorization header: {0}", authorization);
        if (authorization == null || !authorization.startsWith("Basic ")) {
            return null;
        }
        int charsetIndex = authorization.indexOf("; charset=");
        Charset authCharset = HttpParser.getCharsetFromHeader(authorization);
        String base64 = charsetIndex > 0 ? authorization.substring(6, charsetIndex) : authorization.substring(6);
        byte[] bs = Base64.getDecoder().decode(base64.trim());
        String decodedString = new String(bs, authCharset);
        int ind = decodedString.indexOf(58);
        if (ind > 0) {
            String username = decodedString.substring(0, ind);
            String password = decodedString.substring(ind + 1);
            if (username != null && password != null) {
                return new UserNameAndPassword(username, password);
            }
        }
        return null;
    }

    public static Charset getCharsetFromHeader(String header) throws CharacterCodingException {
        if (header == null) {
            return HttpParser.getCharset(null);
        }
        int start = header.indexOf("charset=");
        if (start < 0) {
            return HttpParser.getCharset(null);
        }
        String charset = header.substring(start + 8);
        int end = charset.indexOf(59);
        if (end >= 0) {
            charset = charset.substring(0, end);
        }
        if ((charset = charset.trim()).length() > 2 && charset.startsWith("\"") && charset.endsWith("\"")) {
            charset = charset.substring(1, charset.length() - 1);
        }
        return HttpParser.getCharset(charset.trim());
    }

    public static Charset getCharset(String charset) throws CharacterCodingException {
        if (charset == null || charset.isEmpty()) {
            return StandardCharsets.UTF_8;
        }
        try {
            return Charset.forName(charset);
        }
        catch (UnsupportedCharsetException uce) {
            CharacterCodingException e = new CharacterCodingException();
            e.initCause(uce);
            throw e;
        }
    }
}

