/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.cli;

import com.sun.enterprise.admin.monitor.jndi.JndiNameLookupHelper;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-jndi-entries")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.jndi.entries")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="list-jndi-entries", description="list-jndi-entries")})
public class ListJndiEntries
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListJndiEntries.class);
    @Param(name="context", optional=true)
    String contextName;
    @Param(primary=true, optional=true, defaultValue="server")
    String target;

    @Override
    public void execute(AdminCommandContext context) {
        List<String> names = null;
        ActionReport report = context.getActionReport();
        try {
            names = this.getNames(this.contextName);
        }
        catch (NamingException e) {
            report.setMessage(localStrings.getLocalString("list.jndi.entries.namingexception", "Naming Exception caught.") + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        try {
            if (names.isEmpty()) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(localStrings.getLocalString("list.jndi.entries.empty", "Nothing to list."));
            } else {
                for (String jndiName : names) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(jndiName);
                }
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.jndi.entries.fail", "Unable to list jndi entries.") + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }

    private List<String> getNames(String context) throws NamingException {
        ArrayList<String> names = null;
        JndiNameLookupHelper helper = new JndiNameLookupHelper();
        names = helper.getJndiEntriesByContextPath(context);
        return names;
    }
}

