/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.AbstractValidator;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.BaseDeclarationIdentificationVariableFinder;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryDeclaration;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.SemanticValidatorHelper;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.CompoundExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.OnClause;
import org.eclipse.persistence.jpa.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;

public abstract class AbstractSemanticValidator
extends AbstractValidator {
    protected CollectionValuedPathExpressionVisitor collectionValuedPathExpressionVisitor;
    private ComparingEntityTypeLiteralVisitor comparingEntityTypeLiteralVisitor;
    private ComparisonExpressionVisitor comparisonExpressionVisitor;
    protected final SemanticValidatorHelper helper;
    private InItemsVisitor inItemsVisitor;
    protected boolean registerIdentificationVariable;
    protected StateFieldPathExpressionVisitor stateFieldPathExpressionVisitor;
    private SubqueryFirstDeclarationVisitor subqueryFirstDeclarationVisitor;
    private TopLevelFirstDeclarationVisitor topLevelFirstDeclarationVisitor;
    protected List<IdentificationVariable> usedIdentificationVariables;
    protected BaseDeclarationIdentificationVariableFinder virtualIdentificationVariableFinder;

    protected AbstractSemanticValidator(SemanticValidatorHelper helper) {
        Assert.isNotNull(helper, "The helper cannot be null");
        this.helper = helper;
    }

    protected ComparingEntityTypeLiteralVisitor buildComparingEntityTypeLiteralVisitor() {
        return new ComparingEntityTypeLiteralVisitor();
    }

    protected InItemsVisitor buildInItemsVisitor() {
        return new InItemsVisitor(this);
    }

    protected SubqueryFirstDeclarationVisitor buildSubqueryFirstDeclarationVisitor() {
        return new SubqueryFirstDeclarationVisitor();
    }

    protected TopLevelFirstDeclarationVisitor buildTopLevelFirstDeclarationVisitor() {
        return new TopLevelFirstDeclarationVisitor();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.usedIdentificationVariables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IdentificationVariable findVirtualIdentificationVariable(AbstractSchemaName expression) {
        BaseDeclarationIdentificationVariableFinder visitor = this.getVirtualIdentificationVariableFinder();
        try {
            expression.accept(visitor);
            IdentificationVariable identificationVariable = visitor.expression;
            return identificationVariable;
        }
        finally {
            visitor.expression = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CollectionValuedPathExpression getCollectionValuedPathExpression(Expression expression) {
        CollectionValuedPathExpressionVisitor visitor = this.getCollectionValuedPathExpressionVisitor();
        try {
            expression.accept(visitor);
            CollectionValuedPathExpression collectionValuedPathExpression = visitor.expression;
            return collectionValuedPathExpression;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected CollectionValuedPathExpressionVisitor getCollectionValuedPathExpressionVisitor() {
        if (this.collectionValuedPathExpressionVisitor == null) {
            this.collectionValuedPathExpressionVisitor = new CollectionValuedPathExpressionVisitor();
        }
        return this.collectionValuedPathExpressionVisitor;
    }

    protected ComparingEntityTypeLiteralVisitor getComparingEntityTypeLiteralVisitor() {
        if (this.comparingEntityTypeLiteralVisitor == null) {
            this.comparingEntityTypeLiteralVisitor = this.buildComparingEntityTypeLiteralVisitor();
        }
        return this.comparingEntityTypeLiteralVisitor;
    }

    protected ComparisonExpressionVisitor getComparisonExpressionVisitor() {
        if (this.comparisonExpressionVisitor == null) {
            this.comparisonExpressionVisitor = new ComparisonExpressionVisitor(this);
        }
        return this.comparisonExpressionVisitor;
    }

    @Override
    protected JPQLGrammar getGrammar() {
        return this.helper.getGrammar();
    }

    protected InItemsVisitor getInItemsVisitor() {
        if (this.inItemsVisitor == null) {
            this.inItemsVisitor = this.buildInItemsVisitor();
        }
        return this.inItemsVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateFieldPathExpression getStateFieldPathExpression(Expression expression) {
        StateFieldPathExpressionVisitor visitor = this.getStateFieldPathExpressionVisitor();
        try {
            expression.accept(visitor);
            StateFieldPathExpression stateFieldPathExpression = visitor.expression;
            return stateFieldPathExpression;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected StateFieldPathExpressionVisitor getStateFieldPathExpressionVisitor() {
        if (this.stateFieldPathExpressionVisitor == null) {
            this.stateFieldPathExpressionVisitor = new StateFieldPathExpressionVisitor();
        }
        return this.stateFieldPathExpressionVisitor;
    }

    protected BaseDeclarationIdentificationVariableFinder getVirtualIdentificationVariableFinder() {
        if (this.virtualIdentificationVariableFinder == null) {
            this.virtualIdentificationVariableFinder = new BaseDeclarationIdentificationVariableFinder();
        }
        return this.virtualIdentificationVariableFinder;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.usedIdentificationVariables = new ArrayList<IdentificationVariable>();
        this.registerIdentificationVariable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isComparingEntityTypeLiteral(IdentificationVariable expression) {
        ComparingEntityTypeLiteralVisitor visitor = this.getComparingEntityTypeLiteralVisitor();
        try {
            visitor.expression = expression;
            expression.accept(visitor);
            boolean bl = visitor.result;
            return bl;
        }
        finally {
            visitor.result = false;
            visitor.expression = null;
        }
    }

    protected boolean isIdentificationVariableDeclaredAfter(String variableName, int variableNameIndex, int joinIndex, List<JPQLQueryDeclaration> declarations) {
        int declarationCount = declarations.size();
        for (int index = variableNameIndex; index < declarationCount; ++index) {
            JPQLQueryDeclaration declaration = declarations.get(index);
            if (index != variableNameIndex) {
                if (declaration.getType() != JPQLQueryDeclaration.Type.UNKNOWN) {
                    String nextVariableName = declaration.getVariableName();
                    if (variableName.equalsIgnoreCase(nextVariableName)) {
                        return true;
                    }
                } else {
                    return false;
                }
            }
            if (!declaration.hasJoins()) continue;
            List<Join> joins = declaration.getJoins();
            int endIndex = index == variableNameIndex ? joinIndex : joins.size();
            for (int subIndex = joinIndex; subIndex < endIndex; ++subIndex) {
                Join join = joins.get(subIndex);
                String joinVariableName = this.literal(join.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
                if (!variableName.equalsIgnoreCase(joinVariableName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isIdentificationVariableValidInComparison(IdentificationVariable expression) {
        return this.helper.isIdentificationVariableValidInComparison(expression);
    }

    protected boolean isOrderComparison(ComparisonExpression expression) {
        String operator = expression.getComparisonOperator();
        return operator == ">" || operator == ">=" || operator == "<" || operator == "<=";
    }

    protected final boolean isValid(int result, int index) {
        return (result & 1 << index) == 0;
    }

    protected abstract PathType selectClausePathExpressionPathType();

    protected FirstDeclarationVisitor subqueryFirstDeclarationVisitor() {
        if (this.subqueryFirstDeclarationVisitor == null) {
            this.subqueryFirstDeclarationVisitor = this.buildSubqueryFirstDeclarationVisitor();
        }
        return this.subqueryFirstDeclarationVisitor;
    }

    protected FirstDeclarationVisitor topLevelFirstDeclarationVisitor() {
        if (this.topLevelFirstDeclarationVisitor == null) {
            this.topLevelFirstDeclarationVisitor = this.buildTopLevelFirstDeclarationVisitor();
        }
        return this.topLevelFirstDeclarationVisitor;
    }

    protected final int updateStatus(int result, int index, boolean valid) {
        return valid ? result & 0 << index : result | 1 << index;
    }

    protected boolean validateAbsExpression(AbsExpression expression) {
        return this.validateFunctionPathExpression(expression);
    }

    protected void validateAbstractFromClause(AbstractFromClause expression, FirstDeclarationVisitor visitor) {
        List<JPQLQueryDeclaration> declarations = this.helper.getDeclarations();
        int count = declarations.size();
        for (int index = 0; index < count; ++index) {
            String variableName;
            JPQLQueryDeclaration declaration = declarations.get(index);
            if (index == 0) {
                this.validateFirstDeclaration(expression, declaration, visitor);
            } else {
                Expression declarationExpression = declaration.getDeclarationExpression();
                if (declarationExpression != null) {
                    declarationExpression.accept(this);
                }
            }
            if (declaration.hasJoins()) {
                this.validateJoinsIdentificationVariable(expression, declarations, declaration, index);
                continue;
            }
            JPQLQueryDeclaration.Type type = declaration.getType();
            if (type != JPQLQueryDeclaration.Type.DERIVED && type != JPQLQueryDeclaration.Type.COLLECTION || !ExpressionTools.stringIsNotEmpty(variableName = this.literal(declaration.getBaseExpression(), LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE)) || !this.isIdentificationVariableDeclaredAfter(variableName, index, -1, declarations)) continue;
            int startPosition = this.position(declaration.getDeclarationExpression()) - variableName.length();
            int endPosition = startPosition + variableName.length();
            this.addProblem((Expression)expression, startPosition, endPosition, "ABSTRACT_FROM_CLAUSE_WRONG_ORDER_OF_IDENTIFICATION_VARIABLE_DECLARATION", variableName);
        }
    }

    protected boolean validateAbstractSchemaName(AbstractSchemaName expression) {
        String abstractSchemaName = expression.getText();
        Object managedType = this.helper.getEntityNamed(abstractSchemaName);
        boolean valid = true;
        if (managedType == null) {
            if (this.isWithinSubquery(expression)) {
                String variableName;
                IdentificationVariable identificationVariable = this.findVirtualIdentificationVariable(expression);
                String string = variableName = identificationVariable != null ? identificationVariable.getText() : null;
                if (ExpressionTools.stringIsNotEmpty(variableName)) {
                    Object mapping = this.helper.resolveMapping(variableName, abstractSchemaName);
                    Object type = this.helper.getMappingType(mapping);
                    if (!this.helper.isTypeResolvable(type)) {
                        this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_NOT_RESOLVABLE", abstractSchemaName);
                        valid = false;
                    } else if (!this.helper.isRelationshipMapping(mapping)) {
                        this.addProblem((Expression)expression, "PATH_EXPRESSION_NOT_RELATIONSHIP_MAPPING", abstractSchemaName);
                        valid = false;
                    }
                } else {
                    this.addProblem((Expression)expression, "ABSTRACT_SCHEMA_NAME_INVALID", abstractSchemaName);
                    valid = false;
                }
            } else {
                this.addProblem((Expression)expression, "ABSTRACT_SCHEMA_NAME_INVALID", abstractSchemaName);
                valid = false;
            }
        }
        return valid;
    }

    protected int validateAdditionExpression(AdditionExpression expression) {
        return this.validateArithmeticExpression(expression, "ADDITION_EXPRESSION_LEFT_EXPRESSION_WRONG_TYPE", "ADDITION_EXPRESSION_RIGHT_EXPRESSION_WRONG_TYPE");
    }

    protected void validateAllOrAnyExpression(AllOrAnyExpression expression) {
        super.visit(expression);
    }

    protected void validateAndExpression(AndExpression expression) {
        super.visit(expression);
    }

    protected int validateArithmeticExpression(ArithmeticExpression expression, String leftExpressionWrongTypeMessageKey, String rightExpressionWrongTypeMessageKey) {
        return this.validateFunctionPathExpression(expression, PathType.BASIC_FIELD_ONLY);
    }

    protected boolean validateArithmeticExpression(ArithmeticFactor expression) {
        boolean valid = true;
        if (expression.hasExpression()) {
            Expression factor = expression.getExpression();
            StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(factor);
            if (pathExpression != null) {
                valid = this.validateStateFieldPathExpression(pathExpression, PathType.BASIC_FIELD_ONLY);
            } else {
                factor.accept(this);
            }
        }
        return valid;
    }

    protected boolean validateAvgFunction(AvgFunction expression) {
        return this.validateFunctionPathExpression(expression);
    }

    protected int validateBetweenExpression(BetweenExpression expression) {
        int result = 0;
        if (expression.hasExpression()) {
            Expression firstExpression = expression.getExpression();
            StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(firstExpression);
            if (pathExpression != null) {
                boolean valid = this.validateStateFieldPathExpression(pathExpression, PathType.BASIC_FIELD_ONLY);
                this.updateStatus(result, 0, valid);
            } else {
                firstExpression.accept(this);
            }
        }
        expression.getLowerBoundExpression().accept(this);
        expression.getUpperBoundExpression().accept(this);
        return result;
    }

    protected void validateCaseExpression(CaseExpression expression) {
        super.visit(expression);
    }

    protected void validateCoalesceExpression(CoalesceExpression expression) {
        super.visit(expression);
    }

    protected void validateCollectionMemberDeclaration(CollectionMemberDeclaration expression) {
        this.validateCollectionValuedPathExpression(expression.getCollectionValuedPathExpression(), true);
        try {
            this.registerIdentificationVariable = false;
            expression.getIdentificationVariable().accept(this);
        }
        finally {
            this.registerIdentificationVariable = true;
        }
    }

    protected int validateCollectionMemberExpression(CollectionMemberExpression expression) {
        int result = 0;
        if (expression.hasEntityExpression()) {
            Expression entityExpression = expression.getEntityExpression();
            StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(entityExpression);
            if (pathExpression != null) {
                boolean valid = this.validateStateFieldPathExpression(pathExpression, PathType.ASSOCIATION_FIELD_ONLY);
                this.updateStatus(result, 0, valid);
            } else {
                entityExpression.accept(this);
            }
        }
        boolean valid = this.validateCollectionValuedPathExpression(expression.getCollectionValuedPathExpression(), true);
        this.updateStatus(result, 1, valid);
        return result;
    }

    protected boolean validateCollectionValuedPathExpression(Expression expression, boolean collectionTypeOnly) {
        boolean valid = true;
        CollectionValuedPathExpression collectionValuedPathExpression = this.getCollectionValuedPathExpression(expression);
        if (collectionValuedPathExpression != null && collectionValuedPathExpression.hasIdentificationVariable() && !collectionValuedPathExpression.endsWithDot()) {
            Object mapping = this.helper.resolveMapping(expression);
            Object type = this.helper.getMappingType(mapping);
            if (!this.helper.isTypeResolvable(type) || mapping == null) {
                int startPosition = this.position(expression);
                int endPosition = startPosition + this.length(expression);
                this.addProblem(expression, startPosition, endPosition, "COLLECTION_VALUED_PATH_EXPRESSION_NOT_RESOLVABLE", expression.toParsedText());
                valid = false;
            } else if (collectionTypeOnly && !this.helper.isCollectionMapping(mapping) || !collectionTypeOnly && !this.helper.isRelationshipMapping(mapping)) {
                int startPosition = this.position(expression);
                int endPosition = startPosition + this.length(expression);
                this.addProblem(expression, startPosition, endPosition, "COLLECTION_VALUED_PATH_EXPRESSION_NOT_COLLECTION_TYPE", expression.toParsedText());
                valid = false;
            }
        }
        return valid;
    }

    protected boolean validateJoinCollectionValuedPathExpression(Expression expression, boolean collectionTypeOnly) {
        boolean valid = true;
        CollectionValuedPathExpression collectionValuedPathExpression = this.getCollectionValuedPathExpression(expression);
        if (collectionValuedPathExpression != null && collectionValuedPathExpression.hasIdentificationVariable() && !collectionValuedPathExpression.endsWithDot()) {
            Object mapping = this.helper.resolveMapping(expression);
            Object type = this.helper.getMappingType(mapping);
            if (!this.helper.isTypeResolvable(type) || mapping == null) {
                int startPosition = this.position(expression);
                int endPosition = startPosition + this.length(expression);
                this.addProblem(expression, startPosition, endPosition, "COLLECTION_VALUED_PATH_EXPRESSION_NOT_RESOLVABLE", expression.toParsedText());
                valid = false;
            } else if (!(this.helper.isCollectionMapping(mapping) || this.helper.isRelationshipMapping(mapping) || this.helper.isEmbeddableMapping(mapping))) {
                int startPosition = this.position(expression);
                int endPosition = startPosition + this.length(expression);
                this.addProblem(expression, startPosition, endPosition, "COLLECTION_VALUED_PATH_EXPRESSION_NOT_COLLECTION_TYPE", expression.toParsedText());
                valid = false;
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateComparisonExpression(ComparisonExpression expression) {
        Expression leftExpression = expression.getLeftExpression();
        Expression rightExpression = expression.getRightExpression();
        boolean valid = true;
        ComparisonExpressionVisitor validator = this.getComparisonExpressionVisitor();
        try {
            Object mapping;
            validator.validatingLeftExpression = true;
            leftExpression.accept(validator);
            validator.validatingLeftExpression = false;
            rightExpression.accept(validator);
            if (this.isOrderComparison(expression)) {
                IdentificationVariable variable;
                if (validator.leftIdentificationVariable && validator.leftIdentificationVariableValid) {
                    variable = (IdentificationVariable)leftExpression;
                    if (!this.isIdentificationVariableValidInComparison(variable)) {
                        this.addProblem(leftExpression, "COMPARISON_EXPRESSION_IDENTIFICATION_VARIABLE", leftExpression.toActualText(), expression.getComparisonOperator());
                        valid = false;
                    }
                } else if (validator.leftStateFieldPathExpression && validator.leftStateFieldPathExpressionValid && (mapping = this.helper.resolveMapping(leftExpression)) != null && !this.helper.isPropertyMapping(mapping)) {
                    this.addProblem(leftExpression, "COMPARISON_EXPRESSION_ASSOCIATION_FIELD", leftExpression.toActualText(), expression.getComparisonOperator());
                    valid = false;
                }
                if (validator.rightIdentificationVariable && validator.rightIdentificationVariableValid) {
                    variable = (IdentificationVariable)rightExpression;
                    if (!this.isIdentificationVariableValidInComparison(variable)) {
                        this.addProblem(rightExpression, "COMPARISON_EXPRESSION_IDENTIFICATION_VARIABLE", rightExpression.toActualText(), expression.getComparisonOperator());
                        valid = false;
                    }
                } else if (validator.rightStateFieldPathExpression && validator.rightStateFieldPathExpressionValid && (mapping = this.helper.resolveMapping(rightExpression)) != null && !this.helper.isPropertyMapping(mapping)) {
                    this.addProblem(rightExpression, "COMPARISON_EXPRESSION_ASSOCIATION_FIELD", rightExpression.toActualText(), expression.getComparisonOperator());
                    valid = false;
                }
            } else if (validator.leftIdentificationVariable && validator.leftIdentificationVariableValid && validator.rightStateFieldPathExpression && validator.rightStateFieldPathExpressionValid) {
                mapping = this.helper.resolveMapping(rightExpression);
                IdentificationVariable variable = (IdentificationVariable)leftExpression;
                if (mapping != null && this.helper.isPropertyMapping(mapping) && !this.isIdentificationVariableValidInComparison(variable)) {
                    this.addProblem(rightExpression, "COMPARISON_EXPRESSION_BASIC_FIELD", rightExpression.toActualText(), expression.getComparisonOperator());
                    valid = false;
                }
            } else if (validator.rightIdentificationVariable && validator.rightIdentificationVariableValid && validator.leftStateFieldPathExpression && validator.leftStateFieldPathExpressionValid) {
                mapping = this.helper.resolveMapping(leftExpression);
                IdentificationVariable variable = (IdentificationVariable)rightExpression;
                if (mapping != null && this.helper.isPropertyMapping(mapping) && !this.isIdentificationVariableValidInComparison(variable)) {
                    this.addProblem(leftExpression, "COMPARISON_EXPRESSION_BASIC_FIELD", leftExpression.toActualText(), expression.getComparisonOperator());
                    valid = false;
                }
            }
            boolean bl = valid;
            return bl;
        }
        finally {
            validator.dispose();
        }
    }

    protected boolean validateConcatExpression(ConcatExpression expression) {
        return this.validateFunctionPathExpression(expression);
    }

    protected void validateConstructorExpression(ConstructorExpression expression) {
        super.visit(expression);
    }

    protected void validateCountFunction(CountFunction expression) {
        if (expression.hasExpression()) {
            Expression leftExpression = expression.getExpression();
            StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(leftExpression);
            if (pathExpression != null) {
                this.validateStateFieldPathExpression(pathExpression, this.validPathExpressionTypeForCountFunction());
            } else {
                leftExpression.accept(this);
            }
        }
    }

    protected void validateDateTime(DateTime expression) {
        super.visit(expression);
    }

    protected void validateDeleteClause(DeleteClause expression) {
        super.visit(expression);
    }

    protected void validateDeleteStatement(DeleteStatement expression) {
        super.visit(expression);
    }

    protected int validateDivisionExpression(DivisionExpression expression) {
        return this.validateArithmeticExpression(expression, "DIVISION_EXPRESSION_LEFT_EXPRESSION_WRONG_TYPE", "DIVISION_EXPRESSION_RIGHT_EXPRESSION_WRONG_TYPE");
    }

    protected boolean validateEntityTypeLiteral(EntityTypeLiteral expression) {
        Object entity;
        String entityTypeName = expression.getEntityTypeName();
        boolean valid = true;
        if (ExpressionTools.stringIsNotEmpty(entityTypeName) && (entity = this.helper.getEntityNamed(entityTypeName)) == null) {
            int startIndex = this.position(expression);
            int endIndex = startIndex + entityTypeName.length();
            this.addProblem((Expression)expression, startIndex, endIndex, "ENTITY_TYPE_LITERAL_NOT_RESOLVABLE", entityTypeName);
            valid = false;
        }
        return valid;
    }

    protected void validateEntryExpression(EntryExpression expression) {
        super.visit(expression);
    }

    protected void validateExistsExpression(ExistsExpression expression) {
        super.visit(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateFirstDeclaration(AbstractFromClause expression, JPQLQueryDeclaration declaration, FirstDeclarationVisitor visitor) {
        Expression declarationExpression = declaration.getDeclarationExpression();
        Expression baseExpression = declaration.getBaseExpression();
        try {
            baseExpression.accept(visitor);
            if (!visitor.valid) {
                int startPosition = this.position(declarationExpression);
                int endPosition = startPosition + this.length(declarationExpression);
                this.addProblem((Expression)expression, startPosition, endPosition, "ABSTRACT_FROM_CLAUSE_INVALID_FIRST_IDENTIFICATION_VARIABLE_DECLARATION", baseExpression.toActualText());
            } else {
                declarationExpression.accept(this);
            }
        }
        finally {
            visitor.valid = false;
        }
    }

    protected void validateFromClause(FromClause expression) {
        this.validateAbstractFromClause(expression, this.topLevelFirstDeclarationVisitor());
    }

    protected void validateFunctionExpression(FunctionExpression expression) {
    }

    protected boolean validateFunctionPathExpression(AbstractSingleEncapsulatedExpression expression) {
        boolean valid = true;
        if (expression.hasEncapsulatedExpression()) {
            Expression encapsulatedExpression = expression.getExpression();
            StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(encapsulatedExpression);
            if (pathExpression != null) {
                valid = this.validateStateFieldPathExpression(pathExpression, PathType.BASIC_FIELD_ONLY);
            } else {
                encapsulatedExpression.accept(this);
            }
        }
        return valid;
    }

    protected int validateFunctionPathExpression(CompoundExpression expression, PathType pathType) {
        boolean valid;
        StateFieldPathExpression pathExpression;
        int result = 0;
        if (expression.hasLeftExpression()) {
            Expression leftExpression = expression.getLeftExpression();
            pathExpression = this.getStateFieldPathExpression(leftExpression);
            if (pathExpression != null) {
                valid = this.validateStateFieldPathExpression(pathExpression, pathType);
                this.updateStatus(result, 0, valid);
            } else {
                leftExpression.accept(this);
            }
        }
        if (expression.hasRightExpression()) {
            Expression rightExpression = expression.getRightExpression();
            pathExpression = this.getStateFieldPathExpression(rightExpression);
            if (pathExpression != null) {
                valid = this.validateStateFieldPathExpression(pathExpression, pathType);
                this.updateStatus(result, 1, valid);
            } else {
                rightExpression.accept(this);
            }
        }
        return result;
    }

    protected void validateGroupByClause(GroupByClause expression) {
        super.visit(expression);
    }

    protected void validateHavingClause(HavingClause expression) {
        super.visit(expression);
    }

    protected boolean validateIdentificationVariable(IdentificationVariable expression) {
        boolean valid = true;
        if (!expression.isVirtual()) {
            String variable = expression.getText();
            boolean continueValidating = true;
            if (this.isComparingEntityTypeLiteral(expression)) {
                Object entity = this.helper.getEntityNamed(variable);
                boolean bl = continueValidating = entity == null;
            }
            if (continueValidating) {
                if (this.registerIdentificationVariable) {
                    this.usedIdentificationVariables.add(expression);
                }
                valid = this.validateIdentificationVariable(expression, variable);
            }
        } else {
            StateFieldPathExpression pathExpression = expression.getStateFieldPathExpression();
            if (pathExpression != null) {
                pathExpression.accept(this);
            }
        }
        return valid;
    }

    protected boolean validateIdentificationVariable(IdentificationVariable expression, String variable) {
        return true;
    }

    protected void validateIdentificationVariableDeclaration(IdentificationVariableDeclaration expression) {
        super.visit(expression);
    }

    protected void validateIdentificationVariables() {
        HashMap<String, List<IdentificationVariable>> identificationVariables = new HashMap<String, List<IdentificationVariable>>();
        this.helper.collectLocalDeclarationIdentificationVariables(identificationVariables);
        for (Map.Entry entry : identificationVariables.entrySet()) {
            List variables = (List)entry.getValue();
            if (variables.size() <= 1) continue;
            for (IdentificationVariable variable : variables) {
                this.addProblem((Expression)variable, "IDENTIFICATION_VARIABLE_INVALID_DUPLICATE", variable.getText());
            }
        }
        identificationVariables.clear();
        this.helper.collectAllDeclarationIdentificationVariables(identificationVariables);
        for (IdentificationVariable identificationVariable : this.usedIdentificationVariables) {
            String variableName = identificationVariable.getText();
            if (!ExpressionTools.stringIsNotEmpty(variableName) || identificationVariables.containsKey(variableName.toUpperCase(Locale.ROOT))) continue;
            this.addProblem((Expression)identificationVariable, "IDENTIFICATION_VARIABLE_INVALID_NOT_DECLARED", variableName);
        }
    }

    protected boolean validateIndexExpression(IndexExpression expression) {
        boolean valid = true;
        String variableName = this.literal(expression.getExpression(), LiteralType.IDENTIFICATION_VARIABLE);
        if (ExpressionTools.stringIsNotEmpty(variableName) && !this.helper.isCollectionIdentificationVariable(variableName)) {
            this.addProblem(expression.getExpression(), "INDEX_EXPRESSION_WRONG_VARIABLE", variableName);
            valid = false;
        }
        return valid;
    }

    protected void validateInExpression(InExpression expression) {
        if (expression.hasExpression()) {
            Expression stringExpression = expression.getExpression();
            StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(stringExpression);
            if (pathExpression != null) {
                this.validateStateFieldPathExpression(pathExpression, this.validPathExpressionTypeForInExpression());
            } else {
                stringExpression.accept(this);
            }
        }
        expression.getInItems().accept(this.getInItemsVisitor());
    }

    protected void validateJoin(Join expression) {
        if (expression.hasJoinAssociationPath()) {
            Expression joinAssociationPath = expression.getJoinAssociationPath();
            this.validateJoinCollectionValuedPathExpression(joinAssociationPath, false);
            joinAssociationPath.accept(this);
        }
        if (expression.hasIdentificationVariable()) {
            try {
                this.registerIdentificationVariable = false;
                expression.getIdentificationVariable().accept(this);
            }
            finally {
                this.registerIdentificationVariable = true;
            }
        }
    }

    protected void validateJoinsIdentificationVariable(AbstractFromClause expression, List<JPQLQueryDeclaration> declarations, JPQLQueryDeclaration declaration, int index) {
        List<Join> joins = declaration.getJoins();
        int joinCount = joins.size();
        for (int joinIndex = 0; joinIndex < joinCount; ++joinIndex) {
            Join join = joins.get(joinIndex);
            String variableName = this.literal(join.getJoinAssociationPath(), LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE);
            if (!ExpressionTools.stringIsNotEmpty(variableName) || !this.isIdentificationVariableDeclaredAfter(variableName, index, joinIndex, declarations)) continue;
            int startPosition = this.position(join.getJoinAssociationPath());
            int endPosition = startPosition + variableName.length();
            this.addProblem((Expression)expression, startPosition, endPosition, "ABSTRACT_FROM_CLAUSE_WRONG_ORDER_OF_IDENTIFICATION_VARIABLE_DECLARATION", variableName);
        }
    }

    protected void validateKeyExpression(KeyExpression expression) {
        super.visit(expression);
    }

    protected boolean validateLengthExpression(LengthExpression expression) {
        return this.validateFunctionPathExpression(expression);
    }

    protected int validateLikeExpression(LikeExpression expression) {
        int result = 0;
        if (expression.hasStringExpression()) {
            Expression stringExpression = expression.getStringExpression();
            StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(stringExpression);
            if (pathExpression != null) {
                boolean valid = this.validateStateFieldPathExpression(pathExpression, this.validPathExpressionTypeForStringExpression());
                this.updateStatus(result, 0, valid);
            } else {
                stringExpression.accept(this);
            }
        }
        expression.getPatternValue().accept(this);
        expression.getEscapeCharacter().accept(this);
        return result;
    }

    protected int validateLocateExpression(LocateExpression expression) {
        int result = 0;
        if (expression.hasFirstExpression()) {
            Expression firstExpression = expression.getFirstExpression();
            StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(firstExpression);
            if (pathExpression != null) {
                boolean valid = this.validateStateFieldPathExpression(pathExpression, PathType.BASIC_FIELD_ONLY);
                this.updateStatus(result, 0, valid);
            } else {
                firstExpression.accept(this);
            }
        }
        expression.getSecondExpression().accept(this);
        expression.getThirdExpression().accept(this);
        return result;
    }

    protected boolean validateLowerExpression(LowerExpression expression) {
        return this.validateFunctionPathExpression(expression);
    }

    protected boolean validateMaxFunction(MaxFunction expression) {
        return this.validateFunctionPathExpression(expression);
    }

    protected boolean validateMinFunction(MinFunction expression) {
        return this.validateFunctionPathExpression(expression);
    }

    protected int validateModExpression(ModExpression expression) {
        int result = 0;
        if (expression.hasFirstExpression()) {
            Expression firstExpression = expression.getFirstExpression();
            StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(firstExpression);
            if (pathExpression != null) {
                boolean valid = this.validateStateFieldPathExpression(pathExpression, PathType.BASIC_FIELD_ONLY);
                this.updateStatus(result, 0, valid);
            } else {
                firstExpression.accept(this);
            }
        }
        expression.getSecondExpression().accept(this);
        return result;
    }

    protected int validateMultiplicationExpression(MultiplicationExpression expression) {
        return this.validateArithmeticExpression(expression, "MULTIPLICATION_EXPRESSION_LEFT_EXPRESSION_WRONG_TYPE", "MULTIPLICATION_EXPRESSION_RIGHT_EXPRESSION_WRONG_TYPE");
    }

    protected void validateNotExpression(NotExpression expression) {
        super.visit(expression);
    }

    protected void validateNullComparisonExpression(NullComparisonExpression expression) {
        super.visit(expression);
    }

    protected void validateNullIfExpression(NullIfExpression expression) {
        super.visit(expression);
    }

    protected void validateObjectExpression(ObjectExpression expression) {
        super.visit(expression);
    }

    protected void validateOnClause(OnClause expression) {
        super.visit(expression);
    }

    protected void validateOrderByClause(OrderByClause expression) {
        super.visit(expression);
    }

    protected void validateOrderByItem(OrderByItem expression) {
        super.visit(expression);
    }

    protected void validateOrExpression(OrExpression expression) {
        super.visit(expression);
    }

    protected void validateRangeVariableDeclaration(RangeVariableDeclaration expression) {
        this.validateRangeVariableDeclarationRootObject(expression);
        try {
            this.registerIdentificationVariable = false;
            expression.getIdentificationVariable().accept(this);
        }
        finally {
            this.registerIdentificationVariable = true;
        }
    }

    protected void validateRangeVariableDeclarationRootObject(RangeVariableDeclaration expression) {
        expression.getRootObject().accept(this);
    }

    protected void validateResultVariable(ResultVariable expression) {
        super.visit(expression);
    }

    protected void validateSelectClause(SelectClause expression) {
        Expression selectExpression = expression.getSelectExpression();
        StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(selectExpression);
        if (pathExpression != null) {
            this.validateStateFieldPathExpression(pathExpression, this.selectClausePathExpressionPathType());
        } else {
            selectExpression.accept(this);
        }
    }

    protected void validateSelectStatement(SelectStatement expression) {
        super.visit(expression);
    }

    protected void validateSimpleFromClause(SimpleFromClause expression) {
        this.validateAbstractFromClause(expression, this.subqueryFirstDeclarationVisitor());
    }

    protected void validateSimpleSelectClause(SimpleSelectClause expression) {
        super.visit(expression);
    }

    protected void validateSimpleSelectStatement(SimpleSelectStatement expression) {
        ArrayList<IdentificationVariable> oldUsedIdentificationVariables = new ArrayList<IdentificationVariable>(this.usedIdentificationVariables);
        this.helper.newSubqueryContext(expression);
        try {
            super.visit(expression);
            this.validateIdentificationVariables();
        }
        finally {
            this.helper.disposeSubqueryContext();
            this.usedIdentificationVariables.retainAll(oldUsedIdentificationVariables);
        }
    }

    protected boolean validateSizeExpression(SizeExpression expression) {
        return this.validateCollectionValuedPathExpression(expression.getExpression(), true);
    }

    protected boolean validateSqrtExpression(SqrtExpression expression) {
        return this.validateFunctionPathExpression(expression);
    }

    protected boolean validateStateFieldPathExpression(StateFieldPathExpression expression, PathType pathType) {
        boolean valid = true;
        if (expression.hasIdentificationVariable()) {
            expression.getIdentificationVariable().accept(this);
            if (!expression.endsWithDot()) {
                Object mapping = this.helper.resolveMapping(expression);
                if (mapping != null) {
                    if (this.helper.isCollectionMapping(mapping)) {
                        if (pathType != PathType.ANY_FIELD_INCLUDING_COLLECTION) {
                            this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_COLLECTION_TYPE", expression.toActualText());
                            valid = false;
                        }
                    } else if (this.helper.isTransient(mapping)) {
                        this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_NO_MAPPING", expression.toParsedText());
                        valid = false;
                    } else if (pathType == PathType.BASIC_FIELD_ONLY && !this.helper.isPropertyMapping(mapping)) {
                        this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_ASSOCIATION_FIELD", expression.toActualText());
                        valid = false;
                    } else if (pathType == PathType.ASSOCIATION_FIELD_ONLY && this.helper.isPropertyMapping(mapping)) {
                        this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_BASIC_FIELD", expression.toActualText());
                        valid = false;
                    }
                } else {
                    Object type = this.helper.getType(expression.toParsedText(0, expression.pathSize() - 1));
                    if (this.helper.isEnumType(type)) {
                        String enumConstant = expression.getPath(expression.pathSize() - 1);
                        boolean found = false;
                        for (String constant : this.helper.getEnumConstants(type)) {
                            if (!constant.equals(enumConstant)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            int startIndex = this.position(expression) + this.helper.getTypeName(type).length() + 1;
                            int endIndex = startIndex + enumConstant.length();
                            this.addProblem((Expression)expression, startIndex, endIndex, "STATE_FIELD_PATH_EXPRESSION_INVALID_ENUM_CONSTANT", enumConstant);
                            valid = false;
                        }
                        this.usedIdentificationVariables.remove(expression.getIdentificationVariable());
                    } else {
                        Boolean status = this.validateThirdPartyStateFieldPathExpression(expression);
                        if (status != null) {
                            valid = status;
                        } else {
                            type = this.helper.getType(expression);
                            if (!this.helper.isTypeResolvable(type)) {
                                this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_NOT_RESOLVABLE", expression.toActualText());
                                valid = false;
                            } else {
                                this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_NO_MAPPING", expression.toActualText());
                                valid = false;
                            }
                        }
                    }
                }
            }
        }
        return valid;
    }

    protected int validateSubstringExpression(SubstringExpression expression) {
        int result = 0;
        if (expression.hasFirstExpression()) {
            Expression firstExpression = expression.getFirstExpression();
            StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(firstExpression);
            if (pathExpression != null) {
                boolean valid = this.validateStateFieldPathExpression(pathExpression, PathType.BASIC_FIELD_ONLY);
                this.updateStatus(result, 0, valid);
            } else {
                firstExpression.accept(this);
            }
        }
        expression.getSecondExpression().accept(this);
        expression.getThirdExpression().accept(this);
        return result;
    }

    protected int validateSubtractionExpression(SubtractionExpression expression) {
        return this.validateArithmeticExpression(expression, "SUBTRACTION_EXPRESSION_LEFT_EXPRESSION_WRONG_TYPE", "SUBTRACTION_EXPRESSION_RIGHT_EXPRESSION_WRONG_TYPE");
    }

    protected boolean validateSumFunction(SumFunction expression) {
        return this.validateFunctionPathExpression(expression);
    }

    protected Boolean validateThirdPartyStateFieldPathExpression(StateFieldPathExpression expression) {
        return null;
    }

    protected void validateTreatExpression(TreatExpression expression) {
        super.visit(expression);
    }

    protected boolean validateTrimExpression(TrimExpression expression) {
        return this.validateFunctionPathExpression(expression);
    }

    protected boolean validateTypeExpression(TypeExpression expression) {
        if (expression.hasEncapsulatedExpression()) {
            Expression encapsulatedExpression = expression.getExpression();
            StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(encapsulatedExpression);
            if (pathExpression != null) {
                return this.validateStateFieldPathExpression(pathExpression, PathType.ASSOCIATION_FIELD_ONLY);
            }
            encapsulatedExpression.accept(this);
        }
        return true;
    }

    protected void validateUpdateClause(UpdateClause expression) {
        super.visit(expression);
    }

    protected boolean validateUpdateItem(UpdateItem expression) {
        boolean valid = true;
        if (expression.hasStateFieldPathExpression()) {
            StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(expression.getStateFieldPathExpression());
            if (pathExpression != null && (pathExpression.hasIdentificationVariable() || pathExpression.hasVirtualIdentificationVariable())) {
                Object managedType = this.helper.getManagedType(pathExpression.getIdentificationVariable());
                if (managedType != null) {
                    int count = pathExpression.pathSize();
                    for (int index = pathExpression.hasVirtualIdentificationVariable() ? 0 : 1; index < count; ++index) {
                        String path = pathExpression.getPath(index);
                        Object mapping = this.helper.getMappingNamed(managedType, path);
                        if (mapping == null) {
                            this.addProblem((Expression)pathExpression, "UPDATE_ITEM_NOT_RESOLVABLE", pathExpression.toParsedText());
                            valid = false;
                        } else if (this.helper.isCollectionMapping(mapping)) {
                            this.addProblem(pathExpression, "UPDATE_ITEM_RELATIONSHIP_PATH_EXPRESSION");
                            valid = false;
                        } else {
                            if (index + 1 >= count) continue;
                            if (this.helper.isRelationshipMapping(mapping)) {
                                this.addProblem(pathExpression, "UPDATE_ITEM_RELATIONSHIP_PATH_EXPRESSION");
                                valid = false;
                            } else if (this.helper.isPropertyMapping(mapping)) {
                                this.addProblem(pathExpression, "UPDATE_ITEM_RELATIONSHIP_PATH_EXPRESSION");
                                valid = false;
                            } else {
                                managedType = this.helper.getReferenceManagedType(mapping);
                                if (managedType != null) continue;
                                this.addProblem((Expression)pathExpression, "UPDATE_ITEM_NOT_RESOLVABLE", pathExpression.toParsedText());
                                valid = false;
                            }
                        }
                        break;
                    }
                } else {
                    this.addProblem((Expression)pathExpression, "UPDATE_ITEM_NOT_RESOLVABLE", pathExpression.toParsedText());
                    valid = false;
                }
            } else {
                this.addProblem((Expression)pathExpression, "UPDATE_ITEM_NOT_RESOLVABLE", expression.getStateFieldPathExpression().toParsedText());
                valid = false;
            }
        }
        return valid;
    }

    protected void validateUpdateStatement(UpdateStatement expression) {
        super.visit(expression);
    }

    protected boolean validateUpperExpression(UpperExpression expression) {
        return this.validateFunctionPathExpression(expression);
    }

    protected void validateValueExpression(ValueExpression expression) {
        super.visit(expression);
    }

    protected void validateWhenClause(WhenClause expression) {
        super.visit(expression);
    }

    protected void validateWhereClause(WhereClause expression) {
        super.visit(expression);
    }

    protected PathType validPathExpressionTypeForCountFunction() {
        return PathType.ANY_FIELD;
    }

    protected PathType validPathExpressionTypeForInExpression() {
        return PathType.ANY_FIELD;
    }

    protected PathType validPathExpressionTypeForInItem() {
        return PathType.ANY_FIELD;
    }

    protected PathType validPathExpressionTypeForStringExpression() {
        return PathType.BASIC_FIELD_ONLY;
    }

    @Override
    public final void visit(AbsExpression expression) {
        this.validateAbsExpression(expression);
    }

    @Override
    public final void visit(AbstractSchemaName expression) {
        this.validateAbstractSchemaName(expression);
    }

    @Override
    public final void visit(AdditionExpression expression) {
        this.validateAdditionExpression(expression);
    }

    @Override
    public final void visit(AllOrAnyExpression expression) {
        this.validateAllOrAnyExpression(expression);
    }

    @Override
    public final void visit(AndExpression expression) {
        this.validateAndExpression(expression);
    }

    @Override
    public final void visit(ArithmeticFactor expression) {
        this.validateArithmeticExpression(expression);
    }

    @Override
    public final void visit(AvgFunction expression) {
        this.validateAvgFunction(expression);
    }

    @Override
    public final void visit(BadExpression expression) {
    }

    @Override
    public final void visit(BetweenExpression expression) {
        this.validateBetweenExpression(expression);
    }

    @Override
    public final void visit(CaseExpression expression) {
        this.validateCaseExpression(expression);
    }

    @Override
    public final void visit(CoalesceExpression expression) {
        this.validateCoalesceExpression(expression);
    }

    @Override
    public final void visit(CollectionExpression expression) {
        super.visit(expression);
    }

    @Override
    public final void visit(CollectionMemberDeclaration expression) {
        this.validateCollectionMemberDeclaration(expression);
    }

    @Override
    public final void visit(CollectionMemberExpression expression) {
        this.validateCollectionMemberExpression(expression);
    }

    @Override
    public final void visit(CollectionValuedPathExpression expression) {
    }

    @Override
    public final void visit(ComparisonExpression expression) {
        this.validateComparisonExpression(expression);
    }

    @Override
    public final void visit(ConcatExpression expression) {
        this.validateConcatExpression(expression);
    }

    @Override
    public final void visit(ConstructorExpression expression) {
        this.validateConstructorExpression(expression);
    }

    @Override
    public final void visit(CountFunction expression) {
        this.validateCountFunction(expression);
    }

    @Override
    public final void visit(DateTime expression) {
        this.validateDateTime(expression);
    }

    @Override
    public final void visit(DeleteClause expression) {
        this.validateDeleteClause(expression);
    }

    @Override
    public final void visit(DeleteStatement expression) {
        this.validateDeleteStatement(expression);
    }

    @Override
    public final void visit(DivisionExpression expression) {
        this.validateDivisionExpression(expression);
    }

    @Override
    public final void visit(EmptyCollectionComparisonExpression expression) {
        this.validateCollectionValuedPathExpression(expression.getExpression(), true);
    }

    @Override
    public final void visit(EntityTypeLiteral expression) {
        this.validateEntityTypeLiteral(expression);
    }

    @Override
    public final void visit(EntryExpression expression) {
        this.validateEntryExpression(expression);
    }

    @Override
    public final void visit(ExistsExpression expression) {
        this.validateExistsExpression(expression);
    }

    @Override
    public final void visit(FromClause expression) {
        this.validateFromClause(expression);
    }

    @Override
    public final void visit(FunctionExpression expression) {
        this.validateFunctionExpression(expression);
    }

    @Override
    public final void visit(GroupByClause expression) {
        this.validateGroupByClause(expression);
    }

    @Override
    public final void visit(HavingClause expression) {
        this.validateHavingClause(expression);
    }

    @Override
    public final void visit(IdentificationVariable expression) {
        this.validateIdentificationVariable(expression);
    }

    @Override
    public final void visit(IdentificationVariableDeclaration expression) {
        this.validateIdentificationVariableDeclaration(expression);
    }

    @Override
    public final void visit(IndexExpression expression) {
        this.validateIndexExpression(expression);
    }

    @Override
    public final void visit(InExpression expression) {
        this.validateInExpression(expression);
    }

    @Override
    public final void visit(InputParameter expression) {
    }

    @Override
    public final void visit(Join expression) {
        this.validateJoin(expression);
    }

    @Override
    public final void visit(JPQLExpression expression) {
        if (expression.hasQueryStatement()) {
            expression.getQueryStatement().accept(this);
            this.validateIdentificationVariables();
        }
    }

    @Override
    public final void visit(KeyExpression expression) {
        this.validateKeyExpression(expression);
    }

    @Override
    public final void visit(KeywordExpression expression) {
    }

    @Override
    public final void visit(LengthExpression expression) {
        this.validateLengthExpression(expression);
    }

    @Override
    public final void visit(LikeExpression expression) {
        this.validateLikeExpression(expression);
    }

    @Override
    public final void visit(LocateExpression expression) {
        this.validateLocateExpression(expression);
    }

    @Override
    public final void visit(LowerExpression expression) {
        this.validateLowerExpression(expression);
    }

    @Override
    public final void visit(MaxFunction expression) {
        this.validateMaxFunction(expression);
    }

    @Override
    public final void visit(MinFunction expression) {
        this.validateMinFunction(expression);
    }

    @Override
    public final void visit(ModExpression expression) {
        this.validateModExpression(expression);
    }

    @Override
    public final void visit(MultiplicationExpression expression) {
        this.validateMultiplicationExpression(expression);
    }

    @Override
    public final void visit(NotExpression expression) {
        this.validateNotExpression(expression);
    }

    @Override
    public final void visit(NullComparisonExpression expression) {
        this.validateNullComparisonExpression(expression);
    }

    @Override
    public final void visit(NullExpression expression) {
    }

    @Override
    public final void visit(NullIfExpression expression) {
        this.validateNullIfExpression(expression);
    }

    @Override
    public final void visit(NumericLiteral expression) {
    }

    @Override
    public final void visit(ObjectExpression expression) {
        this.validateObjectExpression(expression);
    }

    @Override
    public final void visit(OnClause expression) {
        this.validateOnClause(expression);
    }

    @Override
    public final void visit(OrderByClause expression) {
        this.validateOrderByClause(expression);
    }

    @Override
    public final void visit(OrderByItem expression) {
        this.validateOrderByItem(expression);
    }

    @Override
    public final void visit(OrExpression expression) {
        this.validateOrExpression(expression);
    }

    @Override
    public final void visit(RangeVariableDeclaration expression) {
        this.validateRangeVariableDeclaration(expression);
    }

    @Override
    public final void visit(ResultVariable expression) {
        try {
            this.registerIdentificationVariable = false;
            this.validateResultVariable(expression);
        }
        finally {
            this.registerIdentificationVariable = true;
        }
    }

    @Override
    public final void visit(SelectClause expression) {
        this.validateSelectClause(expression);
    }

    @Override
    public final void visit(SelectStatement expression) {
        this.validateSelectStatement(expression);
    }

    @Override
    public final void visit(SimpleFromClause expression) {
        this.validateSimpleFromClause(expression);
    }

    @Override
    public final void visit(SimpleSelectClause expression) {
        this.validateSimpleSelectClause(expression);
    }

    @Override
    public final void visit(SimpleSelectStatement expression) {
        this.validateSimpleSelectStatement(expression);
    }

    @Override
    public final void visit(SizeExpression expression) {
        this.validateSizeExpression(expression);
    }

    @Override
    public final void visit(SqrtExpression expression) {
        this.validateSqrtExpression(expression);
    }

    @Override
    public final void visit(StateFieldPathExpression expression) {
        this.validateStateFieldPathExpression(expression, PathType.ANY_FIELD);
    }

    @Override
    public final void visit(StringLiteral expression) {
    }

    @Override
    public final void visit(SubExpression expression) {
        super.visit(expression);
    }

    @Override
    public final void visit(SubstringExpression expression) {
        this.validateSubstringExpression(expression);
    }

    @Override
    public final void visit(SubtractionExpression expression) {
        this.validateSubtractionExpression(expression);
    }

    @Override
    public final void visit(SumFunction expression) {
        this.validateSumFunction(expression);
    }

    @Override
    public final void visit(TreatExpression expression) {
        this.validateTreatExpression(expression);
    }

    @Override
    public final void visit(TrimExpression expression) {
        this.validateTrimExpression(expression);
    }

    @Override
    public final void visit(TypeExpression expression) {
        this.validateTypeExpression(expression);
    }

    @Override
    public final void visit(UnknownExpression expression) {
    }

    @Override
    public final void visit(UpdateClause expression) {
        this.validateUpdateClause(expression);
    }

    @Override
    public final void visit(UpdateItem expression) {
        this.validateUpdateItem(expression);
    }

    @Override
    public final void visit(UpdateStatement expression) {
        this.validateUpdateStatement(expression);
    }

    @Override
    public final void visit(UpperExpression expression) {
        this.validateUpperExpression(expression);
    }

    @Override
    public final void visit(ValueExpression expression) {
        this.validateValueExpression(expression);
    }

    @Override
    public final void visit(WhenClause expression) {
        this.validateWhenClause(expression);
    }

    @Override
    public final void visit(WhereClause expression) {
        this.validateWhereClause(expression);
    }

    protected static class TopLevelFirstDeclarationVisitor
    extends FirstDeclarationVisitor {
        protected TopLevelFirstDeclarationVisitor() {
        }

        @Override
        public void visit(AbstractSchemaName expression) {
            this.valid = true;
        }
    }

    protected static final class SubqueryFirstDeclarationVisitor
    extends FirstDeclarationVisitor {
        protected SubqueryFirstDeclarationVisitor() {
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            this.valid = true;
        }
    }

    protected static final class StateFieldPathExpressionVisitor
    extends AbstractExpressionVisitor {
        protected StateFieldPathExpression expression;

        protected StateFieldPathExpressionVisitor() {
        }

        @Override
        public void visit(StateFieldPathExpression expression) {
            this.expression = expression;
        }
    }

    protected static enum PathType {
        ANY_FIELD,
        ANY_FIELD_INCLUDING_COLLECTION,
        ASSOCIATION_FIELD_ONLY,
        BASIC_FIELD_ONLY;

    }

    protected static final class InItemsVisitor
    extends AnonymousExpressionVisitor {
        private final AbstractSemanticValidator validator;

        protected InItemsVisitor(AbstractSemanticValidator validator) {
            this.validator = validator;
        }

        @Override
        protected void visit(Expression expression) {
            expression.accept(this.validator);
        }

        @Override
        public void visit(StateFieldPathExpression expression) {
            this.validator.validateStateFieldPathExpression(expression, this.validator.validPathExpressionTypeForInItem());
        }
    }

    protected static class FirstDeclarationVisitor
    extends AnonymousExpressionVisitor {
        protected boolean valid;

        protected FirstDeclarationVisitor() {
        }

        @Override
        public void visit(AbstractSchemaName expression) {
            this.valid = true;
        }

        @Override
        public void visit(BadExpression expression) {
            this.valid = false;
        }

        @Override
        protected void visit(Expression expression) {
            this.valid = false;
        }

        @Override
        public void visit(IdentificationVariableDeclaration expression) {
            expression.getRangeVariableDeclaration().accept(this);
        }

        @Override
        public void visit(NullExpression expression) {
            this.valid = false;
        }

        @Override
        public void visit(RangeVariableDeclaration expression) {
            expression.getRootObject().accept(this);
        }
    }

    protected static final class ComparisonExpressionVisitor
    extends AnonymousExpressionVisitor {
        private final AbstractSemanticValidator validator;
        public boolean leftIdentificationVariable;
        public boolean leftIdentificationVariableValid;
        public boolean leftStateFieldPathExpression;
        public boolean leftStateFieldPathExpressionValid;
        public boolean rightIdentificationVariable;
        public boolean rightIdentificationVariableValid;
        public boolean rightStateFieldPathExpression;
        public boolean rightStateFieldPathExpressionValid;
        public boolean validatingLeftExpression;

        private ComparisonExpressionVisitor(AbstractSemanticValidator validator) {
            this.validator = validator;
        }

        private void dispose() {
            this.leftIdentificationVariable = false;
            this.leftIdentificationVariableValid = false;
            this.leftStateFieldPathExpression = false;
            this.leftStateFieldPathExpressionValid = false;
            this.rightIdentificationVariable = false;
            this.rightIdentificationVariableValid = false;
            this.rightStateFieldPathExpression = false;
            this.rightStateFieldPathExpressionValid = false;
        }

        @Override
        protected void visit(Expression expression) {
            expression.accept(this.validator);
        }

        @Override
        public void visit(IdentificationVariable expression) {
            if (!this.validator.helper.isResultVariable(expression.getVariableName())) {
                if (this.validatingLeftExpression) {
                    this.leftIdentificationVariable = !expression.isVirtual();
                    this.leftIdentificationVariableValid = this.validator.validateIdentificationVariable(expression);
                } else {
                    this.rightIdentificationVariable = !expression.isVirtual();
                    this.rightIdentificationVariableValid = this.validator.validateIdentificationVariable(expression);
                }
            }
        }

        @Override
        public void visit(StateFieldPathExpression expression) {
            if (this.validatingLeftExpression) {
                this.leftStateFieldPathExpression = true;
                this.leftStateFieldPathExpressionValid = this.validator.validateStateFieldPathExpression(expression, PathType.ANY_FIELD_INCLUDING_COLLECTION);
            } else {
                this.rightStateFieldPathExpression = true;
                this.rightStateFieldPathExpressionValid = this.validator.validateStateFieldPathExpression(expression, PathType.ANY_FIELD_INCLUDING_COLLECTION);
            }
        }
    }

    protected static final class ComparingEntityTypeLiteralVisitor
    extends AbstractExpressionVisitor {
        protected IdentificationVariable expression;
        public boolean result;

        protected ComparingEntityTypeLiteralVisitor() {
        }

        @Override
        public void visit(ComparisonExpression expression) {
            this.result = true;
        }

        @Override
        public void visit(IdentificationVariable expression) {
            if (this.expression == expression) {
                expression.getParent().accept(this);
            }
        }

        @Override
        public void visit(SubExpression expression) {
            expression.getParent().accept(this);
        }
    }

    protected static final class CollectionValuedPathExpressionVisitor
    extends AbstractExpressionVisitor {
        protected CollectionValuedPathExpression expression;

        protected CollectionValuedPathExpressionVisitor() {
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            this.expression = expression;
        }
    }
}

