/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ClientResourceInfo;
import com.sun.faces.application.resource.ContractInfo;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ResourceManager;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.ResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebappResourceHelper
extends ResourceHelper {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private final String BASE_RESOURCE_PATH;
    private final String BASE_CONTRACTS_PATH;
    private boolean cacheTimestamp;

    public WebappResourceHelper() {
        WebConfiguration webconfig = WebConfiguration.getInstance();
        this.cacheTimestamp = webconfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CacheResourceModificationTimestamp);
        this.BASE_RESOURCE_PATH = webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.WebAppResourcesDirectory);
        this.BASE_CONTRACTS_PATH = webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.WebAppContractsDirectory);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebappResourceHelper other = (WebappResourceHelper)obj;
        if (this.BASE_RESOURCE_PATH == null ? other.BASE_RESOURCE_PATH != null : !this.BASE_RESOURCE_PATH.equals(other.BASE_RESOURCE_PATH)) {
            return false;
        }
        if (this.BASE_CONTRACTS_PATH == null ? other.BASE_CONTRACTS_PATH != null : !this.BASE_CONTRACTS_PATH.equals(other.BASE_CONTRACTS_PATH)) {
            return false;
        }
        return this.cacheTimestamp == other.cacheTimestamp;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.BASE_RESOURCE_PATH != null ? this.BASE_RESOURCE_PATH.hashCode() : 0);
        hash = 37 * hash + (this.BASE_CONTRACTS_PATH != null ? this.BASE_CONTRACTS_PATH.hashCode() : 0);
        hash = 37 * hash + (this.cacheTimestamp ? 1 : 0);
        return hash;
    }

    @Override
    public String getBaseResourcePath() {
        return this.BASE_RESOURCE_PATH;
    }

    @Override
    public String getBaseContractsPath() {
        return this.BASE_CONTRACTS_PATH;
    }

    @Override
    protected InputStream getNonCompressedInputStream(ResourceInfo resource, FacesContext ctx) throws IOException {
        return ctx.getExternalContext().getResourceAsStream(resource.getPath());
    }

    @Override
    public URL getURL(ResourceInfo resource, FacesContext ctx) {
        ResourceResolver nonDefaultResourceResolver = (ResourceResolver)ctx.getAttributes().get("com.sun.faces.NDRRPN");
        String path = resource.getPath();
        if (null != nonDefaultResourceResolver) {
            return nonDefaultResourceResolver.resolveUrl(path);
        }
        try {
            return ctx.getExternalContext().getResource(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public LibraryInfo findLibrary(String libraryName, String localePrefix, String contract, FacesContext ctx) {
        String path = localePrefix == null ? this.getBasePath(contract) + '/' + libraryName : this.getBasePath(contract) + '/' + localePrefix + '/' + libraryName;
        Set<String> resourcePaths = ctx.getExternalContext().getResourcePaths(path);
        if (resourcePaths != null && !resourcePaths.isEmpty()) {
            VersionInfo version = this.getVersion(resourcePaths, false);
            return new LibraryInfo(libraryName, version, localePrefix, contract, this);
        }
        return null;
    }

    @Override
    public ResourceInfo findResource(LibraryInfo library, String resourceName, String localePrefix, boolean compressable, FacesContext ctx) {
        ClientResourceInfo value;
        Set<String> resourcePaths;
        ContractInfo[] outContract;
        String basePath = this.findPathConsideringContracts(library, resourceName = this.trimLeadingSlash(resourceName), localePrefix, outContract = new ContractInfo[]{null}, ctx);
        if (null == basePath) {
            basePath = library != null ? library.getPath(localePrefix) + '/' + resourceName : (localePrefix == null ? this.getBaseResourcePath() + '/' + resourceName : this.getBaseResourcePath() + '/' + localePrefix + '/' + resourceName);
            try {
                if (ctx.getExternalContext().getResource(basePath) == null) {
                    return null;
                }
            }
            catch (MalformedURLException e) {
                throw new FacesException(e);
            }
        }
        if ((resourcePaths = ctx.getExternalContext().getResourcePaths(basePath)) == null || resourcePaths.size() == 0) {
            value = library != null ? new ClientResourceInfo(library, outContract[0], resourceName, null, compressable, this.resourceSupportsEL(resourceName, library.getName(), ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp) : new ClientResourceInfo(outContract[0], resourceName, null, localePrefix, this, compressable, this.resourceSupportsEL(resourceName, null, ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp);
        } else {
            VersionInfo version = this.getVersion(resourcePaths, true);
            if (version == null && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.application.resource.unable_to_determine_resource_version.", resourceName);
            }
            value = library != null ? new ClientResourceInfo(library, outContract[0], resourceName, version, compressable, this.resourceSupportsEL(resourceName, library.getName(), ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp) : new ClientResourceInfo(outContract[0], resourceName, version, localePrefix, this, compressable, this.resourceSupportsEL(resourceName, null, ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp);
        }
        if (value.isCompressable()) {
            value = this.handleCompression(value);
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String findPathConsideringContracts(LibraryInfo library, String resourceName, String localePrefix, ContractInfo[] outContract, FacesContext ctx) {
        UIViewRoot root = ctx.getViewRoot();
        List<Object> contracts = null;
        if (library != null) {
            if (library.getContract() == null) {
                contracts = Collections.emptyList();
            } else {
                contracts = new ArrayList(1);
                contracts.add(library.getContract());
            }
        } else if (root == null) {
            String contractName = ctx.getExternalContext().getRequestParameterMap().get("con");
            if (null == contractName || 0 >= contractName.length() || ResourceManager.nameContainsForbiddenSequence(contractName)) return null;
            contracts = new ArrayList();
            contracts.add(contractName);
        } else {
            contracts = ctx.getResourceLibraryContracts();
        }
        String basePath = null;
        for (String string : contracts) {
            basePath = library != null ? library.getPath(localePrefix) + '/' + resourceName : (localePrefix == null ? this.getBaseContractsPath() + '/' + string + '/' + resourceName : this.getBaseContractsPath() + '/' + string + '/' + localePrefix + '/' + resourceName);
            try {
                if (ctx.getExternalContext().getResource(basePath) != null) {
                    outContract[0] = new ContractInfo(string);
                    return basePath;
                }
                basePath = null;
            }
            catch (MalformedURLException e) {
                throw new FacesException(e);
            }
        }
        return basePath;
    }
}

