/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.el.ValueExpression;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.MessageFactory;
import jakarta.faces.component.SelectItemsIterator;
import jakarta.faces.component.SelectUtils;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.el.ValueBinding;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class UISelectMany
extends UIInput {
    public static final String COMPONENT_TYPE = "jakarta.faces.SelectMany";
    public static final String COMPONENT_FAMILY = "jakarta.faces.SelectMany";
    public static final String INVALID_MESSAGE_ID = "jakarta.faces.component.UISelectMany.INVALID";

    public UISelectMany() {
        this.setRendererType("jakarta.faces.Listbox");
    }

    @Override
    public String getFamily() {
        return "jakarta.faces.SelectMany";
    }

    public Object[] getSelectedValues() {
        return (Object[])this.getValue();
    }

    public void setSelectedValues(Object[] selectedValues) {
        this.setValue(selectedValues);
    }

    @Override
    @Deprecated
    public ValueBinding getValueBinding(String name) {
        if ("selectedValues".equals(name)) {
            return super.getValueBinding("value");
        }
        return super.getValueBinding(name);
    }

    @Override
    @Deprecated
    public void setValueBinding(String name, ValueBinding binding) {
        if ("selectedValues".equals(name)) {
            super.setValueBinding("value", binding);
        } else {
            super.setValueBinding(name, binding);
        }
    }

    @Override
    public ValueExpression getValueExpression(String name) {
        if ("selectedValues".equals(name)) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    @Override
    public void setValueExpression(String name, ValueExpression binding) {
        if ("selectedValues".equals(name)) {
            super.setValueExpression("value", binding);
        } else {
            super.setValueExpression(name, binding);
        }
    }

    @Override
    protected boolean compareValues(Object previous, Object value) {
        if (previous == null && value != null) {
            return true;
        }
        if (previous != null && value == null) {
            return true;
        }
        if (previous == null) {
            return false;
        }
        boolean valueChanged = false;
        if (!(previous instanceof Object[])) {
            previous = UISelectMany.toObjectArray(previous);
        }
        if (!(value instanceof Object[])) {
            value = UISelectMany.toObjectArray(value);
        }
        if (!(previous instanceof Object[]) || !(value instanceof Object[])) {
            return false;
        }
        Object[] oldarray = previous;
        Object[] newarray = value;
        if (oldarray.length != newarray.length) {
            return true;
        }
        for (int i = 0; i < oldarray.length; ++i) {
            int count2;
            int count1 = UISelectMany.countElementOccurrence(oldarray[i], oldarray);
            if (count1 == (count2 = UISelectMany.countElementOccurrence(oldarray[i], newarray))) continue;
            valueChanged = true;
            break;
        }
        return valueChanged;
    }

    private static int countElementOccurrence(Object element, Object[] array) {
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            Object arrayElement = array[i];
            if (arrayElement == null || element == null || !arrayElement.equals(element)) continue;
            ++count;
        }
        return count;
    }

    private static Object[] toObjectArray(Object primitiveArray) {
        if (primitiveArray == null) {
            throw new NullPointerException();
        }
        if (primitiveArray instanceof Object[]) {
            return (Object[])primitiveArray;
        }
        if (primitiveArray instanceof Collection) {
            return ((Collection)primitiveArray).toArray();
        }
        Class<?> clazz = primitiveArray.getClass();
        if (!clazz.isArray()) {
            return null;
        }
        int length = Array.getLength(primitiveArray);
        Object[] array = new Object[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Array.get(primitiveArray, i);
        }
        return array;
    }

    @Override
    protected void validateValue(FacesContext context, Object value) {
        Object currentValue;
        SelectItemsIterator items;
        super.validateValue(context, value);
        if (!this.isValid() || value == null) {
            return;
        }
        boolean doAddMessage = false;
        Converter converter = this.getConverter();
        Iterator i = this.getValuesIterator(value);
        while (i.hasNext()) {
            items = new SelectItemsIterator(context, this);
            currentValue = i.next();
            if (SelectUtils.matchValue(context, this, currentValue, items, converter)) continue;
            doAddMessage = true;
            break;
        }
        if (this.isRequired()) {
            i = this.getValuesIterator(value);
            while (i.hasNext()) {
                items = new SelectItemsIterator(context, this);
                currentValue = i.next();
                if (!SelectUtils.valueIsNoSelectionOption(context, this, currentValue, items, converter)) continue;
                doAddMessage = true;
                break;
            }
        }
        if (doAddMessage) {
            FacesMessage message = MessageFactory.getMessage(context, INVALID_MESSAGE_ID, MessageFactory.getLabel(context, this));
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
    }

    private Iterator getValuesIterator(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).iterator();
        }
        return new ArrayIterator(value);
    }

    private static final class ArrayIterator
    implements Iterator {
        private int length;
        private int idx = 0;
        private Object value;

        ArrayIterator(Object value) {
            this.value = value;
            this.length = Array.getLength(value);
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.length;
        }

        public Object next() {
            if (this.idx >= this.length) {
                throw new NoSuchElementException();
            }
            return Array.get(this.value, this.idx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

