/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dynamic;

import java.io.Serializable;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class DynamicPropertiesInitializatonPolicy {
    public void initializeProperties(DynamicTypeImpl type, DynamicEntityImpl entity) {
        if (type != null) {
            for (DatabaseMapping mapping : type.getMappingsRequiringInitialization()) {
                this.initializeDefaultValue(mapping, entity);
            }
        }
    }

    private void initializeDefaultValue(DatabaseMapping mapping, DynamicEntityImpl entity) {
        Serializable value = null;
        if (mapping.isDirectToFieldMapping() && mapping.getAttributeClassification().isPrimitive()) {
            Class primClass = mapping.getAttributeClassification();
            if (primClass == ClassConstants.PBOOLEAN) {
                value = false;
            } else if (primClass == ClassConstants.PINT) {
                value = 0;
            } else if (primClass == ClassConstants.PLONG) {
                value = 0L;
            } else if (primClass == ClassConstants.PCHAR) {
                value = Character.valueOf('\u0000');
            } else if (primClass == ClassConstants.PDOUBLE) {
                value = 0.0;
            } else if (primClass == ClassConstants.PFLOAT) {
                value = Float.valueOf(0.0f);
            } else if (primClass == ClassConstants.PSHORT) {
                value = (short)Short.MIN_VALUE;
            } else if (primClass == ClassConstants.PBYTE) {
                value = (byte)-128;
            }
        } else if (mapping.isForeignReferenceMapping()) {
            ForeignReferenceMapping refMapping = (ForeignReferenceMapping)mapping;
            if (refMapping.usesIndirection() && refMapping.getIndirectionPolicy() instanceof BasicIndirectionPolicy) {
                value = new ValueHolder<Object>(value);
            } else if (refMapping.isCollectionMapping()) {
                value = refMapping.getContainerPolicy().containerInstance();
            }
        } else if (mapping.isAggregateObjectMapping()) {
            value = mapping.getReferenceDescriptor().getObjectBuilder().buildNewInstance();
        }
        DynamicEntityImpl.PropertyWrapper propertyWrapper = entity.getPropertiesMap().get(mapping.getAttributeName());
        propertyWrapper.setValue(value);
    }
}

