/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.HashMap;
import java.util.Map;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Node;

class BeanRepository {
    private Map<String, String> beanTypes;
    private ClassLoader loader;
    private ErrorDispatcher errDispatcher;

    public BeanRepository(ClassLoader loader, ErrorDispatcher err) {
        this.loader = loader;
        this.errDispatcher = err;
        this.beanTypes = new HashMap<String, String>();
    }

    public void addBean(Node.UseBean n, String s, String type, String scope) throws JasperException {
        if (scope == null || scope.equals("page") || scope.equals("request") || scope.equals("session") || scope.equals("application")) {
            this.beanTypes.put(s, type);
        } else {
            this.errDispatcher.jspError((Node)n, "jsp.error.invalid.scope", scope);
        }
    }

    public Class<?> getBeanType(String bean) throws JasperException {
        try {
            return this.loader.loadClass(this.beanTypes.get(bean));
        }
        catch (ClassNotFoundException ex) {
            throw new JasperException(ex);
        }
    }

    public boolean checkVariable(String bean) {
        return this.beanTypes.containsKey(bean);
    }
}

