/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;

@Service(name="_get-host-and-port")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="host-port", description="HostPort")})
public class GetHostAndPortCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    @Param(optional=true)
    public String target = "server";
    @Param(optional=true)
    public String virtualServer = null;
    @Param(optional=true, defaultValue="false")
    public Boolean securityEnabled = false;
    @Param(optional=true)
    public String moduleId = null;
    @Inject
    Configs configs;
    @Inject
    Domain domain;
    private Config config;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(GetHostAndPortCommand.class);

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        String configName = null;
        Server server = this.domain.getServerNamed(this.target);
        if (server != null) {
            configName = server.getConfigRef();
        } else {
            Cluster cluster = this.domain.getClusterNamed(this.target);
            if (cluster != null) {
                configName = cluster.getConfigRef();
            }
        }
        this.config = this.configs.getConfigByName(configName);
        if (this.config != null) {
            accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)this.config), "read"));
        }
        return accessChecks;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        HttpService httpService = null;
        HostAndPort hostAndPort = null;
        try {
            if (this.config == null) {
                throw new Exception("No such target:" + this.target);
            }
            httpService = this.config.getHttpService();
            if (httpService != null) {
                hostAndPort = this.getHostAndPortForRequest(httpService);
            }
        }
        catch (Exception e) {
            report.setMessage(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (hostAndPort != null) {
            part.setMessage(hostAndPort.getHost() + ":" + hostAndPort.getPort());
            part.addProperty("host", hostAndPort.getHost());
            part.addProperty("port", "" + hostAndPort.getPort());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private HostAndPort getHostAndPortForRequest(HttpService httpService) throws Exception {
        if (this.moduleId == null) {
            if (this.virtualServer == null) {
                return this.getHostAndPort(httpService, this.securityEnabled);
            }
            VirtualServer vs = httpService.getVirtualServerByName(this.virtualServer);
            if (vs == null) {
                throw new Exception("Virtual server: " + this.virtualServer + " does not exist!");
            }
            return this.getHostAndPort(httpService, vs, this.securityEnabled);
        }
        ApplicationRef appRef = this.domain.getApplicationRefInTarget(this.moduleId, this.target);
        List vsList = null;
        if (appRef != null) {
            vsList = StringUtils.parseStringList((String)appRef.getVirtualServers(), (String)" ,");
        }
        if (vsList == null) {
            return this.getHostAndPort(httpService, this.securityEnabled);
        }
        for (String virtualServer : vsList) {
            HostAndPort hp = this.getHostAndPort(httpService, httpService.getVirtualServerByName(virtualServer), this.securityEnabled);
            if (hp == null) continue;
            return hp;
        }
        return null;
    }

    private HostAndPort getHostAndPort(HttpService httpService, VirtualServer vs, boolean securityEnabled) {
        List virtualServerList = httpService.getVirtualServer();
        List httpListenerList = ((Config)httpService.getParent(Config.class)).getNetworkConfig().getNetworkListeners().getNetworkListener();
        for (VirtualServer virtualServer : virtualServerList) {
            String vsHttpListeners;
            if (!virtualServer.getId().equals(vs.getId()) || (vsHttpListeners = virtualServer.getNetworkListeners()) == null) continue;
            List vsHttpListenerList = StringUtils.parseStringList((String)vsHttpListeners, (String)" ,");
            for (String vsHttpListener : vsHttpListenerList) {
                for (NetworkListener httpListener : httpListenerList) {
                    Protocol protocol;
                    if (!httpListener.getName().equals(vsHttpListener) || !Boolean.valueOf(httpListener.getEnabled()).booleanValue() || Boolean.valueOf((protocol = httpListener.findHttpProtocol()).getSecurityEnabled()) != securityEnabled) continue;
                    String serverName = protocol.getHttp().getServerName();
                    if (serverName == null || serverName.trim().equals("")) {
                        serverName = DeploymentCommandUtils.getLocalHostName();
                    }
                    String portStr = httpListener.getPort();
                    String redirPort = protocol.getHttp().getRedirectPort();
                    if (redirPort != null && !redirPort.trim().equals("")) {
                        portStr = redirPort;
                    }
                    int port = Integer.parseInt(portStr);
                    return new HostAndPort(serverName, port, securityEnabled);
                }
            }
        }
        return null;
    }

    private HostAndPort getHostAndPort(HttpService httpService, boolean securityEnabled) {
        List httpListenerList = ((Config)httpService.getParent(Config.class)).getNetworkConfig().getNetworkListeners().getNetworkListener();
        for (NetworkListener httpListener : httpListenerList) {
            Protocol protocol;
            Http http;
            if (!Boolean.valueOf(httpListener.getEnabled()).booleanValue() || (http = (protocol = httpListener.findHttpProtocol()).getHttp()).getDefaultVirtualServer().equals("__asadmin") || Boolean.valueOf(protocol.getSecurityEnabled()) != securityEnabled) continue;
            String serverName = http.getServerName();
            if (serverName == null || serverName.trim().equals("")) {
                serverName = DeploymentCommandUtils.getLocalHostName();
            }
            String portStr = httpListener.getPort();
            String redirPort = http.getRedirectPort();
            if (redirPort != null && !redirPort.trim().equals("")) {
                portStr = redirPort;
            }
            int port = Integer.parseInt(portStr);
            return new HostAndPort(serverName, port, securityEnabled);
        }
        return null;
    }
}

