/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.rotation;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

class LogFileArchiver {
    private static final System.Logger LOG = System.getLogger(LogFileArchiver.class.getName());
    private static final String GZIP_EXTENSION = ".gz";
    private final File mainLogFile;
    private final boolean compressOldLogFiles;
    private final int maxCountOfOldLogFiles;

    LogFileArchiver(File mainLogFile, boolean compressOldLogFiles, int maxCountOfOldLogFiles) {
        this.mainLogFile = mainLogFile;
        this.compressOldLogFiles = compressOldLogFiles;
        this.maxCountOfOldLogFiles = maxCountOfOldLogFiles;
    }

    File getGzArchiveFile(File rotatedFile) {
        return new File(rotatedFile.getParentFile(), rotatedFile.getName() + GZIP_EXTENSION);
    }

    void archive(File archivedFile) {
        Runnable cleanup = () -> this.cleanUpHistoryLogFiles(archivedFile);
        new Thread(cleanup, "old-log-files-cleanup-" + this.mainLogFile.getName()).start();
    }

    private synchronized void cleanUpHistoryLogFiles(File rotatedFile) {
        if (this.compressOldLogFiles) {
            this.compressFile(rotatedFile);
        }
        this.deleteOldLogFiles();
    }

    private void compressFile(File rotatedFile) {
        long start = System.currentTimeMillis();
        File outFile = this.getGzArchiveFile(rotatedFile);
        boolean compressed = this.gzipFile(rotatedFile, outFile);
        if (!compressed) {
            this.logError("Could not compress log file: " + rotatedFile.getAbsolutePath());
            return;
        }
        long time = System.currentTimeMillis() - start;
        LOG.log(System.Logger.Level.INFO, "File {0} of size {1} has been archived to file {2} of size {3} in {4} ms", rotatedFile, rotatedFile.length(), outFile, outFile.length(), time);
        boolean deleted = rotatedFile.delete();
        if (!deleted) {
            this.logError("Could not delete uncompressed log file: " + rotatedFile.getAbsolutePath());
        }
    }

    /*
     * Exception decompiling
     */
    private boolean gzipFile(File inputFile, File outputFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteOldLogFiles() {
        if (this.maxCountOfOldLogFiles == 0) {
            return;
        }
        File dir = this.mainLogFile.getParentFile();
        String logFileName = this.mainLogFile.getName();
        if (dir == null) {
            return;
        }
        FileFilter filter = f -> f.isFile() && !f.getName().equals(logFileName) && f.getName().startsWith(logFileName);
        Arrays.stream(dir.listFiles(filter)).sorted(Comparator.comparing(File::getName).reversed()).skip(this.maxCountOfOldLogFiles).forEach(this::deleteFile);
    }

    private void deleteFile(File file) {
        boolean delFile = file.delete();
        if (!delFile) {
            this.logError("Could not delete the log file: " + file);
        }
    }

    private void logError(String message) {
        GlassFishLoggingTracer.error(this.getClass(), message);
        LOG.log(System.Logger.Level.ERROR, message);
    }
}

