/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Properties;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;

public class Launcher {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private volatile GlassFish gf;
    private volatile GlassFishRuntime gfr;

    public void launch(Properties properties) throws Exception {
        this.addShutdownHook();
        this.gfr = GlassFishRuntime.bootstrap((BootstrapProperties)new BootstrapProperties(properties), (ClassLoader)this.getClass().getClassLoader());
        this.gf = this.gfr.newGlassFish(new GlassFishProperties(properties));
        if (Boolean.parseBoolean(Launcher.getPropertyOrSystemProperty(properties, "GlassFish_Interactive", "false"))) {
            this.startConsole();
        } else {
            this.gf.start();
        }
    }

    private void startConsole() throws IOException {
        String command;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        while ((command = this.readCommand(reader)) != null) {
            try {
                Deployer deployer;
                STDOUT.println("command = " + command);
                if ("start".equalsIgnoreCase(command)) {
                    if (this.gf.getStatus() != GlassFish.Status.STARTED || this.gf.getStatus() == GlassFish.Status.STOPPING || this.gf.getStatus() == GlassFish.Status.STARTING) {
                        this.gf.start();
                        continue;
                    }
                    STDOUT.println("Already started or stopping or starting");
                    continue;
                }
                if ("stop".equalsIgnoreCase(command)) {
                    if (this.gf.getStatus() != GlassFish.Status.STARTED) {
                        STDOUT.println("GlassFish is not started yet. Please execute start first.");
                        continue;
                    }
                    this.gf.stop();
                    continue;
                }
                if (command.startsWith("deploy")) {
                    if (this.gf.getStatus() != GlassFish.Status.STARTED) {
                        STDOUT.println("GlassFish is not started yet. Please execute start first.");
                        continue;
                    }
                    deployer = (Deployer)this.gf.getService(Deployer.class, null);
                    String[] tokens = command.split("\\s");
                    if (tokens.length < 2) {
                        STDOUT.println("Syntax: deploy <options> file");
                        continue;
                    }
                    URI uri = URI.create(tokens[tokens.length - 1]);
                    String[] params = Arrays.copyOfRange(tokens, 1, tokens.length - 1);
                    String name = deployer.deploy(uri, params);
                    STDOUT.println("Deployed = " + name);
                    continue;
                }
                if (command.startsWith("undeploy")) {
                    if (this.gf.getStatus() != GlassFish.Status.STARTED) {
                        STDOUT.println("GlassFish is not started yet. Please execute start first.");
                        continue;
                    }
                    deployer = (Deployer)this.gf.getService(Deployer.class, null);
                    String name = command.substring(command.indexOf(32)).trim();
                    deployer.undeploy(name, new String[0]);
                    STDOUT.println("Undeployed = " + name);
                    continue;
                }
                if ("quit".equalsIgnoreCase(command)) {
                    System.exit(0);
                    continue;
                }
                if (this.gf.getStatus() != GlassFish.Status.STARTED) {
                    STDOUT.println("GlassFish is not started yet. Please execute start first.");
                    continue;
                }
                CommandRunner cmdRunner = this.gf.getCommandRunner();
                this.runCommand(cmdRunner, command);
            }
            catch (Exception e) {
                e.printStackTrace(STDERR);
            }
        }
    }

    private String readCommand(BufferedReader reader) throws IOException {
        this.prompt();
        String command = null;
        while ((command = reader.readLine()) != null && command.isEmpty()) {
        }
        return command;
    }

    private void prompt() {
        STDOUT.print("Enter any of the following commands: start, stop, quit, deploy <path to file>, undeploy <name of app>\nglassfish$ ");
        STDOUT.flush();
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread("GlassFish Shutdown Hook"){

            @Override
            public void run() {
                try {
                    if (Launcher.this.gfr != null) {
                        Launcher.this.gfr.shutdown();
                    }
                }
                catch (Exception ex) {
                    STDERR.println("Error stopping framework: " + ex);
                    ex.printStackTrace(STDERR);
                }
            }
        });
    }

    private void runCommand(CommandRunner cmdRunner, String command) throws GlassFishException {
        String[] tokens = command.split("\\s");
        CommandResult result = cmdRunner.run(tokens[0], Arrays.copyOfRange(tokens, 1, tokens.length));
        System.out.println(result.getExitStatus());
        System.out.println(result.getOutput());
        if (result.getFailureCause() != null) {
            result.getFailureCause().printStackTrace(STDERR);
        }
    }

    private static String getPropertyOrSystemProperty(Properties properties, String name, String defaultValue) {
        String value = properties.getProperty(name);
        return value == null ? System.getProperty(name, defaultValue) : value;
    }
}

