/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionBindingEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.util.Enumeration;
import org.apache.catalina.Manager;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.StandardSession;
import org.glassfish.web.ha.session.management.HASession;
import org.glassfish.web.ha.session.management.ReplicationManagerBase;

public abstract class BaseHASession
extends StandardSession
implements HASession {
    protected String userName = "";
    protected boolean persistentFlag = false;

    public BaseHASession(Manager manager) {
        super(manager);
    }

    public void setId(String id) {
        super.setId(id);
        ReplicationManagerBase manager = (ReplicationManagerBase)this.getManager();
        String jReplicaValue = manager.getReplicaFromPredictor(id, null);
        if (jReplicaValue != null) {
            this.setNote("com.sun.enterprise.http.jreplicaLocation", jReplicaValue);
        }
    }

    @Override
    public abstract boolean isDirty();

    @Override
    public abstract void setDirty(boolean var1);

    @Override
    public boolean isPersistent() {
        return this.persistentFlag;
    }

    @Override
    public void setPersistent(boolean value) {
        this.persistentFlag = value;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String value) {
        this.userName = value;
    }

    public void setPrincipal(Principal principal) {
        super.setPrincipal(principal);
        this.setDirty(true);
    }

    public boolean isPersistentFlag() {
        return this.persistentFlag;
    }

    public void recycle() {
        super.recycle();
        this.userName = "";
        this.ssoId = "";
        this.persistentFlag = false;
    }

    public void save() {
        ReplicationManagerBase manager = (ReplicationManagerBase)this.getManager();
        if (manager != null) {
            manager.doValveSave(this);
        }
    }

    @Override
    public void sync() {
        HttpSessionBindingEvent event = null;
        event = new HttpSessionBindingEvent((HttpSession)((Object)this), null, null);
        Manager manager = this.getManager();
        StandardContext stdContext = (StandardContext)manager.getContainer();
        stdContext.fireContainerEvent("sessionSync", (Object)event);
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.userName = (String)stream.readObject();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.userName);
    }

    public String superToString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("BaseHASession[");
        sb.append(this.id);
        sb.append("]");
        sb.append("\n");
        sb.append("isValid:" + this.isValid);
        if (this.isValid) {
            Enumeration attrNamesEnum = this.getAttributeNames();
            while (attrNamesEnum.hasMoreElements()) {
                String nextAttrName = (String)attrNamesEnum.nextElement();
                Object nextAttrValue = this.getAttributeInternal(nextAttrName);
                sb.append("\n");
                sb.append("attrName = " + nextAttrName);
                sb.append(" : attrValue = " + String.valueOf(nextAttrValue));
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append(this.superToString());
        sb.append(" ssoid: " + this.getSsoId());
        sb.append(" userName: " + this.getUserName());
        sb.append(" version: " + this.getVersion());
        sb.append(" persistent: " + this.isPersistent());
        return sb.toString();
    }
}

