/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.JMSConnectionFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.ResourcePropertyNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JMSConnectionFactoryDefinitionNode
extends DeploymentDescriptorNode<JMSConnectionFactoryDefinitionDescriptor> {
    @LogMessageInfo(message="For jms-connection-factory resource: {0}, there is no application part in its resource adapter name: {1}.", level="WARNING", cause="For embedded resource adapter, its internal format of resource adapter name should contains application name.", comment="For the method writeDescriptor of com.sun.enterprise.deployment.node.JMSConnectionFactoryDefinitionNode.")
    private static final String RESOURCE_ADAPTER_NAME_INVALID = "AS-DEPLOYMENT-00024";
    private JMSConnectionFactoryDefinitionDescriptor descriptor;

    public JMSConnectionFactoryDefinitionNode() {
        this.registerElementHandler(new XMLElement("property"), ResourcePropertyNode.class, "addJMSConnectionFactoryPropertyDescriptor");
    }

    @Override
    public JMSConnectionFactoryDefinitionDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new JMSConnectionFactoryDefinitionDescriptor();
        }
        return this.descriptor;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("description", "setDescription");
        table.put("name", "setName");
        table.put("interface-name", "setInterfaceName");
        table.put("class-name", "setClassName");
        table.put("resource-adapter", "setResourceAdapter");
        table.put("user", "setUser");
        table.put("password", "setPassword");
        table.put("client-id", "setClientId");
        table.put("transactional", "setTransactional");
        table.put("max-pool-size", "setMaxPoolSize");
        table.put("min-pool-size", "setMinPoolSize");
        return table;
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, JMSConnectionFactoryDefinitionDescriptor desc) {
        Element node = JMSConnectionFactoryDefinitionNode.appendChild(parent, nodeName);
        JMSConnectionFactoryDefinitionNode.appendTextChild((Node)node, "description", desc.getDescription());
        JMSConnectionFactoryDefinitionNode.appendTextChild((Node)node, "name", desc.getName());
        JMSConnectionFactoryDefinitionNode.appendTextChild((Node)node, "interface-name", desc.getInterfaceName());
        JMSConnectionFactoryDefinitionNode.appendTextChild((Node)node, "class-name", desc.getClassName());
        String resourceAdapter = desc.getResourceAdapter();
        if (resourceAdapter != null) {
            int poundIndex = resourceAdapter.indexOf("#");
            if (poundIndex > 0) {
                resourceAdapter = resourceAdapter.substring(poundIndex);
            } else if (poundIndex == 0) {
                DOLUtils.getDefaultLogger().log(Level.WARNING, RESOURCE_ADAPTER_NAME_INVALID, new Object[]{desc.getName(), desc.getResourceAdapter()});
            }
        }
        JMSConnectionFactoryDefinitionNode.appendTextChild((Node)node, "resource-adapter", resourceAdapter);
        JMSConnectionFactoryDefinitionNode.appendTextChild((Node)node, "user", desc.getUser());
        JMSConnectionFactoryDefinitionNode.appendTextChild((Node)node, "password", desc.getPassword());
        JMSConnectionFactoryDefinitionNode.appendTextChild((Node)node, "client-id", desc.getClientId());
        ResourcePropertyNode.write(node, desc);
        JMSConnectionFactoryDefinitionNode.appendTextChild((Node)node, "transactional", String.valueOf(desc.isTransactional()));
        JMSConnectionFactoryDefinitionNode.appendTextChild((Node)node, "max-pool-size", desc.getMaxPoolSize());
        JMSConnectionFactoryDefinitionNode.appendTextChild((Node)node, "min-pool-size", desc.getMinPoolSize());
        return node;
    }
}

