/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BaseAttribute;
import org.netbeans.modules.schema2beans.BaseProperty;
import org.netbeans.modules.schema2beans.Bean;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDFactory;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.DOMBinding;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansNestedException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.Schema2BeansUtil;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beans.Version;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public abstract class BaseBean
implements Cloneable,
Bean {
    protected DOMBinding binding;
    protected GraphManager graphManager;
    private Map propByName;
    private Map propByOrder;
    private HashMap attrCache;
    private ArrayList comparators;
    private boolean isRoot;
    private int propertyOrder;
    private String defaultNamespace;
    public static final int MERGE_NONE = 0;
    public static final int MERGE_INTERSECT = 1;
    public static final int MERGE_UNION = 2;
    public static final int MERGE_UPDATE = 3;
    public static final int MERGE_COMPARE = 4;
    PropertyChangeSupport changeListeners;

    public BaseBean(Vector comps, Version version) {
        this.init(comps, version);
    }

    protected void init(Vector comps, Version version) {
        if (version.getMajor() < 3) {
            this.initPropertyTables(13);
        }
        this.comparators = new ArrayList(2);
        this.isRoot = false;
        this.propertyOrder = 0;
        this.attrCache = null;
        if (comps == null || comps.size() == 0) {
            this.comparators.add(new BeanComparator());
        } else {
            int size = comps.size();
            for (int i = 0; i < size; ++i) {
                this.comparators.add(comps.get(i));
            }
        }
    }

    protected void initPropertyTables(int propertyCount) {
        int hashTableSize = propertyCount * 2;
        this.propByName = new HashMap(hashTableSize, 1.0f);
        this.propByOrder = new HashMap(hashTableSize, 1.0f);
    }

    public synchronized void addBeanComparator(BeanComparator cmp) {
        if (cmp != null) {
            this.comparators.add(cmp);
        }
    }

    public synchronized void removeBeanComparator(BeanComparator cmp) {
        int i = this.comparators.indexOf(cmp);
        if (i != -1) {
            this.comparators.remove(i);
        }
    }

    public void createProperty(String dtdName, String beanName, Class type) {
        int o = 16;
        o = type.isInstance(String.class) ? (o |= 0x100) : (o |= 0x200);
        this.createProperty(dtdName, beanName, o, type);
    }

    public void createRoot(String dtdName, String beanName, int option, Class type) throws Schema2BeansRuntimeException {
        BeanProp prop = new BeanProp(this, dtdName, beanName, option, type, true);
        try {
            this.graphManager.createRootBinding(this, prop, null);
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException(e);
        }
        this.isRoot = true;
    }

    public void createProperty(String dtdName, String beanName, int option, Class type) throws Schema2BeansRuntimeException {
        ++this.propertyOrder;
        BeanProp prop = new BeanProp(this, dtdName, beanName, option, type);
        prop.setOrder(this.propertyOrder);
        BeanProp obj1 = this.propByName.put(beanName, prop);
        this.propByOrder.put(String.valueOf(this.propertyOrder), prop);
        if (obj1 != null) {
            throw new Schema2BeansRuntimeException(Common.getMessage("DuplicateProperties_msg"));
        }
        prop.initialize();
    }

    public void setDefaultNamespace(String namespace) {
        this.defaultNamespace = namespace;
        this.createAttribute("xmlns", "xmlns", 513, null, namespace);
        this.setAttributeValue("xmlns", namespace);
        if (this.beanProp().getAttrProp("xsi:schemaLocation", true) == null) {
            this.createAttribute("xmlns:xsi", "xmlns:xsi", 513, null, null);
            this.createAttribute("xsi:schemaLocation", "xsi:schemaLocation", 513, null, null);
        }
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public BeanProp[] beanProps() {
        int size = this.propByOrder.size();
        BeanProp[] ret = new BeanProp[size];
        for (int i = 1; i <= size; ++i) {
            ret[i - 1] = (BeanProp)this.propByOrder.get(String.valueOf(i));
        }
        return ret;
    }

    protected Iterator beanPropsIterator() {
        return this.propByName.values().iterator();
    }

    @Override
    public BeanProp beanProp(String name) {
        String beanName;
        BeanProp prop = (BeanProp)this.propByName.get(name);
        if (prop == null && (prop = (BeanProp)this.propByName.get(beanName = Common.convertName(name))) == null) {
            throw new IllegalArgumentException(Common.getMessage("BeanPropertyDoesntExist_msg", this.getClass().getName(), name));
        }
        return prop;
    }

    public BeanProp beanProp(int order) {
        return (BeanProp)this.propByOrder.get(String.valueOf(order));
    }

    @Override
    public Object getValue(String name) {
        return this.beanProp(name).getValue(0);
    }

    @Override
    public Object getValue(String name, int index) {
        return this.beanProp(name).getValue(index);
    }

    @Override
    public Object getValueById(String name, int id) {
        return this.beanProp(name).getValueById(id);
    }

    @Override
    public int idToIndex(String name, int id) {
        return this.beanProp(name).idToIndex(id);
    }

    @Override
    public int indexToId(String name, int index) {
        return this.beanProp(name).indexToId(index);
    }

    public boolean isNull(String name) {
        return this.getValue(name) == null;
    }

    public boolean isNull(String name, int index) {
        return this.getValue(name, index) == null;
    }

    @Override
    public Object[] getValues(String name) {
        return this.beanProp(name).getValues();
    }

    @Override
    public void setValue(String name, Object value) {
        this.setValue(this.beanProp(name), 0, value);
    }

    @Override
    public void setValue(String name, int index, Object value) {
        this.setValue(this.beanProp(name), index, value);
    }

    protected void setValue(BeanProp prop, int index, Object value) {
        prop.setValue(index, value);
    }

    protected int addValue(BeanProp prop, Object value) {
        return prop.addValue(value);
    }

    protected int removeValue(BeanProp prop, Object value) {
        return prop.removeValue(value);
    }

    protected void removeValue(BeanProp prop, int index) {
        prop.removeValue(index);
    }

    @Override
    public void setValueById(String name, int id, Object value) {
        BeanProp bp = this.beanProp(name);
        int index = bp.idToIndex(id);
        bp.setValue(index, value);
    }

    public void setValue(String name, Object[] value) {
        this.beanProp(name).setValue(value);
    }

    @Override
    public int addValue(String name, Object value) {
        return this.addValue(this.beanProp(name), value);
    }

    @Override
    public int removeValue(String name, Object value) {
        return this.removeValue(this.beanProp(name), value);
    }

    public void removeValue(String name, int index) {
        this.removeValue(this.beanProp(name), index);
    }

    public int indexOf(String name, Object value) throws Schema2BeansRuntimeException {
        BeanProp bp = this.beanProp(name);
        if (bp == null) {
            throw new Schema2BeansRuntimeException(Common.getMessage("UnknownPropertyName_msg", name));
        }
        if (Common.isArray(bp.type)) {
            boolean isBean = Common.isBean(bp.type);
            int size = bp.size();
            for (int i = 0; i < size; ++i) {
                Object obj = bp.getValue(i);
                if (isBean && obj == value) {
                    return i;
                }
                if (isBean || !obj.equals(value)) continue;
                return i;
            }
        }
        return -1;
    }

    public int size(String name) {
        return this.beanProp(name).size();
    }

    public boolean isChoiceProperty(String name) {
        return this.beanProp(name).isChoiceProperty();
    }

    public boolean isChoiceProperty() {
        return this.beanProp().isChoiceProperty();
    }

    public BaseProperty[] listChoiceProperties(String name) {
        return this.beanProp(name).getChoiceProperties();
    }

    public Iterator listChoiceProperties() {
        IterateChoiceProperties it = new IterateChoiceProperties();
        Iterator i = this.beanPropsIterator();
        while (i.hasNext()) {
            it.add((BeanProp)i.next());
        }
        return it;
    }

    @Override
    public BaseProperty[] listProperties() {
        return this.beanProps();
    }

    @Override
    public BaseProperty getProperty() {
        return this.beanProp();
    }

    @Override
    public BaseProperty getProperty(String propName) {
        return this.beanProp(propName);
    }

    public Object[] knownValues(String name) {
        return this.beanProp(name).knownValues();
    }

    protected void addKnownValue(String name, Object value) {
        this.beanProp(name).addKnownValue(value);
    }

    public void createAttribute(String dtdName, String name, int type, String[] values, String defValue) {
        BeanProp bp = this.beanProp();
        if (bp != null) {
            bp.createAttribute(dtdName, name, type, values, defValue);
        } else {
            System.out.println(Common.getMessage("beanPropIsNull_msg", name));
        }
    }

    public void createAttribute(String propName, String dtdName, String name, int type, String[] values, String defValue) {
        this.beanProp(propName).createAttribute(dtdName, name, type, values, defValue);
    }

    public void setAttributeValue(String propName, String name, String value) {
        this.beanProp(propName).setAttributeValue(0, name, value);
    }

    public void setAttributeValue(String name, String value) {
        if (name == null) {
            return;
        }
        BeanProp bp = this.beanProp();
        if (bp != null) {
            int i = bp.idToIndex(this.binding.getId());
            bp.setAttributeValue(i, name, value);
        } else {
            if (this.attrCache == null) {
                this.attrCache = new HashMap();
            }
            this.attrCache.put(name, value);
        }
    }

    String[] cachedAttributeNames() {
        int size = this.attrCache == null ? 0 : this.attrCache.size();
        String[] ret = new String[size];
        if (size > 0) {
            Iterator it = this.attrCache.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                ret[i++] = it.next().toString();
            }
        }
        return ret;
    }

    String cachedAttributeValue(String name) {
        if (this.attrCache != null) {
            return (String)this.attrCache.get(name);
        }
        return null;
    }

    void cachedAttributeClear() {
        this.attrCache = null;
    }

    public String getAttributeValue(String name) {
        BeanProp bp = this.beanProp();
        if (bp != null) {
            int i = bp.idToIndex(this.binding.getId());
            if (i < 0) {
                return null;
            }
            return bp.getAttributeValue(i, name);
        }
        if (this.attrCache != null) {
            return (String)this.attrCache.get(name);
        }
        return null;
    }

    public String getAttributeValue(String propName, String name) {
        return this.beanProp(propName).getAttributeValue(0, name);
    }

    public void setAttributeValue(String propName, int index, String name, String value) {
        this.beanProp(propName).setAttributeValue(index, name, value);
    }

    public String getAttributeValue(String propName, int index, String name) {
        return this.beanProp(propName).getAttributeValue(index, name);
    }

    public String[] getAttributeNames(String propName) {
        return this.beanProp(propName).getAttributeNames();
    }

    public String[] getAttributeNames() {
        BeanProp bp = this.beanProp();
        if (bp != null) {
            return bp.getAttributeNames();
        }
        return null;
    }

    public BaseAttribute[] listAttributes(String propName) {
        return this.beanProp(propName).getAttributes();
    }

    public BaseAttribute[] listAttributes() {
        BeanProp bp = this.beanProp();
        if (bp != null) {
            return bp.getAttributes();
        }
        return null;
    }

    private void lookForAttribute(ArrayList found, BeanProp bp, BaseBean bean, BaseAttribute[] attrs, String attrName, Object value) {
        for (int j = 0; j < attrs.length; ++j) {
            if (attrName != null && !attrs[j].hasName(attrName)) continue;
            String name = attrs[j].getName();
            if (DDLogFlags.debug) {
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 7, bp.getName() + "." + name + " for value " + value);
            }
            int size = bp.size();
            if (bp.isIndexed()) {
                for (int k = 0; k < size; ++k) {
                    String v = bp.getAttributeValue(k, name);
                    v = (String)Common.getComparableObject(v);
                    if (DDLogFlags.debug) {
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 8, bp.getName() + "." + name + " = " + v);
                    }
                    if (bean != null && bean != bp.getValue(k) || !value.equals(v)) continue;
                    if (DDLogFlags.debug) {
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 9);
                    }
                    found.add(bp.buildFullName(k, name));
                }
                continue;
            }
            String v = bp.getAttributeValue(0, name);
            v = (String)Common.getComparableObject(v);
            if (DDLogFlags.debug) {
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 8, bp.getName() + "." + name + " = " + v);
            }
            if (!value.equals(v)) continue;
            if (DDLogFlags.debug) {
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 9);
            }
            found.add(bp.buildFullName(0, name));
        }
    }

    void find(BaseBean bean, ArrayList found, String propName, String attrName, Object value) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 6, (bean == null ? "<null>" : bean.getClass().getName()) + " - " + propName + "/" + attrName + " for value " + (value == null ? "<null>" : value.toString()));
        }
        if (bean == null || value == null) {
            return;
        }
        BaseProperty[] props = bean.listProperties();
        BaseAttribute[] attrs = bean.listAttributes();
        if (propName == null && attrs != null && attrs.length > 0) {
            BeanProp bp = bean.beanProp();
            this.lookForAttribute(found, bp, bean, attrs, attrName, value);
        }
        for (int i = 0; i < props.length; ++i) {
            BaseProperty p = props[i];
            String name = p.getName();
            BeanProp bp = (BeanProp)p;
            int size = p.size();
            if (!p.isBean()) {
                if (propName != null && p.hasName(propName) || propName == null && attrName == null) {
                    if (DDLogFlags.debug) {
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 10, name + " for value " + value);
                    }
                    if (p.isIndexed()) {
                        for (int j = 0; j < size; ++j) {
                            Object v = bp.getValue(j);
                            v = Common.getComparableObject(v);
                            if (DDLogFlags.debug) {
                                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 8, name + "[" + j + "] = " + v.toString());
                            }
                            if (!value.equals(v)) continue;
                            if (DDLogFlags.debug) {
                                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 11);
                            }
                            found.add(bp.getFullName(j));
                        }
                    } else {
                        Object v = bp.getValue(0);
                        v = Common.getComparableObject(v);
                        if (DDLogFlags.debug) {
                            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 8, name + " = " + (v == null ? "null" : v.toString()));
                        }
                        if (value.equals(v)) {
                            if (DDLogFlags.debug) {
                                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 11);
                            }
                            found.add(bp.getFullName());
                        }
                    }
                }
                attrs = p.getAttributes();
                if (propName == null && attrs.length > 0) {
                    this.lookForAttribute(found, bp, null, attrs, attrName, value);
                }
            }
            if (p.isBean() && p.isIndexed()) {
                BaseBean[] ba = (BaseBean[])bean.getValues(name);
                for (int k = 0; k < ba.length; ++k) {
                    this.find(ba[k], found, propName, attrName, value);
                }
                continue;
            }
            if (!p.isBean()) continue;
            BaseBean b = (BaseBean)bean.getValue(name);
            this.find(b, found, propName, attrName, value);
        }
    }

    public String[] findAttributeValue(String attrName, String value) {
        ArrayList list = new ArrayList();
        this.find(this, list, null, attrName, value);
        String[] ret = new String[list.size()];
        return list.toArray(ret);
    }

    public String[] findPropertyValue(String propName, Object value) {
        ArrayList list = new ArrayList();
        this.find(this, list, propName, null, value);
        String[] ret = new String[list.size()];
        return list.toArray(ret);
    }

    public String[] findValue(Object value) {
        ArrayList list = new ArrayList();
        this.find(this, list, null, null, value);
        String[] ret = new String[list.size()];
        return list.toArray(ret);
    }

    public void write(File f) throws IOException, Schema2BeansRuntimeException {
        FileOutputStream out = new FileOutputStream(f);
        try {
            this.write(out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public void write(OutputStream out) throws IOException, Schema2BeansRuntimeException {
        try {
            this.reindent();
            if (this.graphManager == null) {
                throw new IllegalStateException(Common.getMessage("CantWriteBeanNotInDOMTree_msg"));
            }
            this.graphManager.write(out);
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException(e);
        }
    }

    public void write(OutputStream out, String encoding) throws IOException, Schema2BeansException {
        this.reindent();
        if (this.graphManager == null) {
            throw new IllegalStateException(Common.getMessage("CantWriteBeanNotInDOMTree_msg"));
        }
        this.graphManager.write(out, encoding);
    }

    public void write(Writer w) throws IOException, Schema2BeansException {
        this.write(w, null);
    }

    public void write(Writer w, String encoding) throws IOException, Schema2BeansException {
        this.reindent();
        if (this.graphManager == null) {
            throw new IllegalStateException(Common.getMessage("CantWriteBeanNotInDOMTree_msg"));
        }
        this.graphManager.write(w, encoding);
    }

    public void writeNoReindent(OutputStream out) throws IOException, Schema2BeansException {
        if (this.graphManager == null) {
            throw new IllegalStateException(Common.getMessage("CantWriteBeanNotInDOMTree_msg"));
        }
        this.graphManager.write(out);
    }

    public void writeNode(Writer out) throws IOException {
        if (this.graphManager == null) {
            throw new IllegalStateException(Common.getMessage("CantWriteBeanNotInDOMTree_msg"));
        }
        Node myNode = this.binding.getNode();
        try {
            this.graphManager.write(out, myNode);
        }
        catch (Schema2BeansException e) {
            throw new RuntimeException(e);
        }
    }

    public void reindent() {
        this.reindent("  ");
    }

    public void reindent(String indent) {
        if (this.graphManager == null) {
            throw new IllegalStateException(Common.getMessage("CantWriteBeanNotInDOMTree_msg"));
        }
        this.graphManager.reindent(indent);
    }

    protected boolean hasDomNode() {
        if (this.binding == null) {
            return false;
        }
        return this.binding.hasDomNode();
    }

    protected DOMBinding domBinding() {
        return this.binding;
    }

    protected void setDomBinding(DOMBinding binding) {
        this.binding = binding;
    }

    public GraphManager graphManager() {
        return this.graphManager;
    }

    protected void setGraphManager(GraphManager graphMgr) {
        this.graphManager = graphMgr;
        if (this.changeListeners != null) {
            // empty if block
        }
    }

    void syncNodes(BeanProp.Action a) {
        Iterator i = this.beanPropsIterator();
        while (i.hasNext()) {
            BeanProp prop = (BeanProp)i.next();
            if (prop == null) continue;
            prop.syncNodes(a);
        }
    }

    protected void buildPathName(StringBuffer str) {
        BeanProp p;
        if (this.binding != null && (p = this.binding.getBeanProp(this)) != null) {
            p.buildPathName(this.binding, str);
        }
    }

    void notifyInternal(BeanProp.InternalEvent ie) {
        BeanProp p;
        if (this.changeListeners != null && ie.type == 1) {
            boolean addedGM = false;
            if (this.graphManager == null) {
                this.graphManager = new GraphManager(this);
                addedGM = true;
            }
            this.changeListeners.firePropertyChange(ie.getPropertyChangeEvent());
            if (addedGM) {
                this.graphManager = null;
            }
        }
        if (this.binding != null && (p = this.binding.getBeanProp(this)) != null) {
            p.notifyInternal(ie, true);
        }
    }

    public Object clone() {
        String[] attrs;
        BaseBean bean = null;
        try {
            bean = (BaseBean)this.getClass().newInstance();
        }
        catch (Exception e) {
            TraceLogger.error(e);
            throw new Schema2BeansRuntimeException(Common.getMessage("CantInstantiateBean_msg", e.getMessage()));
        }
        if (this.graphManager != null && this.graphManager.root == this) {
            BeanProp p = this.binding.getBeanProp(this);
            String dtdName = p.getDtdName();
            String beanName = p.getDtdName();
            Class beanClass = p.getPropClass();
            Node n = GraphManager.createRootElementNode(dtdName);
            bean.graphManager.setXmlDocument(n);
            n = GraphManager.getElementNode(dtdName, n);
            bean.graphManager.completeRootBinding(bean, n);
        }
        if ((attrs = this.getAttributeNames()) != null) {
            for (int j = 0; j < attrs.length; ++j) {
                String a = attrs[j];
                if (this.beanProp().getAttrProp(a).isFixed()) continue;
                String v = this.getAttributeValue(a);
                if (bean.getAttributeValue(a) == v) continue;
                bean.setAttributeValue(a, v);
            }
        }
        if (this.attrCache != null) {
            bean.attrCache = (HashMap)this.attrCache.clone();
        }
        Iterator it = this.beanPropsIterator();
        while (it.hasNext()) {
            BeanProp prop = (BeanProp)it.next();
            if (prop == null) continue;
            String name = prop.getBeanName();
            if (Common.isArray(prop.type)) {
                int i;
                int size = prop.size();
                if (Common.isBean(prop.type)) {
                    for (i = 0; i < size; ++i) {
                        BaseBean b = (BaseBean)prop.getValue(i);
                        if (b != null) {
                            b = (BaseBean)b.clone();
                        }
                        bean.addValue(name, (Object)b);
                    }
                    continue;
                }
                for (i = 0; i < size; ++i) {
                    bean.addValue(name, prop.getValue(i));
                }
                attrs = prop.getAttributeNames();
                for (int j = 0; j < attrs.length; ++j) {
                    String a = attrs[j];
                    if (prop.getAttrProp(a).isFixed()) continue;
                    for (int i2 = 0; i2 < size; ++i2) {
                        String v = prop.getAttributeValue(i2, a);
                        if (bean.getAttributeValue(name, i2, a) == v) continue;
                        bean.setAttributeValue(name, i2, a, v);
                    }
                }
                continue;
            }
            if (Common.isBean(prop.type)) {
                BaseBean b = (BaseBean)prop.getValue(0);
                if (b != null) {
                    b = (BaseBean)b.clone();
                }
                bean.setValue(name, b);
                continue;
            }
            bean.setValue(name, prop.getValue(0));
            attrs = prop.getAttributeNames();
            for (int j = 0; j < attrs.length; ++j) {
                String a = attrs[j];
                if (prop.getAttrProp(a).isFixed()) continue;
                String v = prop.getAttributeValue(0, a);
                if (bean.getAttributeValue(name, 0, a) == v) continue;
                bean.setAttributeValue(name, a, v);
            }
        }
        return bean;
    }

    static String mergeModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "MERGE_NONE";
            }
            case 1: {
                return "MERGE_INTERSECT";
            }
            case 2: {
                return "MERGE_UNION";
            }
            case 3: {
                return "MERGE_UPDATE";
            }
            case 4: {
                return "MERGE_COMPARE";
            }
        }
        return "Unknown merge mode: " + mode;
    }

    public void merge(BaseBean bean, int mode) {
        if (mode == 3) {
            this.mergeUpdate(bean);
        } else {
            this.mergeTreeRoot(bean, mode);
        }
    }

    public void merge(BaseBean bean) {
        this.mergeUpdate(bean);
    }

    public void mergeUpdate(BaseBean sourceBean) {
        this.mergeTreeRoot(sourceBean, 3);
    }

    private boolean setHasKeyDefaultValue(BeanProp prop) {
        BeanComparator cmp = (BeanComparator)this.comparators.get(0);
        return cmp.hasKeyDefined(prop);
    }

    protected void copyProperty(BeanProp prop, BaseBean bean, int index, Object value) {
        boolean isArray = Common.isArray(prop.type);
        String name = prop.getName();
        if (value == null) {
            value = isArray ? bean.getValue(name, index) : bean.getValue(name, 0);
        }
        int newIndex = 0;
        if (isArray) {
            newIndex = this.addValue(prop, value);
        } else {
            this.setValue(prop, 0, value);
            index = 0;
        }
        this.copyAttributes(prop, newIndex, bean, index);
    }

    private void copyAttributes(BeanProp prop, int propIndex, BaseBean bean, int beanIndex) {
        String name = prop.getName();
        BaseAttribute[] ba = bean.listAttributes(name);
        if (ba != null) {
            for (int j = 0; j < ba.length; ++j) {
                String attrName;
                String v;
                if (ba[j].isFixed() || (v = bean.getAttributeValue(name, beanIndex, attrName = ba[j].getName())) == prop.getAttributeValue(propIndex, attrName)) continue;
                prop.setAttributeValue(propIndex, attrName, v);
            }
        }
    }

    synchronized boolean mergeTreeRoot(BaseBean bean, int mode) {
        return this.mergeTree(bean, mode);
    }

    private boolean mergeAttributes(BaseBean bean, int mode) {
        boolean result = true;
        BaseAttribute[] ba = bean.listAttributes();
        if (ba != null) {
            for (int j = 0; j < ba.length; ++j) {
                String otherValue;
                String attrName;
                String curValue;
                BaseAttribute baseAttribute = ba[j];
                if (baseAttribute.isFixed() || baseAttribute.isTransient() || (curValue = this.getAttributeValue(attrName = baseAttribute.getName())) == (otherValue = bean.getAttributeValue(attrName)) || curValue != null && otherValue != null && curValue.equals(otherValue)) continue;
                if ((mode & 4) == 4) {
                    return false;
                }
                if ((mode & 2) != 2) continue;
                this.setAttributeValue(attrName, otherValue);
            }
        }
        return result;
    }

    synchronized boolean mergeTree(BaseBean bean, int mode) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 1, this.getClass().getName() + "/" + (bean == null ? "<getAttributeValue(\"Id\")null>" : bean.getClass().getName()) + " - " + BaseBean.mergeModeToString(mode));
        }
        if (this.getClass().isInstance(bean)) {
            if (!this.mergeAttributes(bean, mode)) {
                return false;
            }
            Iterator it = this.beanPropsIterator();
            while (it.hasNext()) {
                Object o3;
                Object o2;
                Object o1;
                BeanProp prop = (BeanProp)it.next();
                if (prop == null) continue;
                String name = prop.getBeanName();
                boolean isArray = Common.isArray(prop.type);
                boolean isBean = Common.isBean(prop.type);
                boolean hasKey = false;
                boolean hasKeyDefined = false;
                if (isArray) {
                    int i;
                    int j = 0;
                    int size1 = prop.size();
                    int size2 = bean.size(name);
                    boolean[] toRemove = new boolean[size1];
                    boolean[] toAdd = new boolean[size2];
                    boolean[] compared = new boolean[size2];
                    Arrays.fill(toRemove, false);
                    Arrays.fill(toAdd, true);
                    Arrays.fill(compared, false);
                    if (DDLogFlags.debug) {
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 5, 2, this.getClass().getName() + "." + name + "[" + size1 + "] / " + bean.getClass().getName() + "." + name + "[" + size2 + "]");
                    }
                    for (i = 0; i < size1; ++i) {
                        o1 = prop.getValue(i);
                        if (isBean && o1 == null) continue;
                        boolean found = false;
                        block2: for (int c = 0; c < this.comparators.size() && !found; ++c) {
                            BeanComparator cmp = (BeanComparator)this.comparators.get(c);
                            for (j = 0; j < size2; ++j) {
                                if (compared[j]) continue;
                                o2 = bean.getValue(name, j);
                                if (isBean) {
                                    if (o2 == null) {
                                        compared[j] = true;
                                        toAdd[j] = false;
                                        continue;
                                    }
                                    o3 = cmp.compareBean(name, (BaseBean)o1, (BaseBean)o2);
                                    if (!hasKey) {
                                        hasKey = cmp.hasKey();
                                        hasKeyDefined = true;
                                    }
                                    if (o3 != o1) continue;
                                    boolean ret = ((BaseBean)o1).mergeTree((BaseBean)o2, mode);
                                    if (!ret) {
                                        return ret;
                                    }
                                    compared[j] = true;
                                    found = true;
                                    continue block2;
                                }
                                o3 = cmp.compareProperty(name, this, o1, i, bean, o2, j);
                                if (!hasKey) {
                                    hasKey = cmp.hasKey();
                                    hasKeyDefined = true;
                                }
                                if (o3 != o1) continue;
                                compared[j] = true;
                                found = true;
                                continue block2;
                            }
                        }
                        if (found) {
                            toAdd[j] = false;
                            if (!DDLogFlags.debug) continue;
                            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 5, 3, name + "[" + i + "] <=> " + name + "[" + j + "]");
                            continue;
                        }
                        toRemove[i] = true;
                        if (!DDLogFlags.debug) continue;
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 5, 4, name + "[" + i + "] to be removed");
                    }
                    if (!hasKeyDefined) {
                        hasKey = this.setHasKeyDefaultValue(prop);
                    }
                    if ((mode & 4) == 4) {
                        for (i = 0; i < size1; ++i) {
                            if (!toRemove[i] || !hasKey) continue;
                            return false;
                        }
                        for (j = 0; j < size2; ++j) {
                            if (!toAdd[j] || !hasKey) continue;
                            return false;
                        }
                    }
                    if ((mode & 1) == 1) {
                        j = 0;
                        for (i = 0; i < size1; ++i) {
                            if (!toRemove[i] || !hasKey) continue;
                            this.removeValue(prop, i - j);
                            ++j;
                        }
                    }
                    if ((mode & 2) != 2) continue;
                    for (j = 0; j < size2; ++j) {
                        if (!toAdd[j] || !hasKey) continue;
                        if (isBean) {
                            BaseBean srcBean = (BaseBean)bean.getValue(name, j);
                            o2 = srcBean.clone();
                            this.addValue(prop, o2);
                            ((BaseBean)o2).mergeTree(srcBean, mode);
                            continue;
                        }
                        this.copyProperty(prop, bean, j, null);
                    }
                    continue;
                }
                Object newValue = null;
                boolean found = false;
                if (DDLogFlags.debug) {
                    TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 5, 2, this.getClass().getName() + "." + name);
                }
                o1 = prop.getValue(0);
                o2 = bean.getValue(name);
                for (int c = 0; c < this.comparators.size() && !found; ++c) {
                    BeanComparator cmp = (BeanComparator)this.comparators.get(c);
                    if (isBean) {
                        if (o1 != null && o2 != null) {
                            o3 = cmp.compareBean(name, (BaseBean)o1, (BaseBean)o2);
                            if (!hasKey) {
                                hasKey = cmp.hasKey();
                            }
                            if (o3 != o1) {
                                newValue = c == 0 ? o3 : newValue;
                            } else {
                                found = true;
                                boolean ret = ((BaseBean)o1).mergeTree((BaseBean)o2, mode);
                                if (!ret) {
                                    return ret;
                                }
                            }
                        } else if (o1 == o2) {
                            found = true;
                        } else {
                            hasKey = cmp.hasKeyDefined(prop);
                            newValue = c == 0 ? o2 : newValue;
                        }
                    } else {
                        o3 = cmp.compareProperty(name, this, o1, -1, bean, o2, -1);
                        if (!hasKey) {
                            hasKey = cmp.hasKey();
                        }
                        if (o3 != o1) {
                            newValue = c == 0 ? o3 : newValue;
                        } else {
                            found = true;
                        }
                    }
                    if (!found && (mode & 4) == 4) {
                        return false;
                    }
                    if (!found && (mode & 2) == 2 && hasKey) {
                        if (isBean) {
                            if (newValue != null) {
                                this.setValue(prop, 0, ((BaseBean)newValue).clone());
                            } else {
                                this.setValue(prop, 0, newValue);
                            }
                        } else {
                            this.copyProperty(prop, bean, 0, newValue);
                        }
                        if (!DDLogFlags.debug) continue;
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 5, 4, "updating with new value");
                        continue;
                    }
                    if (!found || !DDLogFlags.debug) continue;
                    TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 5, 3, "keeping current value");
                }
            }
            if (mode == 3 && this.isRoot) {
                Schema2BeansUtil.mergeUnsupportedElements(this, bean);
            }
            return true;
        }
        throw new IllegalArgumentException(Common.getMessage("MergeWrongClassType_msg", this.getClass().getName(), bean == null ? "<null>" : bean.getClass().getName()));
    }

    private boolean areNodesEqual(Node node1, Node node2) {
        if (node1 == null && node2 == null) {
            return true;
        }
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (!node1.getNodeName().equals(node2.getNodeName())) {
            return false;
        }
        String value1 = node1.getNodeValue();
        String value2 = node2.getNodeValue();
        return !(value1 == null ? value2 != null : !value1.equals(value2));
    }

    private int findInNodeList(NodeList nodes, Node node, int start) {
        return this.findInNodeList(nodes, node, start, nodes.getLength());
    }

    private int findInNodeList(NodeList nodes, Node node, int start, int maxPosition) {
        while (start < maxPosition) {
            if (this.areNodesEqual(nodes.item(start), node)) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public boolean isEqualTo(Object obj) {
        boolean ret = false;
        try {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BaseBean) {
                ret = this.mergeTreeRoot((BaseBean)obj, 4);
            }
        }
        catch (Exception e) {
            if (DDLogFlags.debug) {
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 5, "got exception while comparing: " + e + "\n");
                e.printStackTrace();
            }
            ret = false;
        }
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 15, 1, 5, ret ? "true" : "false");
        }
        return ret;
    }

    @Override
    public Bean propertyById(String name, int id) {
        BeanProp bp = this.beanProp(name);
        if (Common.isBean(bp.type)) {
            if (Common.isArray(bp.type)) {
                return (BaseBean)bp.getValueById(id);
            }
            return (BaseBean)bp.getValue(0);
        }
        throw new IllegalStateException(Common.getMessage("PropertyIsNotABean_msg", name));
    }

    public BeanProp beanProp() {
        if (this.binding != null) {
            return this.binding.getBeanProp(this);
        }
        return null;
    }

    public BaseBean parent() {
        BeanProp bp = this.beanProp();
        if (bp != null) {
            return this.beanProp().getBean();
        }
        return null;
    }

    @Override
    public Bean _getParent() {
        return this.parent();
    }

    @Override
    public Bean _getRoot() {
        Bean bParent;
        Bean b = this;
        while (!b.isRoot() && (bParent = b._getParent()) != null) {
            b = bParent;
        }
        return b;
    }

    public String fullName() {
        StringBuffer str = new StringBuffer();
        this.buildPathName(str);
        return str.toString();
    }

    @Override
    public boolean hasName(String name) {
        if (name != null) {
            return name.equals(this.name()) || name.equals(this.dtdName());
        }
        return false;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public String name() {
        BeanProp bp = this.beanProp();
        if (bp != null) {
            return this.beanProp().getBeanName();
        }
        return "";
    }

    @Override
    public String dtdName() {
        return this.beanProp().getDtdName();
    }

    public void createBean(Node node, GraphManager mgr) throws Schema2BeansRuntimeException {
        if (this.isRoot) {
            mgr.completeRootBinding(this, node);
        }
        this.graphManager = mgr;
        try {
            mgr.fillProperties(this.beanProps(), node);
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException(e);
        }
    }

    public BaseBean newInstance(String name) {
        return this.beanProp(name).newBeanInstance();
    }

    public abstract void dump(StringBuffer var1, String var2);

    public String dumpDomNode(String nodeName, int depth) {
        Node n = null;
        if (this.binding == null) {
            return "<no binding>";
        }
        n = this.binding.node;
        if (n == null) {
            return "<no node>";
        }
        return DDFactory.XmlToString(n, depth, nodeName);
    }

    public String dumpDomNode(int depth) {
        return this.dumpDomNode(null, depth);
    }

    public String dumpDomNode() {
        return this.dumpDomNode(null, 99999);
    }

    public String dumpBeanNode() {
        return null;
    }

    public void dumpAttributes(String name, int index, StringBuffer str, String indent) {
        String[] names = this.getAttributeNames(name);
        for (int i = 0; i < names.length; ++i) {
            String v = this.getAttributeValue(name, index, names[i]);
            if (v == null) continue;
            str.append(indent + "\t  attr: ");
            str.append(names[i]);
            str.append("=");
            str.append(v);
        }
    }

    public String toString() {
        return this.name();
    }

    public void dumpXml() {
        try {
            this.write(System.out);
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
    }

    public static BaseBean createGraph(Class clazz, InputStream in) throws Schema2BeansException {
        return BaseBean.createGraph(clazz, in, false, null, null);
    }

    public static BaseBean createGraph(Class clazz, InputStream in, boolean validate) throws Schema2BeansException {
        return BaseBean.createGraph(clazz, in, validate, null, null);
    }

    public static BaseBean createGraph(Class clazz, InputStream in, boolean validate, EntityResolver er) throws Schema2BeansException {
        return BaseBean.createGraph(clazz, in, validate, er, null);
    }

    public static BaseBean createGraph(Class clazz, InputStream in, boolean validate, EntityResolver er, ErrorHandler eh) throws Schema2BeansException {
        Constructor c = null;
        Document doc = null;
        BaseBean bean = null;
        doc = GraphManager.createXmlDocument(new InputSource(in), validate, er, eh);
        try {
            Class[] cc = new Class[]{Node.class, Integer.TYPE};
            c = clazz.getDeclaredConstructor(cc);
        }
        catch (NoSuchMethodException me) {
            throw new RuntimeException(Common.getMessage("CantGetConstructor_msg"));
        }
        Object[] p = new Object[]{doc, new Integer(2)};
        try {
            bean = (BaseBean)c.newInstance(p);
        }
        catch (InstantiationException e) {
            throw new Schema2BeansNestedException(Common.getMessage("CantInstanciateBeanClass_msg"), e);
        }
        catch (IllegalAccessException e) {
            throw new Schema2BeansNestedException(Common.getMessage("CantInstanciateBeanClass_msg"), e);
        }
        catch (InvocationTargetException e) {
            throw new Schema2BeansNestedException(Common.getMessage("CantInstanciateBeanClass_msg"), e);
        }
        return bean;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        BeanProp p = this.beanProp();
        if (p != null) {
            p.addPCListener(l);
        } else {
            if (this.changeListeners == null) {
                this.changeListeners = new PropertyChangeSupport(this);
            }
            this.changeListeners.addPropertyChangeListener(l);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        BeanProp p = this.beanProp();
        if (p != null) {
            p.removePCListener(l);
        } else if (this.changeListeners != null) {
            this.changeListeners.removePropertyChangeListener(l);
        }
    }

    public void addPropertyChangeListener(String n, PropertyChangeListener l) {
        BeanProp p = this.beanProp(n);
        if (p != null) {
            p.addPCListener(l);
        }
    }

    public void removePropertyChangeListener(String n, PropertyChangeListener l) {
        BeanProp p = this.beanProp(n);
        if (p != null) {
            p.removePCListener(l);
        }
    }

    public Comment[] comments() {
        if (this.graphManager == null) {
            return new Comment[0];
        }
        Document doc = this.graphManager.getXmlDocument();
        Node node = this.binding.getNode();
        NodeList children = node.getChildNodes();
        LinkedList<Node> foundComments = new LinkedList<Node>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Comment)) continue;
            foundComments.add(child);
        }
        Comment[] result = new Comment[foundComments.size()];
        result = foundComments.toArray(result);
        return result;
    }

    public Comment addComment(String comment) {
        if (this.graphManager == null) {
            // empty if block
        }
        Document doc = this.graphManager.getXmlDocument();
        Comment commentNode = doc.createComment(comment);
        Node node = this.binding.getNode();
        Node firstChild = node.getFirstChild();
        if (firstChild == null) {
            node.appendChild(commentNode);
        } else {
            node.insertBefore(commentNode, firstChild);
        }
        return commentNode;
    }

    public void removeComment(Comment comment) {
        comment.getParentNode().removeChild(comment);
    }

    public BaseBean[] childBeans(boolean recursive) {
        LinkedList children = new LinkedList();
        this.childBeans(recursive, children);
        BaseBean[] result = new BaseBean[children.size()];
        return children.toArray(result);
    }

    @Override
    public void childBeans(boolean recursive, List beans) {
        BeanProp[] props = this.beanProps();
        for (int propPosition = 0; propPosition < props.length; ++propPosition) {
            BaseBean nextBean;
            BeanProp prop = props[propPosition];
            if (!prop.isBean()) continue;
            if (prop.isIndexed()) {
                for (int i = 0; i < prop.size(); ++i) {
                    nextBean = (BaseBean)prop.getValue(i);
                    if (nextBean == null) continue;
                    beans.add(nextBean);
                    if (!recursive) continue;
                    nextBean.childBeans(true, beans);
                }
                continue;
            }
            nextBean = (BaseBean)prop.getValue(0);
            if (nextBean == null) continue;
            if (recursive) {
                nextBean.childBeans(true, beans);
            }
            beans.add(nextBean);
        }
    }

    public String nameSelf() {
        return this.beanProp().getFullName();
    }

    public String nameChild(Object childObj) {
        return this.nameChild(childObj, false, false);
    }

    public String nameChild(Object childObj, boolean returnConstName, boolean returnSchemaName) {
        return this.nameChild(childObj, returnConstName, returnSchemaName, false);
    }

    public String nameChild(Object childObj, boolean returnConstName, boolean returnSchemaName, boolean returnXPathName) {
        BeanProp[] props = this.beanProps();
        BeanProp prop = null;
        boolean found = false;
        int index = -2;
        block0: for (int propPosition = 0; propPosition < props.length; ++propPosition) {
            Object propValue;
            prop = props[propPosition];
            if (prop.isIndexed()) {
                for (int i = 0; i < prop.size(); ++i) {
                    propValue = prop.getValue(i);
                    if (!(propValue == null ? childObj == null : propValue.equals(childObj))) continue;
                    found = true;
                    index = i;
                    break block0;
                }
                continue;
            }
            propValue = prop.getValue(0);
            if (!(propValue == null ? childObj == null : propValue.equals(childObj))) continue;
            found = true;
            break;
        }
        if (found) {
            if (returnConstName) {
                return prop.getBeanName();
            }
            if (returnSchemaName) {
                return prop.dtdName;
            }
            if (returnXPathName) {
                if (index < 0) {
                    return prop.dtdName;
                }
                return prop.dtdName + "[position()=" + index + "]";
            }
            return prop.getBeanName() + "." + Integer.toHexString(prop.indexToId(index));
        }
        return null;
    }

    public void changeDocType(String publicId, String systemId) {
        this.graphManager().setDoctype(publicId, systemId);
    }

    public void _setChanged(boolean changed) {
        throw new UnsupportedOperationException();
    }

    public String _getXPathExpr() {
        if (this.parent() == null) {
            return "/" + this.dtdName();
        }
        String parentXPathExpr = this.parent()._getXPathExpr();
        String myExpr = this.parent().nameChild(this, false, false, true);
        return parentXPathExpr + "/" + myExpr;
    }

    public String _getXPathExpr(Object childObj) {
        String childName = this.nameChild(childObj, false, false, true);
        if (childName == null) {
            throw new IllegalArgumentException("childObj (" + childObj.toString() + ") is not a child of this bean (" + this.dtdName() + ")");
        }
        return this._getXPathExpr() + "/" + childName;
    }

    public class IterateChoiceProperties
    implements Iterator {
        private ArrayList groups = new ArrayList();
        private int index = 0;

        void add(BeanProp prop) {
            if (prop.group != null && !this.groups.contains(prop.group)) {
                this.groups.add(prop.group);
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.groups.size();
        }

        public Object next() throws NoSuchElementException {
            if (this.hasNext()) {
                BeanProp.GroupProp gp = (BeanProp.GroupProp)this.groups.get(this.index++);
                return gp.list();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }
}

