/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.model.scheduler;

import com.sun.webui.jsf.model.scheduler.RepeatUnit;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;

public final class RepeatInterval
implements Serializable {
    private static final long serialVersionUID = 6773122235537978959L;
    public static final String ONETIME = "ONETIME";
    public static final String HOURLY = "HOURLY";
    public static final String DAILY = "DAILY";
    public static final String WEEKLY = "WEEKLY";
    public static final String MONTHLY = "MONTHLY";
    private static final boolean DEBUG = false;
    private static RepeatInterval onetimeRi = null;
    private static RepeatInterval hourlyRi = null;
    private static RepeatInterval dailyRi = null;
    private static RepeatInterval weeklyRi = null;
    private static RepeatInterval monthlyRi = null;
    private Integer calField = null;
    private String key = null;
    private String representation = null;
    private String defaultRepeatUnitString = null;

    private RepeatInterval() {
    }

    private RepeatInterval(int newCalFieldInt, String newKey, String newRepresentation, String newRepeatUnit) {
        this.calField = newCalFieldInt;
        this.key = newKey;
        this.representation = newRepresentation;
        this.defaultRepeatUnitString = newRepeatUnit;
    }

    public static RepeatInterval getInstance(String repr) {
        if (repr.equals(ONETIME)) {
            if (onetimeRi == null) {
                onetimeRi = new RepeatInterval(-1, "Scheduler.oneTime", ONETIME, null);
            }
            return onetimeRi;
        }
        if (repr.equals(HOURLY)) {
            if (hourlyRi == null) {
                hourlyRi = new RepeatInterval(11, "Scheduler.hourly", HOURLY, "HOURS");
            }
            return hourlyRi;
        }
        if (repr.equals(DAILY)) {
            if (dailyRi == null) {
                dailyRi = new RepeatInterval(5, "Scheduler.daily", DAILY, "DAYS");
            }
            return dailyRi;
        }
        if (repr.equals(WEEKLY)) {
            if (weeklyRi == null) {
                weeklyRi = new RepeatInterval(3, "Scheduler.weekly", WEEKLY, "WEEKS");
            }
            return weeklyRi;
        }
        if (repr.equals(MONTHLY)) {
            if (monthlyRi == null) {
                monthlyRi = new RepeatInterval(2, "Scheduler.monthly", MONTHLY, "MONTHS");
            }
            return monthlyRi;
        }
        return null;
    }

    public Integer getCalendarField() {
        return this.calField;
    }

    public void setCalendarField(Integer newCalField) {
        this.calField = newCalField;
    }

    public void setKey(String newKey) {
        this.key = newKey;
    }

    public String getKey() {
        return this.key;
    }

    public void setRepresentation(String newRepresentation) {
        this.representation = newRepresentation;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public String getLabel(FacesContext context) {
        return ThemeUtilities.getTheme(context).getMessage(this.key);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RepeatInterval)) {
            return false;
        }
        RepeatInterval ri = (RepeatInterval)object;
        if (this.getCalendarField() == null ? ri.getCalendarField() != null : !this.getCalendarField().equals(ri.getCalendarField())) {
            return false;
        }
        if (this.getRepresentation() == null ? ri.getRepresentation() != null : !this.getRepresentation().equals(ri.getRepresentation())) {
            return false;
        }
        return !(this.getKey() == null ? ri.getKey() != null : !this.getKey().equals(ri.getKey()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash;
        if (this.calField != null) {
            hash += this.calField.hashCode();
        }
        hash = 71 * hash;
        if (this.key != null) {
            hash += this.key.hashCode();
        }
        hash = 71 * hash;
        if (this.representation != null) {
            hash += this.representation.hashCode();
        }
        hash = 71 * hash;
        if (this.defaultRepeatUnitString != null) {
            hash += this.defaultRepeatUnitString.hashCode();
        }
        return hash;
    }

    public RepeatUnit getDefaultRepeatUnit() {
        if (this.defaultRepeatUnitString == null) {
            return null;
        }
        return RepeatUnit.getInstance(this.defaultRepeatUnitString);
    }

    private static void log(String msg) {
        LogUtil.finest(RepeatInterval.class.getName() + "::" + msg);
    }
}

