/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.service.command;

import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Process;
import org.apache.felix.service.command.Result;

public interface Job {
    public int id();

    public CharSequence command();

    public Status status();

    public void suspend();

    public void background();

    public void foreground();

    public void interrupt();

    public Result result();

    public List<Process> processes();

    public CommandSession session();

    public Job parent();

    public static enum Status {
        Created,
        Suspended,
        Background,
        Foreground,
        Done;

    }

    public static class Utils {
        public static Job current() {
            Job j;
            Process p = Process.Utils.current();
            Job job = j = p != null ? p.job() : null;
            while (j != null && j.parent() != null) {
                j = j.parent();
            }
            return j;
        }
    }
}

