/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.component.dataprovider;

import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.impl.ObjectFieldKeySupport;
import java.util.Map;

public class MapObjectFieldKeySupport
extends ObjectFieldKeySupport {
    private Map _inst = null;

    public MapObjectFieldKeySupport(Class cls, Map inst) {
        super(cls, false);
        if (!Map.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " is only valid for java.util.Map classes!");
        }
        this._inst = inst;
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        FieldKey key = super.getFieldKey(fieldId);
        if (key == null && this._inst != null && this._inst.get(fieldId) != null) {
            key = new FieldKey(fieldId);
        }
        return key;
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        FieldKey[] keys = super.getFieldKeys();
        if (this._inst != null) {
            FieldKey[] tmp = new FieldKey[keys.length + this._inst.size()];
            int cnt = 0;
            for (FieldKey key : keys) {
                tmp[cnt++] = key;
            }
            for (Object key : this._inst.keySet()) {
                tmp[cnt++] = new FieldKey(key.toString());
            }
            keys = tmp;
        }
        return keys;
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        Object obj;
        Class<?> type = super.getType(fieldKey);
        if (type == null && (obj = this._inst.get(fieldKey.getFieldId())) != null) {
            type = obj.getClass();
        }
        return type;
    }

    public Object getValue(FieldKey fieldKey, Object base) throws DataProviderException {
        if (base != null) {
            this._inst = (Map)base;
        }
        if (this._inst == null) {
            return null;
        }
        Object val = super.getValue(fieldKey, (Object)this._inst);
        if (val == null) {
            val = this._inst.get(fieldKey.getFieldId());
        }
        return val;
    }

    public boolean isAssignable(FieldKey fieldKey, Object value) throws DataProviderException {
        Class type = super.getType(fieldKey);
        if (type != null) {
            return super.isAssignable(fieldKey, value);
        }
        return true;
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        Class type = super.getType(fieldKey);
        if (type != null) {
            return super.isReadOnly(fieldKey);
        }
        return false;
    }

    public void setValue(FieldKey fieldKey, Object base, Object value) throws DataProviderException {
        Class type;
        if (base != null) {
            this._inst = (Map)base;
        }
        if ((type = super.getType(fieldKey)) != null) {
            super.setValue(fieldKey, (Object)this._inst, value);
        } else {
            this._inst.put(fieldKey.getFieldId(), value);
        }
    }
}

