/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.jpa.querydef.CommonAbstractCriteriaImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

public class ExpressionImpl<X>
extends SelectionImpl<X>
implements Expression<X>,
InternalExpression {
    protected Metamodel metamodel;
    protected boolean isLiteral;
    protected Object literal;

    protected ExpressionImpl(Metamodel metamodel, Class<? extends X> javaType, org.eclipse.persistence.expressions.Expression expressionNode) {
        super(javaType, expressionNode);
        this.metamodel = metamodel;
    }

    public ExpressionImpl(Metamodel metamodel, Class<? extends X> javaType, org.eclipse.persistence.expressions.Expression expressionNode, Object value) {
        this(metamodel, javaType, expressionNode, value, true, null);
    }

    private ExpressionImpl(Metamodel metamodel, Class<? extends X> javaType, org.eclipse.persistence.expressions.Expression expressionNode, Object value, boolean isLiteral, String alias) {
        super(javaType, expressionNode, alias);
        this.metamodel = metamodel;
        this.literal = value;
        this.isLiteral = isLiteral;
    }

    public <T> Expression<T> as(Class<T> type) {
        return this.buildExpressionForAs(type);
    }

    public <X1> Expression<X1> cast(Class<X1> type) {
        return new ExpressionImpl<X1>(this.metamodel, type, this.currentNode, this.literal, this.isLiteral, this.alias);
    }

    protected <T> Expression<T> buildExpressionForAs(Class<T> type) {
        return this;
    }

    public Predicate equalTo(Expression<?> value) {
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.equal(ExpressionImpl.currentNode(value)), List.of(this, value), "equals");
    }

    public Predicate equalTo(Object value) {
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.equal(value), List.of(this, ExpressionImpl.createLiteral(value, this.metamodel)), "equals");
    }

    public Predicate notEqualTo(Expression<?> value) {
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.notEqual(ExpressionImpl.currentNode(value)), List.of(this, value), "not equal");
    }

    public Predicate notEqualTo(Object value) {
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.notEqual(value), List.of(this, ExpressionImpl.createLiteral(value, this.metamodel)), "not equal");
    }

    public Predicate in(Object ... values) {
        ArrayList list = new ArrayList();
        list.add(this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.in(values), list, "in");
    }

    public Predicate in(Expression<?> ... values) {
        if (values != null) {
            if (values.length == 1 && ((InternalExpression)values[0]).isParameter() && Collection.class.isAssignableFrom(((ParameterExpressionImpl)values[0]).getJavaType())) {
                return this.in((Expression<Collection<?>>)values[0]);
            }
            ArrayList list = new ArrayList();
            list.add(this);
            if (values.length == 1 && ((InternalExpression)values[0]).isSubquery()) {
                list.add(values[0]);
                return new CompoundExpressionImpl(this.metamodel, this.currentNode.in(((SubQueryImpl)values[0]).subQuery), list, "in");
            }
            ArrayList<org.eclipse.persistence.expressions.Expression> inValues = new ArrayList<org.eclipse.persistence.expressions.Expression>();
            for (Expression<?> exp : values) {
                if (!((InternalExpression)exp).isLiteral() && !((InternalExpression)exp).isParameter()) {
                    Object[] params = new Object[]{exp};
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"CRITERIA_NON_LITERAL_PASSED_TO_IN", (Object[])params));
                }
                list.add(exp);
                inValues.add(((InternalSelection)exp).getCurrentNode());
            }
            return new CompoundExpressionImpl(this.metamodel, this.currentNode.in(inValues), list, "in");
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"NULL_PASSED_TO_EXPRESSION_IN"));
    }

    public Predicate in(Collection<?> values) {
        ArrayList list = new ArrayList();
        list.add(this);
        return new InImpl(this.metamodel, this, values, list);
    }

    public Predicate in(Expression<Collection<?>> values) {
        ArrayList list = new ArrayList();
        list.add(values);
        list.add(this);
        return new InImpl(this.metamodel, this, (ExpressionImpl)values, list);
    }

    public Predicate isNotNull() {
        ArrayList list = new ArrayList();
        list.add(this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.notNull(), list, "not null");
    }

    public Predicate isNull() {
        ArrayList list = new ArrayList();
        list.add(this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.isNull(), list, "is null");
    }

    @Override
    public boolean isPredicate() {
        return false;
    }

    @Override
    public boolean isSubquery() {
        return false;
    }

    @Override
    public boolean isCompoundExpression() {
        return false;
    }

    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public boolean isJunction() {
        return false;
    }

    @Override
    public boolean isLiteral() {
        return this.isLiteral;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public void findRootAndParameters(CommonAbstractCriteriaImpl<?> criteriaQuery) {
    }

    static <T> Expression<T> createLiteral(T value, Metamodel metamodel, Class<T> resultClass) {
        return new ExpressionImpl<T>(metamodel, resultClass, (org.eclipse.persistence.expressions.Expression)new ConstantExpression(value, (org.eclipse.persistence.expressions.Expression)new ExpressionBuilder()), value);
    }

    static <T> Expression<T> createLiteral(T value, Metamodel metamodel) {
        return ExpressionImpl.createLiteral(value, metamodel, value == null ? null : value.getClass());
    }

    static org.eclipse.persistence.expressions.Expression currentNode(Expression<?> expression) {
        return ((InternalSelection)expression).getCurrentNode();
    }
}

