/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.FrameSet;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.RenderingUtilities;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;

public final class FrameSetRenderer
extends AbstractRenderer {
    private static final String[] STRING_ATTRIBUTES = new String[]{"rows", "cols", "borderColor"};
    private static final String[] INTEGER_ATTRIBUTES = new String[]{"border", "frameSpacing"};
    private static final String[] BOOLEAN_ATTRIBUTES = new String[]{"frameBorder"};

    @Override
    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!RenderingUtilities.isPortlet(context)) {
            writer.startElement("frameset", component);
        }
    }

    @Override
    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        FrameSet frameset = (FrameSet)component;
        if (!RenderingUtilities.isPortlet(context)) {
            String toolTip;
            String style;
            String styleClass;
            String id = frameset.getClientId(context);
            if (id != null) {
                writer.writeAttribute("id", (Object)id, null);
            }
            if ((styleClass = frameset.getStyleClass()) != null) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            if ((style = frameset.getStyle()) != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            if ((toolTip = frameset.getToolTip()) != null) {
                writer.writeAttribute("title", (Object)toolTip, "toolTip");
            }
            FrameSetRenderer.addStringAttributes(context, component, writer, STRING_ATTRIBUTES);
            this.addBooleanAttributes(context, component, writer, BOOLEAN_ATTRIBUTES);
            this.addIntegerAttributes(context, component, writer, INTEGER_ATTRIBUTES);
            writer.write("\n");
        }
    }

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!RenderingUtilities.isPortlet(context)) {
            writer.endElement("frameset");
            writer.write("\n");
        }
    }
}

