/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.UninstallNodeBaseCommand;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.launcher.SSHSession;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.sftp.SFTPPath;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="uninstall-node-ssh")
@PerLookup
public class UninstallNodeSshCommand
extends UninstallNodeBaseCommand {
    @Param(name="sshuser", optional=true, defaultValue="${user.name}")
    private String user;
    @Param(optional=true, defaultValue="22", name="sshport")
    private int port;
    @Param(optional=true)
    private String sshkeyfile;

    @Override
    String getRawRemoteUser() {
        return this.user;
    }

    @Override
    int getRawRemotePort() {
        return this.port;
    }

    @Override
    String getSshKeyFile() {
        return this.sshkeyfile;
    }

    @Override
    protected void validate() throws CommandException {
        super.validate();
        if (this.sshkeyfile == null) {
            File existingKey = SSHUtil.getExistingKeyFile();
            if (existingKey == null) {
                this.promptPass = true;
            } else {
                this.sshkeyfile = existingKey.getAbsolutePath();
            }
        } else {
            this.validateKey(this.sshkeyfile);
        }
        if (this.sshkeyfile != null && SSHUtil.isEncryptedKey((File)new File(this.sshkeyfile))) {
            this.sshkeypassphrase = this.getSSHPassphrase(true);
        }
    }

    @Override
    void deleteFromHosts() throws CommandException {
        try {
            SFTPPath installDir = SFTPPath.of((String)this.getInstallDir());
            for (String host : this.hosts) {
                File keyFile = this.sshkeyfile == null ? null : new File(this.sshkeyfile);
                SSHLauncher sshLauncher = new SSHLauncher(this.getRemoteUser(), host, this.getRemotePort(), this.sshpassword, keyFile, this.sshkeypassphrase);
                if (keyFile != null && !sshLauncher.checkConnection()) {
                    this.promptPass = true;
                }
                if (this.promptPass) {
                    this.sshpassword = this.getSSHPassword(host);
                    sshLauncher = new SSHLauncher(this.getRemoteUser(), host, this.getRemotePort(), this.sshpassword, keyFile, this.sshkeypassphrase);
                }
                try (SSHSession session = sshLauncher.openSession();
                     SFTPClient sftpClient = session.createSFTPClient();){
                    if (!sftpClient.exists(installDir)) {
                        throw new IOException("Directory does not exist: " + this.getInstallDir());
                    }
                    sftpClient.rmDir(installDir, false, new SFTPPath[0]);
                }
            }
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception ex) {
            throw new CommandException((Throwable)ex);
        }
    }
}

