/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.cli.StartServerCommand;
import com.sun.enterprise.admin.servermgmt.cli.StartServerHelper;
import com.sun.enterprise.admin.servermgmt.cli.Strings;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.common.FileRealmHelper;
import org.jvnet.hk2.annotations.Service;

@Service(name="start-domain")
@PerLookup
public class StartDomainCommand
extends LocalDomainCommand
implements StartServerCommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(StartDomainCommand.class);
    @Param(optional=true, shortName="v", defaultValue="false")
    private boolean verbose;
    @Param(optional=true, defaultValue="false")
    private boolean upgrade;
    @Param(optional=true, shortName="w", defaultValue="false")
    private boolean watchdog;
    @Param(optional=true, shortName="d", defaultValue="false")
    private boolean debug;
    @Param(optional=true, shortName="s", defaultValue="false")
    private boolean suspend;
    @Param(name="domain_name", primary=true, optional=true)
    private String domainName0;
    @Param(name="dry-run", shortName="n", optional=true, defaultValue="false")
    private boolean dry_run;
    @Param(name="drop-interrupted-commands", optional=true, defaultValue="false")
    private boolean drop_interrupted_commands;
    @Inject
    ServerEnvironment serverEnvironment;
    private GFLauncherInfo launchParameters;
    private GFLauncher glassFishLauncher;
    private StartServerHelper startServerHelper;
    private final String newpwName = Environment.getPrefix() + "NEWPASSWORD";

    @Override
    public RuntimeType getType() {
        return RuntimeType.DAS;
    }

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.setDomainName(this.domainName0);
        super.validate();
    }

    protected int executeCommand() throws CommandException {
        try {
            this.createLauncher();
            String masterPassword = this.getMasterPassword();
            this.startServerHelper = new StartServerHelper(this.programOpts.isTerse(), this.getServerDirs(), this.glassFishLauncher, masterPassword);
            if (!this.startServerHelper.prepareForLaunch()) {
                return 1;
            }
            if (!this.upgrade && this.glassFishLauncher.needsManualUpgrade()) {
                logger.info(strings.get("manualUpgradeNeeded"));
                return 1;
            }
            this.doAutoUpgrade(masterPassword);
            if (this.dry_run) {
                logger.fine(Strings.get("dry_run_msg"));
                List cmd = this.glassFishLauncher.getCommandLine().toList();
                int indexOfReadStdin = cmd.indexOf("-read-stdin");
                String cmdToLog = IntStream.range(0, cmd.size()).filter(index -> index < indexOfReadStdin || index > indexOfReadStdin + 1).mapToObj(cmd::get).collect(Collectors.joining("\n")) + "\n";
                logger.info(cmdToLog);
                return 0;
            }
            this.doAdminPasswordCheck();
            this.glassFishLauncher.launch();
            if (this.verbose || this.upgrade || this.watchdog) {
                while (true) {
                    int returnValue = this.glassFishLauncher.getExitValue();
                    switch (returnValue) {
                        case 10: {
                            logger.info(strings.get("restart"));
                            break;
                        }
                        case 11: {
                            logger.info(strings.get("restartChangeDebug", new Object[]{"on"}));
                            this.launchParameters.setDebug(true);
                            break;
                        }
                        case 12: {
                            logger.info(strings.get("restartChangeDebug", new Object[]{"off"}));
                            this.launchParameters.setDebug(false);
                            break;
                        }
                        default: {
                            return returnValue;
                        }
                    }
                    if (this.env.debug()) {
                        System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
                    }
                    this.glassFishLauncher.relaunch();
                }
            }
            this.startServerHelper.waitForServerStart();
            this.startServerHelper.report();
            return 0;
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException((Throwable)me);
        }
    }

    @Override
    public void createLauncher() throws GFLauncherException, MiniXmlParserException {
        this.glassFishLauncher = GFLauncherFactory.getInstance((RuntimeType)this.getType());
        this.launchParameters = this.glassFishLauncher.getInfo();
        this.launchParameters.setDomainName(this.getDomainName());
        this.launchParameters.setDomainParentDir(this.getDomainsDir().getPath());
        this.launchParameters.setVerbose(this.verbose || this.upgrade);
        this.launchParameters.setSuspend(this.suspend);
        this.launchParameters.setDebug(this.debug);
        this.launchParameters.setUpgrade(this.upgrade);
        this.launchParameters.setWatchdog(this.watchdog);
        this.launchParameters.setDropInterruptedCommands(this.drop_interrupted_commands);
        this.launchParameters.setRespawnInfo(this.programOpts.getClassName(), this.programOpts.getClassPath(), this.respawnArgs());
        this.glassFishLauncher.setup();
    }

    private String[] respawnArgs() {
        ArrayList<Object> args = new ArrayList<Object>(15);
        args.addAll(Arrays.asList(this.programOpts.getProgramArguments()));
        args.add(this.getName());
        args.add("--verbose=" + String.valueOf(this.verbose));
        args.add("--watchdog=" + String.valueOf(this.watchdog));
        args.add("--debug=" + String.valueOf(this.debug));
        args.add("--domaindir");
        args.add(this.getDomainsDir().toString());
        if (StartDomainCommand.ok((String)this.getDomainName())) {
            args.add(this.getDomainName());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Respawn args: {0}", ((Object)args).toString());
        }
        String[] a = new String[args.size()];
        args.toArray(a);
        return a;
    }

    private void doAutoUpgrade(String mpv) throws GFLauncherException, MiniXmlParserException, CommandException {
        if (this.upgrade || !this.glassFishLauncher.needsAutoUpgrade()) {
            return;
        }
        logger.info(strings.get("upgradeNeeded"));
        this.launchParameters.setUpgrade(true);
        this.glassFishLauncher.setup();
        this.glassFishLauncher.launch();
        Process glassFishProcess = this.glassFishLauncher.getProcess();
        int exitCode = -1;
        try {
            exitCode = glassFishProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (exitCode != 0) {
            ProcessStreamDrainer psd = this.glassFishLauncher.getProcessStreamDrainer();
            String output = psd.getOutErrString();
            if (StartDomainCommand.ok((String)output)) {
                throw new CommandException(strings.get("upgradeFailedOutput", new Object[]{this.launchParameters.getDomainName(), exitCode, output}));
            }
            throw new CommandException(strings.get("upgradeFailed", new Object[]{this.launchParameters.getDomainName(), exitCode}));
        }
        logger.info(strings.get("upgradeSuccessful"));
        this.createLauncher();
    }

    private void doAdminPasswordCheck() throws CommandException {
        String adminRealmKeyFile = this.glassFishLauncher.getAdminRealmKeyFile();
        if (adminRealmKeyFile != null) {
            try {
                FileRealmHelper fileRealmHelper = new FileRealmHelper(adminRealmKeyFile);
                if (!fileRealmHelper.hasAuthenticatableUser()) {
                    String newPassword;
                    Set adminUsers = fileRealmHelper.getUserNames();
                    if (adminUsers == null || adminUsers.isEmpty()) {
                        throw new CommandException("no admin users");
                    }
                    String firstAdminUser = (String)adminUsers.iterator().next();
                    CommandModelData.ParamModelData npwo = new CommandModelData.ParamModelData(this.newpwName, String.class, false, null);
                    npwo.prompt = strings.get("new.adminpw", new Object[]{firstAdminUser});
                    npwo.promptAgain = strings.get("new.adminpw.again", new Object[]{firstAdminUser});
                    npwo.param._password = true;
                    logger.info(strings.get("new.adminpw.prompt"));
                    char[] newPasswordArray = super.getPassword((CommandModel.ParamModel)npwo, null, true);
                    String string = newPassword = newPasswordArray != null ? new String(newPasswordArray) : null;
                    if (newPassword == null) {
                        throw new CommandException(strings.get("no.console"));
                    }
                    fileRealmHelper.updateUser(firstAdminUser, firstAdminUser, newPassword.toCharArray(), null);
                    fileRealmHelper.persist();
                }
            }
            catch (IOException ioe) {
                throw new CommandException((Throwable)ioe);
            }
        }
    }
}

