/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.StandardException;

public abstract class StatementPermission {
    StatementPermission() {
    }

    public abstract void check(LanguageConnectionContext var1, boolean var2, Activation var3) throws StandardException;

    public abstract PermissionsDescriptor getPermissionDescriptor(String var1, DataDictionary var2) throws StandardException;

    public boolean isCorrectPermission(PermissionsDescriptor permissionsDescriptor) throws StandardException {
        return false;
    }

    public PrivilegedSQLObject getPrivilegedObject(DataDictionary dataDictionary) throws StandardException {
        return null;
    }

    public String getObjectType() {
        return null;
    }

    public void genericCheck(LanguageConnectionContext languageConnectionContext, boolean bl, Activation activation, String string) throws StandardException {
        TupleDescriptor tupleDescriptor;
        Object object;
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        PermissionsDescriptor permissionsDescriptor = this.getPermissionDescriptor(languageConnectionContext.getCurrentUserId(activation), dataDictionary);
        if (!this.isCorrectPermission(permissionsDescriptor)) {
            permissionsDescriptor = this.getPermissionDescriptor("PUBLIC", dataDictionary);
        }
        if (this.isCorrectPermission(permissionsDescriptor)) {
            return;
        }
        boolean bl2 = false;
        String string2 = languageConnectionContext.getCurrentRoleId(activation);
        if (string2 != null) {
            Object object2;
            Object object3;
            object = dataDictionary.getAuthorizationDatabaseOwner();
            tupleDescriptor = dataDictionary.getRoleGrantDescriptor(string2, languageConnectionContext.getCurrentUserId(activation), (String)object);
            if (tupleDescriptor == null) {
                tupleDescriptor = dataDictionary.getRoleGrantDescriptor(string2, "PUBLIC", (String)object);
            }
            if (tupleDescriptor == null) {
                languageConnectionContext.setCurrentRole(activation, null);
            } else {
                object3 = dataDictionary.createRoleClosureIterator(activation.getTransactionController(), string2, true);
                while (!bl2 && (object2 = object3.next()) != null) {
                    permissionsDescriptor = this.getPermissionDescriptor((String)object2, dataDictionary);
                    if (!this.isCorrectPermission(permissionsDescriptor)) continue;
                    bl2 = true;
                }
            }
            if (bl2) {
                object3 = dataDictionary.getDependencyManager();
                object2 = dataDictionary.getRoleDefinitionDescriptor(string2);
                ContextManager contextManager = languageConnectionContext.getContextManager();
                object3.addDependency(execPreparedStatement, (Provider)object2, contextManager);
                object3.addDependency(activation, (Provider)object2, contextManager);
            }
        }
        if (!bl2) {
            object = this.getPrivilegedObject(dataDictionary);
            if (object == null) {
                throw StandardException.newException("4250E", this.getObjectType());
            }
            tupleDescriptor = ((UniqueSQLObjectDescriptor)object).getSchemaDescriptor();
            if (tupleDescriptor == null) {
                throw StandardException.newException("4250E", "SCHEMA");
            }
            throw StandardException.newException(bl ? "42505" : "42504", languageConnectionContext.getCurrentUserId(activation), string, this.getObjectType(), ((SchemaDescriptor)tupleDescriptor).getSchemaName(), ((UniqueSQLObjectDescriptor)object).getName());
        }
    }
}

