/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro;

import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.Trigger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.glassfish.concurro.AbstractManagedExecutorService;
import org.glassfish.concurro.AbstractPlatformThreadExecutorService;
import org.glassfish.concurro.ContextServiceImpl;
import org.glassfish.concurro.ManagedScheduledExecutorServiceAdapter;
import org.glassfish.concurro.ManagedThreadFactoryImpl;
import org.glassfish.concurro.internal.ManagedFutureTask;
import org.glassfish.concurro.internal.ManagedScheduledThreadPoolExecutor;

public class ManagedScheduledExecutorServiceImpl
extends AbstractPlatformThreadExecutorService
implements ManagedScheduledExecutorService {
    protected ManagedScheduledThreadPoolExecutor threadPoolExecutor;
    protected final ManagedScheduledExecutorServiceAdapter adapter;

    public ManagedScheduledExecutorServiceImpl(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy) {
        super(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, contextService, contextService != null ? contextService.getContextSetupProvider() : null, rejectPolicy);
        this.threadPoolExecutor = new ManagedScheduledThreadPoolExecutor(corePoolSize, (ThreadFactory)((Object)this.managedThreadFactory));
        this.threadPoolExecutor.setKeepAliveTime(keepAliveTime, keepAliveTimeUnit);
        this.threadPoolExecutor.setThreadLifeTime(threadLifeTime);
        this.adapter = new ManagedScheduledExecutorServiceAdapter(this);
    }

    public ScheduledFuture<?> schedule(Runnable command, Trigger trigger) {
        return this.threadPoolExecutor.schedule((AbstractManagedExecutorService)this, command, trigger);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, Trigger trigger) {
        return this.threadPoolExecutor.schedule((AbstractManagedExecutorService)this, callable, trigger);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.threadPoolExecutor.schedule(this, command, null, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.threadPoolExecutor.schedule(this, callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.threadPoolExecutor.scheduleAtFixedRate(this, command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.threadPoolExecutor.scheduleWithFixedDelay(this, command, initialDelay, delay, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.threadPoolExecutor.schedule(this, command, null, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.threadPoolExecutor.schedule(this, task, null, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.threadPoolExecutor.schedule(this, task, result, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.threadPoolExecutor.schedule(this, task, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    protected ExecutorService getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    @Override
    public ManagedScheduledExecutorServiceAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public ManagedExecutorService getExecutorForTaskListener() {
        return this.adapter;
    }

    @Override
    protected <V> ManagedFutureTask<V> getNewTaskFor(Runnable r, V result) {
        return this.threadPoolExecutor.newTaskFor(this, r, result);
    }

    @Override
    protected <V> ManagedFutureTask<V> getNewTaskFor(Callable<V> callable) {
        return this.threadPoolExecutor.newTaskFor(this, callable);
    }

    protected void executeManagedFutureTask(ManagedFutureTask task) {
        this.threadPoolExecutor.executeManagedTask(task);
    }

    @Override
    public long getTaskCount() {
        return this.threadPoolExecutor.getTaskCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.threadPoolExecutor.getCompletedTaskCount();
    }
}

