/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.el;

import com.sun.jsftemplating.el.PageSessionResolver;
import com.sun.jsftemplating.el.PermissionChecker;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutComposition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.util.LogUtil;
import com.sun.jsftemplating.util.MessageUtil;
import com.sun.jsftemplating.util.Util;
import jakarta.el.ExpressionFactory;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;

public class VariableResolver {
    public static final String ATTRIBUTE = "attribute";
    public static final String APPLICATION = "application";
    public static final String COPY_PROPERTY = "copyProperty";
    public static final String OPTION = "option";
    public static final String PAGE_SESSION = "pageSession";
    public static final String PROPERTY = "property";
    public static final String HAS_PROPERTY = "hasProperty";
    public static final String HAS_FACET = "hasFacet";
    public static final String SESSION = "session";
    public static final String STACK_TRACE = "stackTrace";
    public static final String REQUEST_PARAMETER = "requestParameter";
    public static final String THIS = "this";
    public static final String ESCAPE = "escape";
    public static final String EVAL = "eval";
    public static final String BOOLEAN = "boolean";
    public static final String BROWSER = "browser";
    public static final String INT = "int";
    public static final String METHOD_BINDING = "methodBinding";
    public static final String METHOD_EXPRESSION = "methodExpression";
    public static final String CONSTANT = "constant";
    public static final String RESOURCE = "resource";
    private static final Class[] ACTION_ARGS = new Class[]{ActionEvent.class};
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String VR_APP_KEY = "__jsft_vrds_map";
    public static final char ESCAPE_CHAR = '\\';
    public static final String SUB_START = "$";
    public static final String SUB_TYPE_DELIM = "{";
    public static final String SUB_END = "}";

    public static Object resolveVariables(FacesContext ctx, LayoutElement desc, UIComponent component, String string, String startToken, String typeDelim, String endToken) {
        int stringLen = ((String)string).length();
        int startTokenLen = startToken.length();
        int delimLen = typeDelim.length();
        int endTokenLen = endToken.length();
        boolean expressionIsWholeString = false;
        char firstEndChar = SUB_END.charAt(0);
        char firstDelimChar = SUB_TYPE_DELIM.charAt(0);
        int startIndex = ((String)string).lastIndexOf(startToken);
        while (startIndex != -1) {
            if (startIndex > 0 && ((String)string).charAt(startIndex - 1) == '\\') {
                string = ((String)string).substring(0, startIndex - 1) + ((String)string).substring(startIndex);
                --stringLen;
                --startIndex;
            } else {
                int delimIndex = ((String)string).indexOf(typeDelim, startIndex + startTokenLen);
                if (delimIndex != -1) {
                    int parenSemi = 0;
                    int endIndex = -1;
                    int curr = delimIndex + delimLen;
                    while (curr < stringLen) {
                        char currChar = ((String)string).charAt(curr);
                        if (currChar == firstDelimChar && typeDelim.equals(((String)string).substring(curr, curr + delimLen))) {
                            ++parenSemi;
                            curr += delimLen;
                            continue;
                        }
                        if (currChar == firstEndChar && endToken.equals(((String)string).substring(curr, curr + endTokenLen))) {
                            if (--parenSemi < 0) {
                                endIndex = curr;
                                break;
                            }
                            curr += endTokenLen;
                            continue;
                        }
                        ++curr;
                    }
                    if (endIndex != -1) {
                        String type;
                        DataSource ds;
                        if (startIndex == 0 && endIndex == ((String)string).lastIndexOf(endToken) && ((String)string).endsWith(endToken)) {
                            expressionIsWholeString = true;
                        }
                        if ((ds = VariableResolver.getDataSource(ctx, type = ((String)string).substring(startIndex + startTokenLen, delimIndex))) == null) {
                            if (type.indexOf(60) <= -1 && type.indexOf(38) <= -1 && type.indexOf(91) <= -1 && type.indexOf(35) <= -1 && type.indexOf(36) <= -1 && type.indexOf(37) <= -1 && type.indexOf(40) <= -1 && type.indexOf(41) <= -1) {
                                throw new IllegalArgumentException("Invalid type '" + type + "' in attribute value: '" + (String)string + "'.");
                            }
                        } else {
                            Object variable = ((String)string).substring(delimIndex + delimLen, endIndex);
                            variable = ds.getValue(ctx, desc, component, (String)variable);
                            if (expressionIsWholeString) {
                                if (variable instanceof String) {
                                    variable = VariableResolver.replaceCompParams(ctx, desc, component, (String)variable);
                                }
                                return variable;
                            }
                            string = ((String)string).substring(0, startIndex) + (variable == null ? "" : variable.toString()) + ((String)string).substring(endIndex + endTokenLen);
                            stringLen = ((String)string).length();
                        }
                    }
                }
            }
            startIndex = ((String)string).lastIndexOf(startToken, startIndex - 1);
        }
        return VariableResolver.replaceCompParams(ctx, desc, component, (String)string);
    }

    private static Object replaceCompParams(FacesContext ctx, LayoutElement desc, UIComponent comp, String string) {
        if (string == null) {
            return null;
        }
        Map<String, Object> globalParams = LayoutComposition.getGlobalParamMap(ctx);
        if (globalParams.size() == 0) {
            return string;
        }
        String token = null;
        Object value = null;
        int endEL = 0;
        int loopStart = 0;
        char[] chars = string.toCharArray();
        boolean foundAtLeastOne = false;
        boolean isWholeString = false;
        StringBuilder buff = null;
        Stack<LayoutElement> stack = null;
        while (true) {
            int startEL = VariableResolver.findOpenEL(chars, loopStart);
            while (startEL != -1) {
                endEL = VariableResolver.findChar(chars, startEL + 2, '}', '[', '.', '=', '>', '<', '!', '&', '|', '*', '+', '-', '?', '/', '%', '(');
                if (endEL == -1) {
                    startEL = -1;
                    break;
                }
                token = string.substring(startEL + 2, endEL);
                value = globalParams.get(token = token.trim());
                if (value != null) {
                    if (stack == null) {
                        stack = LayoutComposition.getCompositionStack(ctx);
                    }
                    value = LayoutComposition.findTemplateParam(stack, token);
                    break;
                }
                startEL = string.indexOf("#{", endEL + 1);
            }
            if (startEL == -1) {
                if (!foundAtLeastOne) {
                    return string;
                }
                break;
            }
            foundAtLeastOne = true;
            if (buff == null) {
                buff = new StringBuilder(100);
            }
            isWholeString = startEL == 0;
            buff.append(chars, loopStart, startEL - loopStart);
            if (chars[endEL] == '}') {
                if (isWholeString && ++endEL >= chars.length) {
                    return VariableResolver.resolveVariables(ctx, desc, comp, value);
                }
                isWholeString = false;
                if (value != null) {
                    buff.append(value);
                }
            } else {
                int end;
                int start = 0;
                String strVal = value.toString();
                if (strVal.startsWith("#{")) {
                    start = 2;
                }
                if (strVal.charAt((end = strVal.length()) - 1) == '}') {
                    --end;
                }
                buff.append("#{").append(strVal, start, end);
                end = VariableResolver.findChar(chars, endEL + 1, '}');
                if (end == -1) {
                    throw new IllegalArgumentException("EL has unterminated #{} expression: (" + string + ")");
                }
                buff.append(chars, endEL, ++end - endEL);
                endEL = end;
            }
            loopStart = endEL;
        }
        buff.append(chars, loopStart, chars.length - loopStart);
        return VariableResolver.resolveVariables(ctx, desc, comp, buff.toString());
    }

    private static int findOpenEL(char[] chars, int idx) {
        int len = chars.length - 3;
        while (idx < len) {
            if (chars[idx] == '#' && chars[idx + 1] == '{') {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    private static int findChar(char[] chars, int idx, char ... matchChars) {
        int len = chars.length;
        while (idx < len) {
            for (char ch : matchChars) {
                if (chars[idx] != ch) continue;
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static Object resolveVariables(LayoutElement desc, UIComponent component, Object value) {
        if (value == null) {
            return null;
        }
        return VariableResolver.resolveVariables(FacesContext.getCurrentInstance(), desc, component, value);
    }

    public static Object resolveVariables(FacesContext ctx, LayoutElement desc, UIComponent component, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            value = VariableResolver.resolveVariables(ctx, desc, component, (String)value, SUB_START, SUB_TYPE_DELIM, SUB_END);
        } else {
            if (value instanceof List) {
                List list = (List)value;
                ArrayList<Object> newList = new ArrayList<Object>(list.size());
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    newList.add(VariableResolver.resolveVariables(ctx, desc, component, it.next()));
                }
                return newList;
            }
            if (value instanceof Object[]) {
                Object[] arr = (Object[])value;
                Object[] newArr = new Object[arr.length];
                int idx = 0;
                for (Object obj : arr) {
                    newArr[idx++] = VariableResolver.resolveVariables(ctx, desc, component, obj);
                }
                return newArr;
            }
        }
        return value;
    }

    public static DataSource getDataSource(FacesContext ctx, String key) {
        return VariableResolver.getDataSourceMap(ctx).get(key);
    }

    private static Map<String, DataSource> getDataSourceMap(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        Map<String, AttributeDataSource> dataSourceMap = null;
        if (ctx != null) {
            dataSourceMap = (Map)ctx.getExternalContext().getApplicationMap().get(VR_APP_KEY);
        }
        if (dataSourceMap == null) {
            dataSourceMap = new HashMap();
            AttributeDataSource attrDS = new AttributeDataSource();
            dataSourceMap.put("", attrDS);
            dataSourceMap.put(ATTRIBUTE, attrDS);
            dataSourceMap.put(APPLICATION, (AttributeDataSource)((Object)new ApplicationDataSource()));
            dataSourceMap.put(COPY_PROPERTY, (AttributeDataSource)((Object)new CopyPropertyDataSource()));
            dataSourceMap.put(OPTION, (AttributeDataSource)((Object)new OptionDataSource()));
            dataSourceMap.put(PAGE_SESSION, (AttributeDataSource)((Object)new PageSessionDataSource()));
            dataSourceMap.put(PROPERTY, (AttributeDataSource)((Object)new PropertyDataSource()));
            dataSourceMap.put(HAS_PROPERTY, (AttributeDataSource)((Object)new HasPropertyDataSource()));
            dataSourceMap.put(HAS_FACET, (AttributeDataSource)((Object)new HasFacetDataSource()));
            dataSourceMap.put(SESSION, (AttributeDataSource)((Object)new SessionDataSource()));
            dataSourceMap.put(STACK_TRACE, (AttributeDataSource)((Object)new StackTraceDataSource()));
            dataSourceMap.put(REQUEST_PARAMETER, (AttributeDataSource)((Object)new RequestParameterDataSource()));
            dataSourceMap.put(THIS, (AttributeDataSource)((Object)new ThisDataSource()));
            dataSourceMap.put(ESCAPE, (AttributeDataSource)((Object)new EscapeDataSource()));
            dataSourceMap.put(EVAL, (AttributeDataSource)((Object)new EvalDataSource()));
            dataSourceMap.put(INT, (AttributeDataSource)((Object)new IntDataSource()));
            dataSourceMap.put(BOOLEAN, (AttributeDataSource)((Object)new BooleanDataSource()));
            dataSourceMap.put(CONSTANT, (AttributeDataSource)((Object)new ConstantDataSource()));
            dataSourceMap.put(RESOURCE, (AttributeDataSource)((Object)new ResourceBundleDataSource()));
            dataSourceMap.put(METHOD_BINDING, (AttributeDataSource)((Object)new MethodBindingDataSource()));
            dataSourceMap.put(METHOD_EXPRESSION, (AttributeDataSource)((Object)new MethodExpressionDataSource()));
            if (ctx != null) {
                ctx.getExternalContext().getApplicationMap().put(VR_APP_KEY, dataSourceMap);
            }
        }
        return dataSourceMap;
    }

    public static synchronized void setDataSource(FacesContext ctx, String key, DataSource dataSource) {
        VariableResolver.getDataSourceMap(ctx).put(key, dataSource);
    }

    public static void main(String[] args) {
        String test = null;
        String good = null;
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escape(LayoutElement))", SUB_START, "(", ")");
        good = "LayoutElement";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escape(EEPersistenceManager))", SUB_START, "(", ")");
        good = "EEPersistenceManager";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$es$cape$escape(EEPersistenceManager))", SUB_START, "(", ")");
        good = "$es$capeEEPersistenceManager)";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escapeEEP$ersistenceManager))", SUB_START, "(", ")");
        good = "$escapeEEP$ersistenceManager)";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escape(EEPersistenceManager)))", SUB_START, "(", ")");
        good = "EEPersistenceManager)";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escape(EEPersistenceManager())", SUB_START, "(", ")");
        good = "$escape(EEPersistenceManager()";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escape($escape(EEPersistenceManager()))==$escape(EEPersistenceManager()))", SUB_START, "(", ")");
        good = "EEPersistenceManager()==EEPersistenceManager()";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escape($escape(EEPersistenceManager()))==$escape(EEPersistenceManager()))", SUB_START, "(", ")");
        good = "EEPersistenceManager()==EEPersistenceManager()";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
    }

    public static interface DataSource {
        public Object getValue(FacesContext var1, LayoutElement var2, UIComponent var3, String var4);
    }

    public static class AttributeDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return ctx.getExternalContext().getRequestMap().get(key);
        }
    }

    public static class ApplicationDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return ctx.getExternalContext().getApplicationMap().get(key);
        }
    }

    public static class CopyPropertyDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return this.findPropertyValue(ctx, desc, component, key, true);
        }

        public Object findPropertyValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key, boolean checkVE) {
            if (component == null) {
                return "";
            }
            int idx = key.indexOf(44);
            boolean walk = false;
            if (idx > 0) {
                walk = Boolean.valueOf(key.substring(idx + 1).trim());
                key = key.substring(0, idx);
            }
            Object value = null;
            if (checkVE) {
                value = component.getValueExpression(key);
                if (value == null) {
                    value = component.getAttributes().get(key);
                }
            } else {
                value = component.getAttributes().get(key);
            }
            if (walk) {
                while (value == null && component.getParent() != null) {
                    component = component.getParent();
                    if (checkVE) {
                        value = component.getValueExpression(key);
                        if (value != null) continue;
                        value = component.getAttributes().get(key);
                        continue;
                    }
                    value = component.getAttributes().get(key);
                }
            }
            return value;
        }
    }

    public static class OptionDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            Object value = null;
            while (value == null && desc != null) {
                if (desc instanceof LayoutComponent) {
                    value = ((LayoutComponent)desc).getEvaluatedOption(ctx, key, component);
                }
                desc = desc.getParent();
            }
            return value;
        }
    }

    public static class PageSessionDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            Map<String, Serializable> map = PageSessionResolver.getPageSession(ctx, ctx.getViewRoot());
            Serializable value = null;
            if (map != null) {
                value = map.get(key);
            }
            return value;
        }
    }

    public static class PropertyDataSource
    extends CopyPropertyDataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return this.findPropertyValue(ctx, desc, component, key, false);
        }
    }

    public static class HasPropertyDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            boolean hasKey = component.getAttributes().containsKey(key);
            if (!(hasKey || component.getValueExpression(key) == null && component.getAttributes().get(key) == null)) {
                hasKey = true;
            }
            if (!hasKey && desc instanceof LayoutComponent) {
                return this.getValue(ctx, desc.getParent(), component.getParent(), key);
            }
            return hasKey;
        }
    }

    public static class HasFacetDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            boolean hasFacet = component.getFacets().containsKey(key);
            if (!hasFacet && desc instanceof LayoutComponent) {
                return this.getValue(ctx, desc.getParent(), component.getParent(), key);
            }
            return hasFacet;
        }
    }

    public static class SessionDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return ctx.getExternalContext().getSessionMap().get(key);
        }
    }

    public static class StackTraceDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            int len = trace.length;
            StringBuffer buf = new StringBuffer(key + "\n");
            for (int idx = 0; idx < len; ++idx) {
                buf.append(trace[idx] + "\n");
            }
            return buf.toString();
        }
    }

    public static class RequestParameterDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return ctx.getExternalContext().getRequestParameterMap().get(key);
        }
    }

    public static class ThisDataSource
    implements DataSource {
        public static final String CHILDREN = "children";
        public static final String COMPONENT = "component";
        public static final String CLIENT_ID = "clientId";
        public static final String ID = "id";
        public static final String LAYOUT_ELEMENT = "layoutElement";
        public static final String PARENT = "parent";
        public static final String PARENT_ID = "parentId";
        public static final String PARENT_CLIENT_ID = "parentClientId";
        public static final String PARENT_LAYOUT_ELEMENT = "parentLayoutElement";
        public static final String NAMING_CONTAINER = "namingContainer";
        public static final String VALUE_BINDING = "valueBinding";

        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent comp, String key) {
            Object value = null;
            if (key.equalsIgnoreCase(CLIENT_ID) || key.length() == 0) {
                value = comp.getClientId(ctx);
            } else if (key.equalsIgnoreCase(ID)) {
                value = comp.getId();
            } else if (key.equalsIgnoreCase(CHILDREN)) {
                value = comp.getChildren();
            } else if (key.equalsIgnoreCase(COMPONENT)) {
                value = comp;
            } else if (key.equalsIgnoreCase(LAYOUT_ELEMENT)) {
                value = desc;
            } else if (key.equalsIgnoreCase(PARENT_ID)) {
                value = comp.getParent().getId();
            } else if (key.equalsIgnoreCase(PARENT_CLIENT_ID)) {
                value = comp.getParent().getClientId(ctx);
            } else if (key.equalsIgnoreCase(PARENT)) {
                value = comp.getParent();
            } else if (key.equalsIgnoreCase(PARENT_LAYOUT_ELEMENT)) {
                value = desc.getParent();
            } else if (key.equalsIgnoreCase(NAMING_CONTAINER)) {
                value = comp.getParent();
                while (value != null && !(value instanceof NamingContainer)) {
                    value = ((UIComponent)value).getParent();
                }
            } else if (key.equalsIgnoreCase(VALUE_BINDING)) {
                Stack<String> stack = new Stack<String>();
                String id = null;
                for (comp = comp.getParent(); comp != null && !(comp instanceof UIViewRoot); comp = comp.getParent()) {
                    id = comp.getId();
                    if (id == null) {
                        id = comp.getClientId(ctx);
                        id = id.substring(id.lastIndexOf(58) + 1);
                    }
                    stack.push(id);
                }
                StringBuffer buf = new StringBuffer();
                buf.append("view");
                while (!stack.empty()) {
                    buf.append("['" + stack.pop() + "']");
                }
                value = buf.toString();
            } else {
                throw new IllegalArgumentException("'" + key + "' is not valid in $this{" + key + "}.");
            }
            return value;
        }
    }

    public static class EscapeDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return key;
        }
    }

    public static class EvalDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            PermissionChecker checker = new PermissionChecker(desc, component, key);
            return checker.hasPermission();
        }
    }

    public static class IntDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return Integer.valueOf(key);
        }
    }

    public static class BooleanDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return Boolean.valueOf(key);
        }
    }

    public static class ConstantDataSource
    implements DataSource {
        private static Map<String, Object> constantMap = new HashMap<String, Object>();

        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            Object value = constantMap.get(key);
            if (value == null) {
                HashMap<String, Object> map = new HashMap<String, Object>(constantMap);
                value = this.resolveValue(map, key);
                constantMap = map;
            }
            return value;
        }

        private Object resolveValue(Map<String, Object> map, String key) {
            int lastDot = key.lastIndexOf(46);
            if (lastDot == -1) {
                throw new IllegalArgumentException("Unable to resolve '" + key + "' in $constant{" + key + "}.  '" + key + "' must be a fully qualified classname plus the constant name.");
            }
            String className = key.substring(0, lastDot);
            try {
                this.addConstants(map, Util.loadClass(className, key));
            }
            catch (ClassNotFoundException ex) {
                IllegalArgumentException iae = new IllegalArgumentException("'" + className + "' was not found!  This must be a valid classname.  This was found in expression $constant{" + key + "}.");
                iae.initCause(ex);
                throw iae;
            }
            return map.get(key);
        }

        private void addConstants(Map<String, Object> map, Class cls) {
            String className = cls.getName();
            Field[] fields = cls.getFields();
            Field field = null;
            for (int count = 0; count < fields.length; ++count) {
                field = fields[count];
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                try {
                    map.put(className + "." + field.getName(), field.get(null));
                    continue;
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public static class ResourceBundleDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            int separator = key.indexOf(".");
            if (separator == -1) {
                throw new IllegalArgumentException("'" + key + "' is not in format: \"[bundleID].[bundleKey]\"!");
            }
            String value = key.substring(0, separator);
            Object obj = ctx.getExternalContext().getRequestMap().get(value);
            if (obj == null) {
                return key;
            }
            if (!(obj instanceof ResourceBundle)) {
                throw new IllegalArgumentException("\"" + value + "\" in: \"$resource{" + key + "}\" did not resolve to a ResourceBundle!  Found: \"" + obj.getClass().getName() + "\" instead.  (toString(): " + obj.toString() + ")");
            }
            ResourceBundle bundle = (ResourceBundle)obj;
            String str = null;
            int argSep = key.indexOf(",", separator);
            try {
                str = argSep > -1 ? bundle.getString(key.substring(separator + 1, argSep)) : bundle.getString(key.substring(separator + 1));
                if (str == null) {
                    str = key;
                } else if (argSep > -1) {
                    StringTokenizer st = new StringTokenizer(key.substring(argSep), ",");
                    Object[] tokens = new String[st.countTokens()];
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        tokens[i++] = st.nextToken().trim();
                    }
                    str = MessageUtil.getFormattedMessage(str, tokens);
                }
            }
            catch (MissingResourceException ex) {
                if (LogUtil.configEnabled()) {
                    LogUtil.config("Unable to find key: '" + key.substring(separator + 1) + "' in ResourceBundle '" + value + "'.  Perhaps this needs to be added?", ex);
                } else if (LogUtil.infoEnabled()) {
                    LogUtil.info("JSFT0003", key.substring(separator + 1), value);
                }
                str = key;
            }
            return str;
        }
    }

    public static class MethodBindingDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            ExpressionFactory factory = ctx.getApplication().getExpressionFactory();
            return factory.createMethodExpression(ctx.getELContext(), key, null, ACTION_ARGS);
        }
    }

    public static class MethodExpressionDataSource
    implements DataSource {
        @Override
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            Class[] args = EMPTY_CLASS_ARRAY;
            int commaIdx = (key = key.trim()).lastIndexOf(44);
            if (commaIdx != -1) {
                if (key.endsWith("true")) {
                    args = ACTION_ARGS;
                    key = key.substring(0, commaIdx);
                } else if (key.endsWith("false")) {
                    key = key.substring(0, commaIdx);
                }
            }
            return ctx.getApplication().getExpressionFactory().createMethodExpression(ctx.getELContext(), key, Object.class, args);
        }
    }
}

