/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.tools.schemaframework.IndexDefinition;
import org.eclipse.persistence.tools.schemaframework.SequenceDefinition;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TableSequenceDefinition
extends SequenceDefinition {
    protected TableDefinition tableDefinition;
    protected boolean deleteSchema;

    public TableSequenceDefinition(Sequence sequence, boolean deleteSchema) {
        super(sequence);
        this.deleteSchema = deleteSchema;
    }

    @Override
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("INSERT INTO ");
            writer.write(this.getSequenceTableQualifiedName());
            writer.write("(" + this.getSequenceNameFieldName());
            writer.write(", " + this.getSequenceCounterFieldName());
            writer.write(") values (");
            writer.write("'" + this.getName() + "', " + (this.sequence.getInitialValue() - 1) + ")");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        if (this.shouldDropTableDefinition()) {
            return this.tableDefinition.buildDeletionWriter(session, writer);
        }
        try {
            writer.write("DELETE FROM ");
            writer.write(this.getSequenceTableQualifiedName());
            writer.write(" WHERE " + this.getSequenceNameFieldName());
            writer.write(" = '" + this.getName() + "'");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public boolean checkIfExist(AbstractSession session) throws DatabaseException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT * FROM ");
        buffer.append(this.getSequenceTableQualifiedName());
        buffer.append(" WHERE ");
        buffer.append(this.getSequenceNameFieldName());
        buffer.append(" = '");
        buffer.append(this.getName());
        buffer.append("'");
        Vector results = session.priviledgedExecuteSelectingCall(new SQLCall(buffer.toString()));
        return !results.isEmpty();
    }

    @Override
    public void dropDatabaseSchema(AbstractSession session, Writer writer) throws EclipseLinkException {
        this.tableDefinition.dropDatabaseSchema(session, writer);
    }

    @Override
    public void dropDatabaseSchemaOnDatabase(AbstractSession session) throws EclipseLinkException {
        this.tableDefinition.dropDatabaseSchemaOnDatabase(session);
    }

    @Override
    public String getDatabaseSchema() {
        return this.getSequenceTable().getTableQualifier();
    }

    public String getSequenceCounterFieldName() {
        return this.getTableSequence().getCounterFieldName();
    }

    public String getSequenceNameFieldName() {
        return this.getTableSequence().getNameFieldName();
    }

    public DatabaseTable getSequenceTable() {
        return this.getTableSequence().getTable();
    }

    public List<IndexDefinition> getSequenceTableIndexes() {
        return this.getTableSequence().getTableIndexes();
    }

    public String getSequenceTableName() {
        return this.getSequenceTable().getName();
    }

    public String getSequenceTableQualifier() {
        return this.getSequenceTable().getTableQualifier();
    }

    public String getSequenceTableQualifiedName() {
        return this.getSequenceTable().getQualifiedName();
    }

    @Override
    public TableDefinition buildTableDefinition() {
        if (this.tableDefinition == null) {
            this.tableDefinition = new TableDefinition();
            this.tableDefinition.setTable(this.getSequenceTable());
            this.tableDefinition.setName(this.getSequenceTableName());
            this.tableDefinition.setQualifier(this.getSequenceTableQualifier());
            this.tableDefinition.addPrimaryKeyField(this.getSequenceNameFieldName(), String.class, 50);
            this.tableDefinition.addField(this.getSequenceCounterFieldName(), BigDecimal.class);
            this.tableDefinition.setIndexes(this.getSequenceTableIndexes());
        }
        return this.tableDefinition;
    }

    protected TableSequence getTableSequence() {
        if (this.sequence instanceof TableSequence) {
            return (TableSequence)this.sequence;
        }
        return (TableSequence)((DefaultSequence)this.sequence).getDefaultSequence();
    }

    @Override
    public boolean isTableSequenceDefinition() {
        return true;
    }

    @Override
    public void preDropObject(AbstractSession session, Writer dropSchemaWriter, boolean createSQLFiles) {
        if (session.getPlatform().shouldCreateIndicesForPrimaryKeys() || session.getPlatform().shouldCreateIndicesOnUniqueKeys()) {
            return;
        }
        this.buildTableDefinition().preDropObject(session, dropSchemaWriter, createSQLFiles);
    }

    protected boolean shouldDropTableDefinition() {
        return this.deleteSchema && this.hasDatabaseSchema();
    }
}

