/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import org.eclipse.persistence.annotations.CacheIsolationType;
import org.eclipse.persistence.annotations.TenantTableDiscriminatorType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.MultitenantPolicy;
import org.eclipse.persistence.descriptors.TablePerMultitenantPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class SchemaPerMultitenantPolicy
extends TablePerMultitenantPolicy {
    private boolean useSharedCache = false;
    private boolean useSharedEMF = true;

    public SchemaPerMultitenantPolicy() {
        this.type = TenantTableDiscriminatorType.SCHEMA;
        this.contextProperty = "eclipselink.tenant-schema-id";
    }

    public SchemaPerMultitenantPolicy(ClassDescriptor desc) {
        this();
        this.descriptor = desc;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        session.addMultitenantContextProperty(this.contextProperty);
        if (this.shouldUseSharedEMF()) {
            for (ClassDescriptor classDescriptor : session.getProject().getDescriptors().values()) {
                if (this.shouldUseSharedCache()) {
                    if (!classDescriptor.isSharedIsolation()) continue;
                    classDescriptor.setCacheIsolation(CacheIsolationType.PROTECTED);
                    continue;
                }
                classDescriptor.setCacheIsolation(CacheIsolationType.ISOLATED);
            }
            session.getProject().setHasIsolatedClasses(true);
        }
    }

    @Override
    public MultitenantPolicy clone(ClassDescriptor descriptor) {
        try {
            SchemaPerMultitenantPolicy clonedPolicy = (SchemaPerMultitenantPolicy)super.clone();
            clonedPolicy.descriptor = descriptor;
            return clonedPolicy;
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.getMessage());
        }
    }

    @Override
    public boolean isSchemaPerMultitenantPolicy() {
        return true;
    }

    @Override
    protected void setTableSchemaPerTenant() {
    }

    @Override
    public boolean isTablePerMultitenantPolicy() {
        return false;
    }

    @Override
    protected String getTableName(DatabaseTable table, String tenant) {
        return table.getName();
    }

    @Override
    public DatabaseTable getTable(DatabaseTable table) {
        return table;
    }

    @Override
    public DatabaseTable getTable(String tableName) {
        return new DatabaseTable(tableName);
    }

    @Override
    protected DatabaseTable updateTable(DatabaseTable table) {
        throw new UnsupportedOperationException();
    }

    public boolean shouldUseSharedEMF() {
        return this.useSharedEMF;
    }

    public void setShouldUseSharedEMF(boolean shouldUseSharedEMF) {
        this.useSharedEMF = shouldUseSharedEMF;
    }

    public boolean shouldUseSharedCache() {
        return this.useSharedCache;
    }

    public void setShouldUseSharedCache(boolean shouldUseSharedCache) {
        this.useSharedCache = shouldUseSharedCache;
    }
}

