/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.selenium;

import java.io.OutputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.io.output.NullOutputStream;
import org.jboss.cdi.tck.selenium.ExtendedWebDriver;
import org.jboss.cdi.tck.selenium.HttpCycleData;
import org.jboss.cdi.tck.selenium.WebPage;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Pdf;
import org.openqa.selenium.ScriptKey;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumNetworkConditions;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.v126.network.Network;
import org.openqa.selenium.devtools.v126.network.model.RequestId;
import org.openqa.selenium.devtools.v126.network.model.TimeSinceEpoch;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.logging.EventType;
import org.openqa.selenium.mobile.NetworkConnection;
import org.openqa.selenium.print.PrintOptions;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandPayload;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.virtualauthenticator.VirtualAuthenticator;
import org.openqa.selenium.virtualauthenticator.VirtualAuthenticatorOptions;

public class ChromeDevtoolsDriver
implements ExtendedWebDriver {
    ChromeDriver delegate;
    List<HttpCycleData> cycleData = new CopyOnWriteArrayList<HttpCycleData>();
    String lastGet;
    static AtomicBoolean firstLog = new AtomicBoolean(Boolean.TRUE);

    public ChromeDevtoolsDriver(ChromeOptions options) {
        ChromeDriverService chromeDriverService = (ChromeDriverService)new ChromeDriverService.Builder().build();
        chromeDriverService.sendOutputTo((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        this.delegate = new ChromeDriver(chromeDriverService, options);
    }

    @Override
    public void postInit() {
        DevTools devTools = this.getDevTools();
        this.initNetworkListeners(devTools);
        ChromeDevtoolsDriver.initDevTools(devTools);
        ChromeDevtoolsDriver.disableCache(devTools);
    }

    private static void disableCache(DevTools devTools) {
        devTools.send(Network.setCacheDisabled((Boolean)true));
    }

    private static void initDevTools(DevTools devTools) {
        try {
            devTools.createSession();
            devTools.send(Network.clearBrowserCache());
        }
        catch (TimeoutException ex) {
            Logger log = Logger.getLogger(ChromeDevtoolsDriver.class.getName());
            log.warning("Init timeout error, can happen, if the driver already has been used, can be safely ignore");
        }
        devTools.send(Network.enable(Optional.empty(), Optional.empty(), Optional.empty()));
    }

    private void initNetworkListeners(DevTools devTools) {
        devTools.addListener(Network.requestWillBeSent(), entry -> {
            if (!entry.getRequest().getUrl().contains(this.lastGet)) {
                return;
            }
            HttpCycleData data = new HttpCycleData();
            data.requestId = entry.getRequestId();
            data.request = entry.getRequest();
            this.cycleData.add(data);
        });
        devTools.addListener(Network.responseReceived(), entry -> {
            RequestId requestId = entry.getRequestId();
            Optional<HttpCycleData> found = this.cycleData.stream().filter(item -> item.requestId.toJson().equals(requestId.toJson())).findFirst();
            found.ifPresent(httpCycleData -> {
                httpCycleData.responseReceived = entry;
            });
        });
    }

    public Capabilities getCapabilities() {
        return this.delegate.getCapabilities();
    }

    public void setFileDetector(FileDetector detector) {
        this.delegate.setFileDetector(detector);
    }

    public <X> void onLogEvent(EventType<X> kind) {
        this.delegate.onLogEvent(kind);
    }

    public void register(Predicate<URI> whenThisMatches, Supplier<Credentials> useTheseCredentials) {
        this.delegate.register(whenThisMatches, useTheseCredentials);
    }

    public LocalStorage getLocalStorage() {
        return this.delegate.getLocalStorage();
    }

    public SessionStorage getSessionStorage() {
        return this.delegate.getSessionStorage();
    }

    public Location location() {
        return this.delegate.location();
    }

    public void setLocation(Location location) {
        this.delegate.setLocation(location);
    }

    public NetworkConnection.ConnectionType getNetworkConnection() {
        return this.delegate.getNetworkConnection();
    }

    public NetworkConnection.ConnectionType setNetworkConnection(NetworkConnection.ConnectionType type) {
        return this.delegate.setNetworkConnection(type);
    }

    public void launchApp(String id) {
        this.delegate.launchApp(id);
    }

    public Map<String, Object> executeCdpCommand(String commandName, Map<String, Object> parameters) {
        return this.delegate.executeCdpCommand(commandName, parameters);
    }

    public Optional<DevTools> maybeGetDevTools() {
        return this.delegate.maybeGetDevTools();
    }

    public List<Map<String, String>> getCastSinks() {
        return this.delegate.getCastSinks();
    }

    public String getCastIssueMessage() {
        return this.delegate.getCastIssueMessage();
    }

    public void selectCastSink(String deviceName) {
        this.delegate.selectCastSink(deviceName);
    }

    public void startDesktopMirroring(String deviceName) {
        this.delegate.startDesktopMirroring(deviceName);
    }

    public void startTabMirroring(String deviceName) {
        this.delegate.startTabMirroring(deviceName);
    }

    public void stopCasting(String deviceName) {
        this.delegate.stopCasting(deviceName);
    }

    public void setPermission(String name, String value) {
        this.delegate.setPermission(name, value);
    }

    public ChromiumNetworkConditions getNetworkConditions() {
        return this.delegate.getNetworkConditions();
    }

    public void setNetworkConditions(ChromiumNetworkConditions networkConditions) {
        this.delegate.setNetworkConditions(networkConditions);
    }

    public void deleteNetworkConditions() {
        this.delegate.deleteNetworkConditions();
    }

    public SessionId getSessionId() {
        return this.delegate.getSessionId();
    }

    public ErrorHandler getErrorHandler() {
        return this.delegate.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.delegate.setErrorHandler(handler);
    }

    public CommandExecutor getCommandExecutor() {
        return this.delegate.getCommandExecutor();
    }

    public void get(String url) {
        this.lastGet = url;
        this.delegate.get(url);
    }

    public String getTitle() {
        return this.delegate.getTitle();
    }

    public String getCurrentUrl() {
        return this.delegate.getCurrentUrl();
    }

    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        return (X)this.delegate.getScreenshotAs(outputType);
    }

    public Pdf print(PrintOptions printOptions) throws WebDriverException {
        return this.delegate.print(printOptions);
    }

    public WebElement findElement(By locator) {
        return this.delegate.findElement(locator);
    }

    public List<WebElement> findElements(By locator) {
        return this.delegate.findElements(locator);
    }

    public List<WebElement> findElements(SearchContext context, BiFunction<String, Object, CommandPayload> findCommand, By locator) {
        return this.delegate.findElements(context, findCommand, locator);
    }

    public String getPageSource() {
        return this.delegate.getPageSource();
    }

    @Override
    public String getPageText() {
        String head = this.delegate.findElement(By.tagName((String)"head")).getAttribute("innerText").replaceAll("[\\s\\n ]", " ");
        String body = this.delegate.findElement(By.tagName((String)"body")).getAttribute("innerText").replaceAll("[\\s\\n ]", " ");
        return head + " " + body;
    }

    @Override
    public String getPageTextReduced() {
        String head = this.delegate.findElement(By.tagName((String)"head")).getAttribute("innerText");
        String body = this.delegate.findElement(By.tagName((String)"body")).getAttribute("innerText");
        return (head + " " + body).replaceAll("[\\s\\u00A0]+", " ");
    }

    @Override
    public void reset() {
        DevTools devTools = this.delegate.getDevTools();
        devTools.clearListeners();
        devTools.send(Network.clearBrowserCookies());
        devTools.disconnectSession();
        this.cycleData.clear();
        this.lastGet = null;
    }

    @Override
    public void close() {
        this.reset();
        this.delegate.close();
    }

    @Override
    public void quit() {
        this.delegate.quit();
    }

    public Set<String> getWindowHandles() {
        return this.delegate.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.delegate.getWindowHandle();
    }

    public Object executeScript(String script, Object ... args) {
        return this.delegate.executeScript(script, args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return this.delegate.executeAsyncScript(script, args);
    }

    public WebDriver.TargetLocator switchTo() {
        return this.delegate.switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.delegate.navigate();
    }

    public WebDriver.Options manage() {
        return this.delegate.manage();
    }

    public void setLogLevel(Level level) {
        this.delegate.setLogLevel(level);
    }

    public void perform(Collection<Sequence> actions) {
        this.delegate.perform(actions);
    }

    public void resetInputState() {
        this.delegate.resetInputState();
    }

    public VirtualAuthenticator addVirtualAuthenticator(VirtualAuthenticatorOptions options) {
        return this.delegate.addVirtualAuthenticator(options);
    }

    public void removeVirtualAuthenticator(VirtualAuthenticator authenticator) {
        this.delegate.removeVirtualAuthenticator(authenticator);
    }

    public FileDetector getFileDetector() {
        return this.delegate.getFileDetector();
    }

    public ScriptKey pin(String script) {
        return this.delegate.pin(script);
    }

    public void unpin(ScriptKey key) {
        this.delegate.unpin(key);
    }

    public Set<ScriptKey> getPinnedScripts() {
        return this.delegate.getPinnedScripts();
    }

    public Object executeScript(ScriptKey key, Object ... args) {
        return this.delegate.executeScript(key, args);
    }

    public void register(Supplier<Credentials> alwaysUseTheseCredentials) {
        this.delegate.register(alwaysUseTheseCredentials);
    }

    public DevTools getDevTools() {
        return this.delegate.getDevTools();
    }

    @Override
    public int getResponseStatus() {
        try {
            HttpCycleData data = this.getLastGetData();
            if (data == null) {
                return -1;
            }
            if (data.responseReceived == null) {
                return -1;
            }
            return data.responseReceived.getResponse().getStatus();
        }
        catch (NoSuchElementException ex) {
            return -1;
        }
    }

    @Override
    public String getResponseBody() {
        HttpCycleData data = this.getLastGetData();
        return ((Network.GetResponseBodyResponse)this.delegate.getDevTools().send(Network.getResponseBody((RequestId)data.requestId))).getBody();
    }

    @Override
    public String getRequestData() {
        HttpCycleData data = this.getLastGetData();
        return data.request.getPostData().orElse("");
    }

    public String[] getRequestDataAsArray() {
        String requestData = this.getRequestData();
        String[] splitData = requestData.split("&");
        return (String[])Stream.of(splitData).map(keyVal -> URLDecoder.decode(keyVal, StandardCharsets.UTF_8)).toArray(String[]::new);
    }

    private HttpCycleData getLastGetData() {
        this.sortResponses();
        return this.cycleData.stream().filter(item -> item.request.getUrl().contains(this.lastGet)).reduce((item1, item2) -> item2).orElse(null);
    }

    private void sortResponses() {
        this.cycleData.sort((o1, o2) -> {
            if (o1.responseReceived == null) {
                return -1;
            }
            if (o2.responseReceived == null) {
                return 1;
            }
            return Long.compare(o1.responseReceived.getTimestamp().toJson().longValue(), o2.responseReceived.getTimestamp().toJson().longValue());
        });
    }

    @Override
    public void printProcessedResponses() {
        this.sortResponses();
        this.cycleData.stream().filter(item -> item.responseReceived != null).forEach(item -> {
            System.out.println("Url: " + item.request.getUrl());
            System.out.println("RequestId: " + item.requestId.toJson());
            Optional responseTime = item.responseReceived.getResponse().getResponseTime();
            System.out.println("ResponseTime: " + responseTime.orElse(new TimeSinceEpoch((Number)-1)));
            System.out.println("ResponseStatus: " + item.responseReceived.getResponse().getStatus());
        });
    }

    public ChromeDriver getDelegate() {
        return this.delegate;
    }

    @Override
    public JavascriptExecutor getJSExecutor() {
        return this.delegate;
    }

    public static ExtendedWebDriver stdInit() {
        Locale.setDefault(new Locale("en", "US"));
        ChromeDevtoolsDriver.initCDPVersionMessageFilter();
        ChromeOptions options = new ChromeOptions();
        String chromedriverVersion = System.getProperty("chromedriver.version");
        if (chromedriverVersion != null && !chromedriverVersion.isEmpty()) {
            options.setBrowserVersion(chromedriverVersion);
        }
        if (System.getProperty("chromedriver.headless") == null || "true".equals(System.getProperty("chromedriver.headless"))) {
            options.addArguments(new String[]{"--headless"});
        }
        options.addArguments(new String[]{"--no-sandbox"});
        options.addArguments(new String[]{"--disable-web-security"});
        options.addArguments(new String[]{"--allow-insecure-localhost"});
        options.addArguments(new String[]{"--remote-allow-origins=*"});
        options.addArguments(new String[]{"--ignore-urlfetcher-cert-requests"});
        options.addArguments(new String[]{"--auto-open-devtools-for-tabs"});
        options.addArguments(new String[]{"--disable-gpu"});
        HashMap<String, String> prefs = new HashMap<String, String>();
        prefs.put("intl.accept_languages", "en");
        options.setExperimentalOption("prefs", prefs);
        options.addArguments(new String[]{"--lang=en"});
        ChromeDevtoolsDriver driver = new ChromeDevtoolsDriver(options);
        driver.manage().timeouts().implicitlyWait(WebPage.STD_TIMEOUT);
        driver.manage().timeouts().pageLoadTimeout(WebPage.STD_TIMEOUT);
        driver.manage().timeouts().scriptTimeout(WebPage.STD_TIMEOUT);
        return driver;
    }

    private static void initCDPVersionMessageFilter() {
        Logger logger = Logger.getLogger("org.openqa.selenium.devtools.CdpVersionFinder");
        logger.setFilter(record -> {
            boolean isMatchWarning = record.getMessage().contains("Unable to find an exact match for CDP version");
            if (isMatchWarning && !firstLog.get()) {
                return false;
            }
            if (isMatchWarning) {
                firstLog.set(false);
            }
            return true;
        });
    }
}

